/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AutotoolsPlugin
extends AbstractUIPlugin {
    private static AutotoolsPlugin plugin;
    private ResourceBundle resourceBundle;
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.cdt.autotools";
    private IConfigurationElement generatorElement;
    public static final String EXTENSION_POINT_ID;
    public static final String BUILDER = "builder";
    public static final String ID_ELEMENT_NAME = "id";
    public static final String AUTOTOOLS_BUILDER_ID = "org.eclipse.linuxtools.cdt.autotools.builder";

    static {
        EXTENSION_POINT_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".buildDefinitions";
    }

    public AutotoolsPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.linuxtools.cdt.autotools.Resources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static String getUniqueIdentifier() {
        if (AutotoolsPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return AutotoolsPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void verifyScannerInfoProvider(IProject project) throws CoreException {
        boolean found = false;
        ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(project, true);
        ICExtensionReference[] refs = desc.get("org.eclipse.cdt.core.ScannerInfoProvider");
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getID().equals("org.eclipse.linuxtools.cdt.autotools.AutotoolsScannerInfoProvider")) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            AutotoolsPlugin.setScannerInfoProvider(project);
        }
    }

    public static void setScannerInfoProvider(IProject project) throws CoreException {
        ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(project, true);
        desc.remove("org.eclipse.cdt.core.ScannerInfoProvider");
        desc.create("org.eclipse.cdt.core.ScannerInfoProvider", "org.eclipse.linuxtools.cdt.autotools.AutotoolsScannerInfoProvider");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static AutotoolsPlugin getDefault() {
        return plugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = AutotoolsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AutotoolsPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format(AutotoolsPlugin.getResourceString(key), args);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public IConfigurationElement getGeneratorElement() {
        IExtension[] extensions;
        IExtensionPoint extensionPoint;
        if (this.generatorElement == null && (extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID)) != null && (extensions = extensionPoint.getExtensions()) != null) {
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String id;
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(BUILDER) && (id = element.getAttribute(ID_ELEMENT_NAME)).equals(AUTOTOOLS_BUILDER_ID)) {
                        this.generatorElement = element;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.generatorElement;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        AutotoolsPlugin.log((IStatus)new Status(4, AutotoolsPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void logException(Throwable e, final String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, AutotoolsPlugin.getUniqueIdentifier(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        final IStatus fstatus = status;
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)title, null, (IStatus)fstatus);
            }
        });
    }

    public static void logException(Throwable e) {
        AutotoolsPlugin.logException(e, null, null);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, AutotoolsPlugin.getUniqueIdentifier(), 0, e.getMessage(), e);
        AutotoolsPlugin.log(status);
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        AutotoolsPlugin.log(s);
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        AutotoolsPlugin.log(t);
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, AutotoolsPlugin.getUniqueIdentifier(), -1, "Internal Error: ", t);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return AutotoolsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = AutotoolsPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }
}

