/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.cdt.autotools.AutotoolsMakefileBuilder;
import org.eclipse.linuxtools.cdt.autotools.AutotoolsPlugin;

public class AutotoolsProjectNature
implements IProjectNature {
    public static final String AUTOTOOLS_NATURE_ID = String.valueOf(AutotoolsPlugin.getUniqueIdentifier()) + ".autotoolsNature";
    private IProject project;

    public void configure() throws CoreException {
        AutotoolsProjectNature.addAutotoolsBuilder(this.project, (IProgressMonitor)new NullProgressMonitor());
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void addAutotoolsBuilder(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            ICommand command = commands[i];
            String builderName = command.getBuilderName();
            if (builderName.equals("org.eclipse.cdt.core.cbuilder") || builderName.equals(AutotoolsMakefileBuilder.MANAGED_BUILDER_ID)) {
                Vector<ICommand> vec = new Vector<ICommand>(Arrays.asList(commands));
                vec.removeElementAt(i);
                vec.trimToSize();
                ICommand[] tempCommands = vec.toArray(new ICommand[commands.length - 1]);
                description.setBuildSpec(tempCommands);
                project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            ++i;
        }
        commands = description.getBuildSpec();
        boolean found = false;
        int i2 = 0;
        while (i2 < commands.length) {
            if (commands[i2].getBuilderName().equals(AutotoolsMakefileBuilder.BUILDER_ID)) {
                found = true;
                break;
            }
            ++i2;
        }
        if (!found) {
            ICommand command = description.newCommand();
            command.setBuilderName(AutotoolsMakefileBuilder.BUILDER_ID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            description.setBuildSpec(newCommands);
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void addAutotoolsNature(IProject project, IProgressMonitor monitor) throws CoreException {
        AutotoolsProjectNature.addNature(project, AUTOTOOLS_NATURE_ID, monitor);
    }

    public static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int i = 0;
        while (i < prevNatures.length) {
            if (natureId.equals(prevNatures[i])) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static void removeAutotoolsNature(IProject project, IProgressMonitor mon) throws CoreException {
        AutotoolsProjectNature.removeNature(project, AUTOTOOLS_NATURE_ID, mon);
    }

    public static void removeNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>(Arrays.asList(prevNatures));
        newNatures.remove(natureId);
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, monitor);
    }
}

