/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.linuxtools.cdt.autotools.AutotoolsPlugin;
import org.eclipse.linuxtools.cdt.autotools.ui.properties.AutotoolsPropertyConstants;

public class AutotoolsScannerInfo
implements IScannerInfo {
    private IResource res;
    private IProject project;
    private IPath filePath;
    private String[] includePaths;
    private HashMap definedSymbols;
    private boolean isDirty;
    private String compilationString;
    private String dirName;
    private HashSet<IScannerInfoChangeListener> listeners = new HashSet();

    public AutotoolsScannerInfo(IResource res) {
        this.res = res;
        this.project = res.getProject();
        this.filePath = res.getFullPath();
    }

    public void addListener(IScannerInfoChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IScannerInfoChangeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    private String buildFile(IPath filePath, IFile makefile, IManagedBuildInfo info) {
        String outString;
        block11: {
            ByteArrayOutputStream stdout;
            outString = "";
            IPath dir = makefile.getFullPath().removeLastSegments(1);
            IPath relFilePath = filePath.removeFirstSegments(dir.segmentCount());
            CommandLauncher launcher = new CommandLauncher();
            String[] env = null;
            ByteArrayOutputStream stderr = stdout = new ByteArrayOutputStream();
            Path makeCommandPath = new Path(info.getBuildCommand());
            ITool tool = info.getToolFromOutputExtension("status");
            IOption[] options = tool.getOptions();
            IPath runPath = null;
            boolean done = false;
            int i = 0;
            while (i < options.length && !done) {
                try {
                    if (options[i].getValueType() == 2) {
                        String value = (String)options[i].getValue();
                        String id = options[i].getId();
                        if (id.indexOf("builddir") > 0) {
                            runPath = makefile.getProject().getLocation().append(value.trim());
                            done = true;
                        }
                    }
                }
                catch (BuildException buildException) {}
                ++i;
            }
            NullProgressMonitor monitor = new NullProgressMonitor();
            String errMsg = null;
            String[] makeArgs = new String[]{"-n", "all", "MAKE=make -W " + relFilePath.toOSString()};
            try {
                Process proc = launcher.execute((IPath)makeCommandPath, makeArgs, env, runPath, (IProgressMonitor)new NullProgressMonitor());
                if (proc != null) {
                    try {
                        proc.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, -1)) != 0) {
                        errMsg = launcher.getErrorMessage();
                    }
                    outString = stdout.toString();
                    break block11;
                }
                errMsg = launcher.getErrorMessage();
            }
            catch (CoreException e) {
                errMsg = e.getLocalizedMessage();
                AutotoolsPlugin.logErrorMessage(errMsg);
            }
        }
        return outString;
    }

    private IFile getMakefile(IManagedBuildInfo info, IPath filePath) {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IPath dir = filePath.removeLastSegments(1);
        IFile makefile = null;
        boolean done = false;
        IPath makefilePath = null;
        while (!done) {
            makefilePath = dir.append("Makefile.in");
            makefile = root.getFile(makefilePath);
            if (makefile != null && makefile.exists()) {
                done = true;
                continue;
            }
            makefilePath = dir.append("Makefile");
            makefile = root.getFile(makefilePath);
            if (makefile != null && makefile.exists()) {
                done = true;
                continue;
            }
            if ((dir = dir.removeLastSegments(1)).lastSegment() != null) continue;
            done = true;
        }
        return makefile;
    }

    private String getCompilationString() {
        if (this.compilationString != null && !this.isDirty) {
            return this.compilationString;
        }
        String makeWEnabled = null;
        try {
            makeWEnabled = this.project.getPersistentProperty(AutotoolsPropertyConstants.SCANNER_USE_MAKE_W);
        }
        catch (CoreException coreException) {}
        if (!(this.res instanceof IFile) || makeWEnabled == null || makeWEnabled.equals("false")) {
            return null;
        }
        this.isDirty = false;
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile file = root.getFile(this.filePath);
        IFile makefile = null;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.project);
        if (file != null && file.exists() && info != null) {
            makefile = this.getMakefile(info, this.filePath);
        }
        if (makefile != null) {
            IPath dir = makefile.getFullPath().removeLastSegments(1);
            String out = this.buildFile(this.filePath, makefile, info);
            try {
                boolean topLevel = dir.equals((Object)this.project.getFullPath());
                Pattern p = null;
                Matcher m = null;
                if (!topLevel) {
                    String regex1 = "^Making.*in.*" + dir.lastSegment();
                    p = Pattern.compile(regex1, 8);
                    m = p.matcher(out);
                }
                if (topLevel || m.find()) {
                    Pattern p2 = null;
                    Matcher m2 = null;
                    String substr2 = out;
                    if (!topLevel) {
                        substr2 = out.substring(m.end());
                        String regex2 = "^make.*Entering directory.*`(.*)'";
                        p2 = Pattern.compile(regex2, 8);
                        m2 = p2.matcher(substr2);
                    }
                    if (topLevel || m2.find()) {
                        String substr3 = null;
                        if (!topLevel) {
                            this.dirName = m2.group(1);
                            substr3 = substr2.substring(m2.start());
                        } else {
                            this.dirName = "";
                            substr3 = out;
                        }
                        String regex3 = "^.*gcc.*?-I.*?" + this.filePath.lastSegment();
                        String regex4 = "^.*g[+][+].*?-I.*?" + this.filePath.lastSegment();
                        substr3 = substr3.replaceAll("\\\\\\n", "");
                        Pattern p3 = Pattern.compile(regex3, 8);
                        Matcher m3 = p3.matcher(substr3);
                        if (m3.find()) {
                            this.compilationString = substr3.substring(m3.start(), m3.end());
                        } else {
                            String substr4 = substr3;
                            Pattern p4 = Pattern.compile(regex4, 8);
                            Matcher m4 = p4.matcher(substr4);
                            if (m4.find()) {
                                this.compilationString = substr3.substring(m4.start(), m4.end());
                            }
                        }
                    }
                } else if (!out.equals("")) {
                    this.compilationString = "";
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.isDirty = true;
            }
        }
        return this.compilationString;
    }

    public String[] getIncludePaths() {
        IScannerInfo info;
        String[] pathArray = new String[]{};
        if (this.project == null || this.filePath == null) {
            return pathArray;
        }
        if (this.includePaths != null && !this.isDirty && this.compilationString != null) {
            return this.includePaths;
        }
        ArrayList<String> pathList = new ArrayList<String>();
        String cs = this.getCompilationString();
        if (cs != null) {
            Pattern p4 = Pattern.compile(" -I");
            String[] tokens = p4.split(cs);
            int j = 1;
            while (j < tokens.length) {
                String x = tokens[j].trim();
                int firstSpace = x.indexOf(32);
                if (firstSpace != -1) {
                    x = x.substring(0, firstSpace);
                }
                if (x.charAt(0) == '/') {
                    pathList.add(x);
                } else {
                    Path relPath = new Path(this.dirName);
                    relPath = relPath.append(x);
                    pathList.add(relPath.toOSString());
                }
                ++j;
            }
            Pattern p5 = Pattern.compile(" -isystem");
            tokens = p5.split(cs);
            int j2 = 1;
            while (j2 < tokens.length) {
                String x = tokens[j2].trim();
                int firstSpace = x.indexOf(32);
                if (firstSpace != -1) {
                    x = x.substring(0, firstSpace);
                }
                if (x.charAt(0) == '/') {
                    pathList.add(x);
                } else {
                    Path relPath = new Path(this.dirName);
                    relPath = relPath.append(x);
                    pathList.add(relPath.toOSString());
                }
                ++j2;
            }
        }
        if ((info = (IScannerInfo)ManagedBuildManager.getBuildInfo((IResource)this.project)) != null) {
            String[] extraIncludePaths = info.getIncludePaths();
            int i = 0;
            while (i < extraIncludePaths.length) {
                pathList.add(extraIncludePaths[i]);
                ++i;
            }
        }
        this.includePaths = pathList.toArray(pathArray);
        for (IScannerInfoChangeListener listener : this.listeners) {
            listener.changeNotification((IResource)this.project, (IScannerInfo)this);
        }
        return this.includePaths;
    }

    public Map getDefinedSymbols() {
        IScannerInfo info;
        HashMap<String, String> symbolMap = new HashMap<String, String>();
        if (this.project == null || this.filePath == null) {
            return symbolMap;
        }
        if (this.definedSymbols != null && !this.isDirty && this.compilationString != null) {
            return this.definedSymbols;
        }
        String cs = this.getCompilationString();
        if (cs != null) {
            Pattern p4 = Pattern.compile("\\s-D([^\\s=]+)(?:=(\\\\\".*?\\\\\"|\\S*))?");
            Matcher m = p4.matcher(cs);
            while (m.find()) {
                String name = m.group(1);
                String value = m.group(2);
                if (value != null) {
                    symbolMap.put(name, value.replace("\\", ""));
                    continue;
                }
                symbolMap.put(name, "");
            }
        }
        if ((info = (IScannerInfo)ManagedBuildManager.getBuildInfo((IResource)this.project)) != null) {
            Map builtinDefinedSymbols = info.getDefinedSymbols();
            symbolMap.putAll(builtinDefinedSymbols);
        }
        this.definedSymbols = symbolMap;
        return this.definedSymbols;
    }

    public void createIncludeChain(IFile include, IResource res) {
        try {
            include.setSessionProperty(AutotoolsPropertyConstants.OPEN_INCLUDE, (Object)res);
            include.setPersistentProperty(AutotoolsPropertyConstants.OPEN_INCLUDE_P, res.getLocation().toPortableString());
        }
        catch (CoreException coreException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IResource followIncludeChain(IResource resource) {
        IResource res = resource;
        try {
            try {
                boolean done = false;
                block5: while (true) {
                    if (done) {
                        return resource;
                    }
                    while (true) {
                        if (res.getSessionProperty(AutotoolsPropertyConstants.OPEN_INCLUDE) == null) {
                            String chainPath = res.getPersistentProperty(AutotoolsPropertyConstants.OPEN_INCLUDE_P);
                            if (chainPath == null) break;
                            IPath location = Path.fromPortableString((String)chainPath);
                            IFile next = res.getWorkspace().getRoot().getFileForLocation(location);
                            res.setSessionProperty(AutotoolsPropertyConstants.OPEN_INCLUDE, (Object)next);
                            res = next;
                            continue block5;
                        }
                        res = (IResource)res.getSessionProperty(AutotoolsPropertyConstants.OPEN_INCLUDE);
                    }
                    done = true;
                }
            }
            catch (CoreException coreException) {
                resource = res;
                return resource;
            }
        }
        finally {
            resource = res;
        }
    }
}

