/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.cdt.autotools.AutotoolsMakefileBuilder;
import org.eclipse.linuxtools.cdt.autotools.AutotoolsScannerInfo;
import org.eclipse.linuxtools.cdt.autotools.ui.properties.AutotoolsPropertyConstants;

public class AutotoolsScannerInfoProvider
extends AbstractCExtension
implements IScannerInfoProvider {
    private static Map<String, Map<IResource, AutotoolsScannerInfo>> infoCollections = new HashMap<String, Map<IResource, AutotoolsScannerInfo>>();
    public static final String INTERFACE_IDENTITY = "org.eclipse.linuxtools.cdt.autotools.AutotoolsScannerInfoProvider";

    protected String getCollectionName(IProject project) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        String config = String.valueOf(project.getName()) + "." + buildInfo.getConfigurationName();
        return config;
    }

    public synchronized IScannerInfo getScannerInformation(IResource resource) {
        AutotoolsScannerInfo info;
        String config;
        Map<IResource, AutotoolsScannerInfo> infoCollection;
        IResource res = AutotoolsScannerInfo.followIncludeChain(resource);
        IProject project = resource.getProject();
        if (!AutotoolsMakefileBuilder.hasTargetBuilder(project)) {
            return null;
        }
        Boolean isDirty = Boolean.FALSE;
        try {
            isDirty = (Boolean)project.getSessionProperty(AutotoolsPropertyConstants.SCANNER_INFO_DIRTY);
        }
        catch (CoreException coreException) {}
        if (isDirty != null && isDirty.equals(Boolean.TRUE)) {
            this.setDirty(project);
            try {
                project.setSessionProperty(AutotoolsPropertyConstants.SCANNER_INFO_DIRTY, (Object)Boolean.FALSE);
            }
            catch (CoreException coreException) {}
        }
        if ((infoCollection = infoCollections.get(config = this.getCollectionName(project))) == null) {
            infoCollection = new HashMap<IResource, AutotoolsScannerInfo>();
            infoCollections.put(config, infoCollection);
        }
        if ((info = infoCollection.get(res)) == null) {
            info = new AutotoolsScannerInfo(res);
            infoCollection.put(res, info);
        }
        return info;
    }

    private void setDirty(IProject project) {
        String config = this.getCollectionName(project);
        Map<IResource, AutotoolsScannerInfo> infoCollection = infoCollections.get(config);
        if (infoCollection != null) {
            Collection<AutotoolsScannerInfo> s = infoCollection.values();
            for (AutotoolsScannerInfo info : s) {
                info.setDirty(true);
            }
        }
    }

    public void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        AutotoolsScannerInfo info = (AutotoolsScannerInfo)this.getScannerInformation(resource);
        info.addListener(listener);
    }

    public void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        AutotoolsScannerInfo info = (AutotoolsScannerInfo)this.getScannerInformation(resource);
        if (info != null) {
            info.removeListener(listener);
        }
    }
}

