/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.ITarget;
import org.eclipse.cdt.make.core.makefile.ITargetRule;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator2;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.linuxtools.cdt.autotools.AutotoolsPlugin;
import org.eclipse.linuxtools.cdt.autotools.ui.properties.AutotoolsPropertyConstants;
import org.eclipse.linuxtools.internal.cdt.autotools.MarkerGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeGenerator
extends MarkerGenerator
implements IManagedBuilderMakefileGenerator,
IManagedBuilderMakefileGenerator2 {
    public final String CONFIG_STATUS = "config.status";
    public final String MAKEFILE = "Makefile";
    public final String MAKEFILE_CVS = "Makefile.cvs";
    public final String SETTINGS_FILE_NAME = ".cdtconfigure";
    public final String SHELL_COMMAND = "sh";
    public final String AUTOGEN_TOOL_ID = "org.eclipse.linuxtools.cdt.autotools.tool.autogen";
    public final String CONFIGURE_TOOL_ID = "org.eclipse.linuxtools.cdt.autotools.tool.configure";
    public final String GENERATED_TARGET = "org.eclipse.linuxtools.cdt.autotools.generated.MakeTarget";
    private static final String MAKE_TARGET_KEY = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".buildtargets";
    private static final String BUILD_TARGET_ELEMENT = "buildTargets";
    private static final String TARGET_ELEMENT = "target";
    private static final String TARGET_ATTR_ID = "targetID";
    private static final String TARGET_ATTR_PATH = "path";
    private static final String TARGET_ATTR_NAME = "name";
    private static final String TARGET_STOP_ON_ERROR = "stopOnError";
    private static final String TARGET_USE_DEFAULT_CMD = "useDefaultCommand";
    private static final String TARGET_ARGUMENTS = "buildArguments";
    private static final String TARGET_COMMAND = "buildCommand";
    private static final String TARGET_RUN_ALL_BUILDERS = "runAllBuilders";
    private static final String TARGET = "buildTarget";
    private IProject project;
    private IProgressMonitor monitor;
    private String buildDir;
    private String srcDir;
    private IConfiguration cfg;
    private IBuilder builder;

    public void generateDependencies() throws CoreException {
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        return this.regenerateMakefiles();
    }

    private void initializeBuildConfigDirs() {
        ITool tool = this.cfg.getToolFromOutputExtension("status");
        IOption[] options = tool.getOptions();
        int i = 0;
        while (i < options.length) {
            String resolved;
            String id = options[i].getId();
            if (id.indexOf("builddir") > 0) {
                this.buildDir = (String)options[i].getValue();
                try {
                    this.buildDir = resolved = ManagedBuildManager.getBuildMacroProvider().resolveValue(this.buildDir, "build", null, 3, (Object)this.cfg);
                }
                catch (BuildMacroException buildMacroException) {}
            } else if (id.indexOf("configdir") > 0) {
                this.srcDir = (String)options[i].getValue();
                try {
                    this.srcDir = resolved = ManagedBuildManager.getBuildMacroProvider().resolveValue(this.srcDir, "", null, 3, (Object)this.cfg);
                }
                catch (BuildMacroException buildMacroException) {}
            }
            ++i;
        }
    }

    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.project = project;
        this.cfg = info.getDefaultConfiguration();
        this.builder = this.cfg.getBuilder();
        this.monitor = monitor;
        this.initializeBuildConfigDirs();
    }

    public void initialize(int buildKind, IConfiguration cfg, IBuilder builder, IProgressMonitor monitor) {
        this.cfg = cfg;
        this.builder = builder;
        this.monitor = monitor;
        this.project = (IProject)cfg.getManagedProject().getOwner();
        this.initializeBuildConfigDirs();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public boolean isGeneratedResource(IResource resource) {
        return false;
    }

    public void regenerateDependencies(boolean force) throws CoreException {
    }

    protected void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFile createFile(IPath makefilePath) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(makefilePath);
        if (newFile == null) {
            newFile = root.getFile(makefilePath);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            if (!newFile.isDerived()) {
                newFile.setDerived(true);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    private boolean createDirectory(String dirName) throws CoreException {
        File f;
        boolean rc = true;
        Path path = new Path(dirName);
        if (dirName.length() == 0 || dirName.startsWith(".") || !dirName.startsWith("/")) {
            path = this.project.getLocation().append(dirName);
        }
        if (!(f = path.toFile()).exists()) {
            rc = f.mkdirs();
        }
        return rc;
    }

    public IPath getBuildWorkingDir() {
        return new Path(this.buildDir);
    }

    private IPath getProjectLocation() {
        return this.project.getLocation();
    }

    private String getAbsoluteDirectory(String dir) {
        Path path = new Path(dir);
        if (!path.isAbsolute()) {
            IPath absPath = this.getProjectLocation().addTrailingSeparator().append((IPath)path);
            return this.getPathString(absPath);
        }
        return dir;
    }

    public String getMakefileName() {
        return new String("Makefile");
    }

    protected IPath getConfigSettingsPath() {
        IPath path = this.project.getWorkingLocation("org.eclipse.linuxtools.cdt.autotools").append(".cdtconfigure." + this.cfg.getName());
        return path;
    }

    public void removeConfigSettings() {
        File f = this.getConfigSettingsPath().toFile();
        try {
            f.delete();
        }
        catch (Exception exception) {}
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        MultiStatus status;
        int rc = 0;
        String errMsg = new String();
        boolean needFullConfigure = true;
        this.checkCancel();
        if (!this.createDirectory(this.buildDir)) {
            rc = 4;
            errMsg = AutotoolsPlugin.getFormattedString("MakeGenerator.createdir.error", new String[]{this.buildDir});
            return new MultiStatus(AutotoolsPlugin.getUniqueIdentifier(), rc, errMsg, null);
        }
        this.checkCancel();
        IConsole console = CCorePlugin.getDefault().getConsole("org.eclipse.linuxtools.cdt.autotools.configureConsole");
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        try {
            try {
                Path makeCmd;
                String[] makeargs;
                IPath configfile = this.getProjectLocation().append(this.buildDir).append("config.status");
                IPath makefilePath = this.getProjectLocation().append(this.buildDir).append("Makefile");
                File configStatus = configfile.toFile();
                File makefile = makefilePath.toFile();
                IPath configSettingsPath = this.getConfigSettingsPath();
                File configSettings = configSettingsPath.toFile();
                String[] configArgs = this.getConfigArgs();
                if (configSettings.exists()) {
                    int i = 0;
                    boolean needSaveConfigArgs = false;
                    needFullConfigure = false;
                    try {
                        DataInputStream settings = new DataInputStream(new BufferedInputStream(new FileInputStream(configSettings)));
                        settings.mark(100);
                        String s = settings.readUTF();
                        if (s.startsWith("project=")) {
                            if (!s.substring(8).equals(this.project.getName())) {
                                needFullConfigure = true;
                            }
                        } else {
                            needSaveConfigArgs = true;
                            settings.reset();
                        }
                        while (i < configArgs.length) {
                            s = settings.readUTF();
                            if (!s.equals(configArgs[i])) {
                                i = configArgs.length;
                                needFullConfigure = true;
                            }
                            ++i;
                        }
                        if (settings.available() > 0) {
                            needFullConfigure = true;
                        }
                    }
                    catch (EOFException eOFException) {
                        needFullConfigure = true;
                    }
                    catch (IOException iOException) {
                        needFullConfigure = true;
                    }
                    if (needFullConfigure) {
                        File r = this.project.getLocation().append(this.buildDir).toFile();
                        if (r != null && r.exists()) {
                            String cleanDelete = null;
                            try {
                                cleanDelete = this.getProject().getPersistentProperty(AutotoolsPropertyConstants.CLEAN_DELETE);
                            }
                            catch (CoreException coreException) {}
                            if (cleanDelete != null && cleanDelete.equals("true")) {
                                SubProgressMonitor sub = new SubProgressMonitor(this.monitor, -1);
                                sub.beginTask(AutotoolsPlugin.getResourceString("MakeGenerator.clean.builddir"), -1);
                                try {
                                    r.delete();
                                }
                                finally {
                                    sub.done();
                                }
                            }
                            if (makefile != null && makefile.exists()) {
                                String args;
                                makeargs = new String[1];
                                makeCmd = new Path("make");
                                String target = null;
                                try {
                                    target = this.getProject().getPersistentProperty(AutotoolsPropertyConstants.CLEAN_MAKE_TARGET);
                                }
                                catch (CoreException coreException) {}
                                if (target == null) {
                                    target = "distclean";
                                }
                                if ((args = this.builder.getBuildArguments()) != null && !(args = args.trim()).equals("")) {
                                    String[] newArgs = this.makeArray(args);
                                    makeargs = new String[newArgs.length + 1];
                                    System.arraycopy(newArgs, 0, makeargs, 0, newArgs.length);
                                }
                                makeargs[makeargs.length - 1] = target;
                                rc = this.runCommand((IPath)makeCmd, this.project.getLocation().append(this.buildDir), makeargs, AutotoolsPlugin.getResourceString("MakeGenerator.clean.builddir"), errMsg, console, true);
                            }
                        }
                        this.initializeBuildConfigDirs();
                        this.createDirectory(this.buildDir);
                        try {
                            this.project.setSessionProperty(AutotoolsPropertyConstants.SCANNER_INFO_DIRTY, (Object)Boolean.TRUE);
                        }
                        catch (CoreException coreException) {}
                    } else if (needSaveConfigArgs) {
                        this.saveConfigArgs(configArgs);
                    }
                }
                ArrayList<String> configureEnvs = new ArrayList<String>();
                IPath configurePath = this.getConfigurePath(configureEnvs);
                ArrayList<String> autogenEnvs = new ArrayList<String>();
                IPath autogenPath = this.getAutogenPath(autogenEnvs);
                if (!needFullConfigure && configStatus != null && configStatus.exists()) {
                    if (makefile == null || !makefile.exists()) {
                        rc = this.runScript(configfile, this.project.getLocation().append(this.buildDir), null, AutotoolsPlugin.getResourceString("MakeGenerator.run.config.status"), errMsg, console, null, true);
                    }
                } else if (configurePath.toFile().exists()) {
                    rc = this.runScript(configurePath, this.project.getLocation().append(this.buildDir), configArgs, AutotoolsPlugin.getResourceString("MakeGenerator.gen.makefile"), errMsg, console, configureEnvs, true);
                    if (rc != 4) {
                        File makefileFile = this.project.getLocation().append(this.buildDir).append("Makefile").toFile();
                        this.addMakeTargetsToManager(makefileFile);
                        this.saveConfigArgs(configArgs);
                    }
                } else if (autogenPath.toFile().exists()) {
                    if (configStatus.exists()) {
                        configStatus.delete();
                    }
                    String[] autogenArgs = this.getAutogenArgs();
                    rc = this.runScript(autogenPath, autogenPath.removeLastSegments(1), autogenArgs, AutotoolsPlugin.getResourceString("MakeGenerator.autogen.sh"), errMsg, console, autogenEnvs, true);
                    if (rc != 4) {
                        File makefileFile;
                        configStatus = configfile.toFile();
                        if (configStatus == null || !configStatus.exists()) {
                            rc = this.runScript(configurePath, this.project.getLocation().append(this.buildDir), configArgs, AutotoolsPlugin.getResourceString("MakeGenerator.gen.makefile"), errMsg, console, configureEnvs, false);
                            if (rc != 4) {
                                makefileFile = this.project.getLocation().append(this.buildDir).append("Makefile").toFile();
                                this.addMakeTargetsToManager(makefileFile);
                            }
                        } else {
                            makefileFile = this.project.getLocation().append(this.buildDir).append("Makefile").toFile();
                            this.addMakeTargetsToManager(makefileFile);
                        }
                    }
                } else if (this.makefileCvsExists()) {
                    makeargs = new String[1];
                    makeCmd = new Path("make");
                    makeargs[0] = "-f" + this.getMakefileCVSPath().toOSString();
                    rc = this.runCommand((IPath)makeCmd, this.project.getLocation().append(this.buildDir), makeargs, AutotoolsPlugin.getResourceString("MakeGenerator.makefile.cvs"), errMsg, console, true);
                    if (rc != 4) {
                        File makefileFile = this.project.getLocation().append(this.buildDir).append("Makefile").toFile();
                        this.addMakeTargetsToManager(makefileFile);
                        this.saveConfigArgs(configArgs);
                    }
                } else {
                    String[] reconfArgs = new String[1];
                    String reconfCmd = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTORECONF_TOOL);
                    if (reconfCmd == null) {
                        reconfCmd = "autoreconf";
                    }
                    Path reconfCmdPath = new Path(reconfCmd);
                    reconfArgs[0] = "-i";
                    rc = this.runCommand((IPath)reconfCmdPath, this.project.getLocation().append(this.srcDir), reconfArgs, AutotoolsPlugin.getResourceString("MakeGenerator.autoreconf"), errMsg, console, true);
                    if (rc != 4 && configurePath.toFile().exists() && (rc = this.runScript(configurePath, this.project.getLocation().append(this.buildDir), configArgs, AutotoolsPlugin.getResourceString("MakeGenerator.gen.makefile"), errMsg, console, configureEnvs, false)) != 4) {
                        File makefileFile = this.project.getLocation().append(this.buildDir).append("Makefile").toFile();
                        this.addMakeTargetsToManager(makefileFile);
                        this.saveConfigArgs(configArgs);
                    }
                }
                if (makefile == null || !makefile.exists()) {
                    rc = 4;
                    errMsg = AutotoolsPlugin.getResourceString("MakeGenerator.didnt.generate");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                rc = 4;
                status = new MultiStatus(AutotoolsPlugin.getUniqueIdentifier(), rc, errMsg, null);
            }
        }
        finally {
            status = new MultiStatus(AutotoolsPlugin.getUniqueIdentifier(), rc, errMsg, null);
        }
        return status;
    }

    public static String stripEnvVars(String command, ArrayList<String> envVars) {
        Pattern p = Pattern.compile("(\\w+[=]([$]?\\w+[:;]?)+\\s+)\\w+.*");
        Pattern p2 = Pattern.compile("(\\w+[=]\\\".*?\\\"\\s+)\\w+.*");
        Pattern p3 = Pattern.compile("(\\w+[=]'.*?'\\s+)\\w+.*");
        boolean finished = false;
        while (!finished) {
            Matcher m = p.matcher(command);
            if (m.matches()) {
                command = command.replaceFirst("\\w+[=]([$]?\\w+[:;]?)+", "").trim();
                envVars.add(m.group(1).trim());
                continue;
            }
            Matcher m2 = p2.matcher(command);
            if (m2.matches()) {
                command = command.replaceFirst("\\w+[=]\\\".*?\\\"", "").trim();
                String s = m2.group(1).trim();
                envVars.add(s.replaceAll("\\\"", ""));
                continue;
            }
            Matcher m3 = p3.matcher(command);
            if (m3.matches()) {
                command = command.replaceFirst("\\w+[=]'.*?'", "").trim();
                String s = m3.group(1).trim();
                envVars.add(s.replaceAll("'", ""));
                continue;
            }
            finished = true;
        }
        return command;
    }

    protected IPath getConfigurePath(ArrayList<String> envVars) {
        ITool[] tool = this.cfg.getToolsBySuperClassId("org.eclipse.linuxtools.cdt.autotools.tool.configure");
        String command = MakeGenerator.stripEnvVars(tool[0].getToolCommand().trim(), envVars);
        IPath configPath = this.srcDir.equals("") ? this.project.getLocation().append(command) : this.project.getLocation().append(this.srcDir).append(command);
        return configPath;
    }

    protected IPath getMakefileCVSPath() {
        IPath makefileCVSPath = this.srcDir.equals("") ? this.project.getLocation().append("Makefile.cvs") : this.project.getLocation().append(this.srcDir).append("Makefile.cvs");
        return makefileCVSPath;
    }

    protected boolean makefileCvsExists() {
        IPath makefileCVSPath = this.getMakefileCVSPath();
        return makefileCVSPath.toFile().exists();
    }

    protected IPath getAutogenPath(ArrayList<String> envVars) {
        ITool[] tool = this.cfg.getToolsBySuperClassId("org.eclipse.linuxtools.cdt.autotools.tool.autogen");
        String command = MakeGenerator.stripEnvVars(tool[0].getToolCommand().trim(), envVars);
        IPath autogenPath = this.srcDir.equals("") ? this.project.getLocation().append(command) : this.project.getLocation().append(this.srcDir).append(command);
        return autogenPath;
    }

    private void saveConfigArgs(String[] args) {
        IPath settingsPath = this.getConfigSettingsPath();
        try {
            File f = settingsPath.toFile();
            DataOutputStream settings = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            settings.writeUTF("project=" + this.project.getName());
            int i = 0;
            while (i < args.length) {
                settings.writeUTF(args[i]);
                ++i;
            }
            settings.close();
        }
        catch (IOException iOException) {}
    }

    private String[] getAutogenArgs() throws BuildException {
        ITool[] tool = this.cfg.getToolsBySuperClassId("org.eclipse.linuxtools.cdt.autotools.tool.autogen");
        IOption[] options = tool[0].getOptions();
        ArrayList<String> autogenArgs = new ArrayList<String>();
        int i = 0;
        while (i < options.length) {
            if (options[i].getValueType() == 2) {
                String value = (String)options[i].getValue();
                try {
                    String resolved;
                    value = resolved = ManagedBuildManager.getBuildMacroProvider().resolveValue(value, "", null, 3, (Object)this.cfg);
                }
                catch (BuildMacroException buildMacroException) {}
                String id = options[i].getId();
                if (id.indexOf("user") > 0) {
                    value = value.trim();
                    boolean finished = false;
                    int lastIndex = value.indexOf("--");
                    if (lastIndex != -1) {
                        while (!finished) {
                            int index = value.indexOf("--", lastIndex + 2);
                            if (index != -1) {
                                String previous = value.substring(lastIndex, index).trim();
                                autogenArgs.add(previous);
                                value = value.substring(index);
                                continue;
                            }
                            autogenArgs.add(value);
                            finished = true;
                        }
                    }
                }
            }
            ++i;
        }
        return autogenArgs.toArray(new String[autogenArgs.size()]);
    }

    private String[] getConfigArgs() throws BuildException {
        ITool tool = this.cfg.getToolFromOutputExtension("status");
        IOption[] options = tool.getOptions();
        ArrayList<Object> configArgs = new ArrayList<Object>();
        int i = 0;
        while (i < options.length) {
            Object value;
            if (options[i].getValueType() == 2) {
                value = (String)options[i].getValue();
                try {
                    String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValue((String)value, "", null, 3, (Object)this.cfg);
                    value = resolved;
                }
                catch (BuildMacroException buildMacroException) {}
                String id = options[i].getId();
                if (id.indexOf("configdir") <= 0 && id.indexOf("builddir") <= 0) {
                    if (id.indexOf("user") > 0) {
                        value = ((String)value).trim();
                        boolean finished = false;
                        int lastIndex = ((String)value).indexOf("--");
                        if (lastIndex != -1) {
                            while (!finished) {
                                int index = ((String)value).indexOf("--", lastIndex + 2);
                                if (index != -1) {
                                    String previous = ((String)value).substring(lastIndex, index).trim();
                                    configArgs.add(previous);
                                    value = ((String)value).substring(index);
                                    continue;
                                }
                                configArgs.add(value);
                                finished = true;
                            }
                        } else {
                            configArgs.add(value);
                        }
                    } else if (((String)value).trim().length() > 0) {
                        String categoryId = options[i].getCategory().getId();
                        if (categoryId.indexOf("directories") >= 0) {
                            value = this.getAbsoluteDirectory((String)value);
                        }
                        String cmd = options[i].getCommand().concat((String)value);
                        configArgs.add(cmd);
                    }
                }
            } else if (options[i].getValueType() == 0) {
                value = (Boolean)options[i].getValue();
                if (((Boolean)value).booleanValue()) {
                    configArgs.add(options[i].getCommand());
                } else if (!options[i].getCommandFalse().equals("")) {
                    configArgs.add(options[i].getCommandFalse());
                }
            }
            ++i;
        }
        return configArgs.toArray(new String[configArgs.size()]);
    }

    private int runCommand(IPath commandPath, IPath runPath, String[] args, String jobDescription, String errMsg, IConsole console, boolean consoleStart) throws BuildException, CoreException, NullPointerException, IOException {
        int rc = 0;
        this.removeAllMarkers(this.project);
        String[] configTargets = args;
        if (args == null) {
            configTargets = new String[]{};
        }
        String[] msgs = new String[]{commandPath.toString(), this.project.getName()};
        this.monitor.subTask(AutotoolsPlugin.getFormattedString("MakeGenerator.make.message", msgs));
        ConsoleOutputStream consoleOutStream = null;
        StringBuffer buf = new StringBuffer();
        if (consoleStart) {
            console.start(this.project);
        }
        consoleOutStream = console.getOutputStream();
        String[] consoleHeader = new String[]{jobDescription, this.cfg.getName(), this.project.getName()};
        buf.append(System.getProperty("line.separator", "\n"));
        buf.append(jobDescription);
        buf.append(System.getProperty("line.separator", "\n"));
        buf.append(System.getProperty("line.separator", "\n"));
        if (!this.cfg.isSupported()) {
            String[] msgArgs = new String[]{this.cfg.getName()};
            buf.append(AutotoolsPlugin.getFormattedString("MakeGenerator.unsupportedConfig", msgArgs));
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(System.getProperty("line.separator", "\n"));
        }
        consoleOutStream.write(buf.toString().getBytes());
        consoleOutStream.flush();
        CommandLauncher launcher = new CommandLauncher();
        IEnvironmentVariable[] variables = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(this.cfg, true);
        String[] env = null;
        ArrayList<String> envList = new ArrayList<String>();
        if (variables != null) {
            int i = 0;
            while (i < variables.length) {
                envList.add(String.valueOf(variables[i].getName()) + "=" + variables[i].getValue());
                ++i;
            }
            env = envList.toArray(new String[envList.size()]);
        }
        ConsoleOutputStream stdout = consoleOutStream;
        ConsoleOutputStream stderr = consoleOutStream;
        launcher.showCommand(true);
        Process proc = launcher.execute(commandPath, configTargets, env, runPath, (IProgressMonitor)new NullProgressMonitor());
        if (proc != null) {
            try {
                proc.getOutputStream().close();
            }
            catch (IOException iOException) {}
            if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)new SubProgressMonitor(this.monitor, -1)) != 0) {
                errMsg = launcher.getErrorMessage();
            }
            this.monitor.subTask(AutotoolsPlugin.getResourceString("MakeGenerator.refresh"));
            try {
                this.project.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                this.monitor.subTask(AutotoolsPlugin.getResourceString("MakeGenerator.refresh.error"));
            }
        } else {
            errMsg = launcher.getErrorMessage();
        }
        buf = new StringBuffer();
        if (errMsg != null && errMsg.length() > 0) {
            String errorDesc = AutotoolsPlugin.getResourceString("MakeGenerator.generation.error");
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(errorDesc);
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append("(").append(errMsg).append(")");
            rc = 4;
        } else if (proc.exitValue() >= 1 || proc.exitValue() < 0) {
            String[] errArg = new String[]{Integer.toString(proc.exitValue()), commandPath.toString()};
            errMsg = AutotoolsPlugin.getFormattedString("MakeGenerator.config.error", errArg);
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(AutotoolsPlugin.getResourceString("MakeGenerator.generation.error"));
            buf.append(System.getProperty("line.separator", "\n"));
            rc = proc.exitValue() == 1 ? 2 : 4;
        } else {
            String successMsg = AutotoolsPlugin.getResourceString("MakeGenerator.success");
            buf.append(successMsg);
            buf.append(System.getProperty("line.separator", "\n"));
            rc = 0;
        }
        consoleOutStream.write(buf.toString().getBytes());
        consoleOutStream.flush();
        consoleOutStream.close();
        if (rc == 4) {
            this.addMarker((IResource)this.project, -1, errMsg, 3, null);
            this.cfg.setRebuildState(true);
        }
        return rc;
    }

    private String getPathString(IPath path) {
        String s = path.toString();
        if (Platform.getOS().equals("win32")) {
            s = s.replaceAll("^([A-Z])(:)", "/$1");
        }
        return s;
    }

    private int runScript(IPath commandPath, IPath runPath, String[] args, String jobDescription, String errMsg, IConsole console, ArrayList<String> additionalEnvs, boolean consoleStart) throws BuildException, CoreException, NullPointerException, IOException {
        int rc = 0;
        this.removeAllMarkers(this.project);
        String[] configTargets = null;
        if (args == null) {
            configTargets = new String[1];
        } else {
            configTargets = new String[args.length + 1];
            System.arraycopy(args, 0, configTargets, 1, args.length);
        }
        configTargets[0] = this.getPathString(commandPath);
        String[] msgs = new String[]{commandPath.toString(), this.project.getName()};
        this.monitor.subTask(AutotoolsPlugin.getFormattedString("MakeGenerator.make.message", msgs));
        ConsoleOutputStream consoleOutStream = null;
        StringBuffer buf = new StringBuffer();
        if (consoleStart) {
            console.start(this.project);
        }
        consoleOutStream = console.getOutputStream();
        String[] consoleHeader = new String[]{jobDescription, this.cfg.getName(), this.project.getName()};
        buf.append(System.getProperty("line.separator", "\n"));
        buf.append(jobDescription);
        buf.append(System.getProperty("line.separator", "\n"));
        buf.append(System.getProperty("line.separator", "\n"));
        if (!this.cfg.isSupported()) {
            String[] msgArgs = new String[]{this.cfg.getName()};
            buf.append(AutotoolsPlugin.getFormattedString("MakeGenerator.unsupportedConfig", msgArgs));
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(System.getProperty("line.separator", "\n"));
        }
        consoleOutStream.write(buf.toString().getBytes());
        consoleOutStream.flush();
        CommandLauncher launcher = new CommandLauncher();
        IEnvironmentVariable[] variables = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(this.cfg, true);
        String[] env = null;
        ArrayList<String> envList = new ArrayList<String>();
        if (variables != null) {
            int i = 0;
            while (i < variables.length) {
                envList.add(String.valueOf(variables[i].getName()) + "=" + variables[i].getValue());
                ++i;
            }
            if (additionalEnvs != null) {
                envList.addAll(additionalEnvs);
            }
            env = envList.toArray(new String[envList.size()]);
        }
        ConsoleOutputStream stdout = consoleOutStream;
        ConsoleOutputStream stderr = consoleOutStream;
        launcher.showCommand(true);
        Process proc = launcher.execute((IPath)new Path("sh"), configTargets, env, runPath, (IProgressMonitor)new NullProgressMonitor());
        if (proc != null) {
            try {
                proc.getOutputStream().close();
            }
            catch (IOException iOException) {}
            if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)new SubProgressMonitor(this.monitor, -1)) != 0) {
                errMsg = launcher.getErrorMessage();
            }
            this.monitor.subTask(AutotoolsPlugin.getResourceString("MakeGenerator.refresh"));
            try {
                this.project.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                this.monitor.subTask(AutotoolsPlugin.getResourceString("MakeGenerator.refresh.error"));
            }
        } else {
            errMsg = launcher.getErrorMessage();
        }
        buf = new StringBuffer();
        if (errMsg != null && errMsg.length() > 0) {
            String errorDesc = AutotoolsPlugin.getResourceString("MakeGenerator.generation.error");
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(errorDesc);
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append("(").append(errMsg).append(")");
            rc = 4;
        } else if (proc.exitValue() >= 1 || proc.exitValue() < 0) {
            String[] errArg = new String[]{Integer.toString(proc.exitValue()), commandPath.toString()};
            errMsg = AutotoolsPlugin.getFormattedString("MakeGenerator.config.error", errArg);
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(AutotoolsPlugin.getResourceString("MakeGenerator.generation.error"));
            buf.append(System.getProperty("line.separator", "\n"));
            rc = proc.exitValue() == 1 ? 2 : 4;
        } else {
            String successMsg = AutotoolsPlugin.getResourceString("MakeGenerator.success");
            buf.append(successMsg);
            buf.append(System.getProperty("line.separator", "\n"));
            rc = 0;
        }
        consoleOutStream.write(buf.toString().getBytes());
        consoleOutStream.flush();
        consoleOutStream.close();
        if (rc == 4) {
            this.addMarker((IResource)this.project, -1, errMsg, 3, null);
            this.cfg.setRebuildState(true);
        }
        return rc;
    }

    private ICStorageElement createTargetElement(ICStorageElement parent, IMakeTarget target) {
        ICStorageElement targetElem = parent.createChild(TARGET_ELEMENT);
        targetElem.setAttribute(TARGET_ATTR_NAME, target.getName());
        targetElem.setAttribute(TARGET_ATTR_ID, target.getTargetBuilderID());
        targetElem.setAttribute(TARGET_ATTR_PATH, target.getContainer().getProjectRelativePath().toString());
        ICStorageElement elem = targetElem.createChild(TARGET_COMMAND);
        elem.setValue(target.getBuildAttribute("org.eclipse.cdt.make.core.build.command", "make"));
        String targetAttr = target.getBuildAttribute("org.eclipse.cdt.make.core.build.arguments", null);
        if (targetAttr != null) {
            elem = targetElem.createChild(TARGET_ARGUMENTS);
            elem.setValue(targetAttr);
        }
        if ((targetAttr = target.getBuildAttribute(IMakeTarget.BUILD_TARGET, null)) != null) {
            elem = targetElem.createChild(TARGET);
            elem.setValue(targetAttr);
        }
        elem = targetElem.createChild(TARGET_STOP_ON_ERROR);
        elem.setValue(new Boolean(target.isStopOnError()).toString());
        elem = targetElem.createChild(TARGET_USE_DEFAULT_CMD);
        elem.setValue(new Boolean(target.isDefaultBuildCmd()).toString());
        elem = targetElem.createChild(TARGET_RUN_ALL_BUILDERS);
        elem.setValue(new Boolean(target.runAllBuilders()).toString());
        return targetElem;
    }

    private void saveTargets(IMakeTarget[] makeTargets) throws CoreException {
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.getProject(), true);
        ICStorageElement rootElement = descriptor.getProjectStorageElement(MAKE_TARGET_KEY);
        rootElement.clear();
        rootElement = rootElement.createChild(BUILD_TARGET_ELEMENT);
        int i = 0;
        while (i < makeTargets.length) {
            this.createTargetElement(rootElement, makeTargets[i]);
            ++i;
        }
        descriptor.saveProjectData();
    }

    private void addMakeTargetsToManager(File makefileFile) throws CoreException {
        if (makefileFile == null || !makefileFile.exists()) {
            return;
        }
        this.checkCancel();
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        String statusMsg = AutotoolsPlugin.getResourceString("MakeGenerator.refresh.MakeTargets");
        this.monitor.subTask(statusMsg);
        IMakeTargetManager makeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        IMakefile makefile = MakeCorePlugin.createMakefile((URI)makefileFile.toURI(), (boolean)false, null);
        ITargetRule[] targets = makefile.getTargetRules();
        ITarget target = null;
        HashMap<String, IMakeTarget> makeTargets = new HashMap<String, IMakeTarget>();
        int i = 0;
        while (i < targets.length) {
            target = targets[i].getTarget();
            String targetName = target.toString();
            if (this.isValidTarget(targetName, makeTargetManager)) {
                try {
                    IMakeTarget makeTarget = makeTargetManager.createTarget(this.project, targetName, "org.eclipse.linuxtools.cdt.autotools.builder1");
                    makeTarget.setContainer((IContainer)this.project);
                    makeTarget.setStopOnError(true);
                    makeTarget.setRunAllBuilders(false);
                    makeTarget.setUseDefaultBuildCmd(true);
                    makeTarget.setBuildAttribute("org.eclipse.linuxtools.cdt.autotools.generated.MakeTarget", "true");
                    makeTarget.setBuildAttribute(IMakeTarget.BUILD_TARGET, targetName);
                    makeTarget.setBuildAttribute(IMakeTarget.BUILD_LOCATION, this.buildDir);
                    makeTargets.put(makeTarget.getName(), makeTarget);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        IMakeTarget[] makeTargetArray = new IMakeTarget[makeTargets.size()];
        Collection values = makeTargets.values();
        ArrayList valueList = new ArrayList(values);
        valueList.toArray(makeTargetArray);
        MakeTargetComparator compareMakeTargets = new MakeTargetComparator();
        Arrays.sort(makeTargetArray, compareMakeTargets);
        this.saveTargets(makeTargetArray);
    }

    private boolean isValidTarget(String targetName, IMakeTargetManager makeTargetManager) {
        return !targetName.endsWith("-am") && !targetName.endsWith("PROGRAMS") && !targetName.endsWith("-generic") && targetName.indexOf(36) < 0 && targetName.charAt(0) != '.' && !targetName.equals(targetName.toUpperCase());
    }

    private String[] makeArray(String string) {
        String str;
        string = string.trim();
        char[] array = string.toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        boolean inComment = false;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            boolean needsToAdd = true;
            if (array[i] == '\"' || array[i] == '\'') {
                if (i > 0 && array[i - 1] == '\\') {
                    inComment = false;
                } else {
                    inComment = !inComment;
                    needsToAdd = false;
                }
            }
            if (c == ' ' && !inComment) {
                String str2;
                if (buffer.length() > 0 && (str2 = buffer.toString().trim()).length() > 0) {
                    aList.add(str2);
                }
                buffer = new StringBuilder();
            } else if (needsToAdd) {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0 && (str = buffer.toString().trim()).length() > 0) {
            aList.add(str);
        }
        return aList.toArray(new String[aList.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MakeTargetComparator
    implements Comparator<Object> {
        protected MakeTargetComparator() {
        }

        @Override
        public int compare(Object a, Object b) {
            IMakeTarget make1 = (IMakeTarget)a;
            IMakeTarget make2 = (IMakeTarget)b;
            return make1.getName().compareToIgnoreCase(make2.getName());
        }
    }
}

