/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.actions;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.cdt.autotools.AutotoolsPlugin;
import org.eclipse.linuxtools.cdt.autotools.MakeGenerator;
import org.eclipse.linuxtools.cdt.autotools.actions.AbstractTargetAction;
import org.eclipse.linuxtools.cdt.autotools.actions.InvokeMessages;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvokeAction
extends AbstractTargetAction {
    protected void showInformation(String title, String content) {
        MessageDialog.openInformation((Shell)new Shell(), (String)title, (String)content);
    }

    protected void showError(String title, String content) {
        MessageDialog.openError((Shell)new Shell(), (String)title, (String)content);
    }

    protected void showSuccess(String title) {
        MessageDialog.openInformation((Shell)new Shell(), (String)title, (String)InvokeMessages.getString("InvokeAction.success"));
    }

    protected String showInput(String title, String content, String defaultTxt) {
        InputDialog getOptionDialog = new InputDialog(new Shell(), title, content, defaultTxt, null);
        getOptionDialog.open();
        return getOptionDialog.getValue();
    }

    protected String[] separateTargets(String rawArgList) {
        StringTokenizer st = new StringTokenizer(rawArgList, " ");
        ArrayList<String> targetList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String tmpTarget;
            String currentWord = st.nextToken().trim();
            if (currentWord.startsWith("'")) {
                tmpTarget = "";
                while (!currentWord.endsWith("'")) {
                    tmpTarget = String.valueOf(tmpTarget) + currentWord + " ";
                    if (!st.hasMoreTokens()) {
                        return null;
                    }
                    currentWord = st.nextToken().trim();
                }
                tmpTarget = String.valueOf(tmpTarget) + currentWord;
                targetList.add(tmpTarget);
                continue;
            }
            if (currentWord.startsWith("\"")) {
                tmpTarget = "";
                while (!currentWord.endsWith("\"")) {
                    tmpTarget = String.valueOf(tmpTarget) + currentWord + " ";
                    if (!st.hasMoreTokens()) {
                        return null;
                    }
                    currentWord = st.nextToken().trim();
                }
                tmpTarget = String.valueOf(tmpTarget) + currentWord;
                targetList.add(tmpTarget);
                continue;
            }
            targetList.add(currentWord);
        }
        return targetList.toArray(new String[targetList.size()]);
    }

    protected String[] separateOptions(String rawArgList) {
        ArrayList<String> argList = new ArrayList<String>();
        rawArgList = rawArgList.trim();
        boolean finished = false;
        int lastIndex = rawArgList.indexOf("--");
        if (lastIndex != -1) {
            while (!finished) {
                int index = rawArgList.indexOf("--", lastIndex + 2);
                if (index != -1) {
                    String previous = rawArgList.substring(lastIndex, index).trim();
                    argList.add(previous);
                    rawArgList = rawArgList.substring(index);
                    continue;
                }
                argList.add(rawArgList);
                finished = true;
            }
        }
        return argList.toArray(new String[argList.size()]);
    }

    protected String[] simpleParseOptions(String rawArgList) {
        ArrayList<String> argList = new ArrayList<String>();
        int lastArgIndex = -1;
        int i = 0;
        while (i < rawArgList.length()) {
            char ch = rawArgList.charAt(i);
            while (Character.isWhitespace(ch)) {
                if (++i < rawArgList.length()) {
                    ch = rawArgList.charAt(i);
                    continue;
                }
                return argList.toArray(new String[argList.size()]);
            }
            lastArgIndex = i;
            boolean inString = false;
            while (i < rawArgList.length()) {
                ch = rawArgList.charAt(i);
                if (ch == '\\') {
                    ++i;
                } else if (ch == '\"') {
                    inString = !inString;
                } else if (Character.isWhitespace(ch) && !inString) {
                    argList.add(rawArgList.substring(lastArgIndex, i));
                    break;
                }
                ++i;
            }
            if (i >= rawArgList.length()) {
                argList.add(rawArgList.substring(lastArgIndex));
            }
            ++i;
        }
        return argList.toArray(new String[argList.size()]);
    }

    protected IPath getExecDir(IContainer container) {
        int type = container.getType();
        IPath execDir = null;
        execDir = type == 1 ? container.getLocation().removeLastSegments(1) : container.getLocation();
        return execDir;
    }

    protected IPath getCWD(IContainer container) {
        int type = container.getType();
        IPath cwd = null;
        cwd = type == 1 ? container.getFullPath().removeLastSegments(1) : container.getFullPath();
        return cwd;
    }

    protected HashMap<String, String> executeCommand(IPath command, String[] argumentList, String[] envList, IPath execDir) {
        try {
            ExecuteProgressDialog d = new ExecuteProgressDialog(command, argumentList, envList, execDir);
            new ProgressMonitorDialog(new Shell()).run(false, false, (IRunnableWithProgress)d);
            if (d.getStatus() == -1) {
                this.showError(InvokeMessages.getString("InvokeAction.execute.windowTitle.error"), String.valueOf(InvokeMessages.getString("InvokeAction.execute.message")) + command.toOSString());
            }
            return d.getOutputs();
        }
        catch (InvocationTargetException e) {
            this.showError(InvokeMessages.getString("InvokeAction.execute.windowTitle.error"), String.valueOf(InvokeMessages.getString("InvokeAction.execute.message")) + command.toOSString());
            AutotoolsPlugin.logException(e);
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    protected void executeConsoleCommand(String actionName, String command, String[] argumentList, IPath execDir) {
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        Job backgroundJob = new Job(actionName, (ISchedulingRule)rule, actionName, execDir, command, argumentList){
            private final /* synthetic */ ISchedulingRule val$rule;
            private final /* synthetic */ String val$actionName;
            private final /* synthetic */ IPath val$execDir;
            private final /* synthetic */ String val$command;
            private final /* synthetic */ String[] val$argumentList;
            {
                this.val$rule = iSchedulingRule;
                this.val$actionName = string;
                this.val$execDir = iPath;
                this.val$command = string2;
                this.val$argumentList = stringArray;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            try {
                                String errMsg = null;
                                IProject project = InvokeAction.this.getSelectedContainer().getProject();
                                IConsole console = CCorePlugin.getDefault().getConsole("org.eclipse.linuxtools.cdt.autotools.autotoolsConsole");
                                console.start(project);
                                ConsoleOutputStream consoleOutStream = console.getOutputStream();
                                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
                                IConfiguration cfg = info.getDefaultConfiguration();
                                StringBuffer buf = new StringBuffer();
                                String[] consoleHeader = new String[]{val$actionName, cfg.getName(), project.getName()};
                                buf.append(System.getProperty("line.separator", "\n"));
                                String invokeMsg = InvokeMessages.getFormattedString("InvokeAction.console.message", new String[]{val$actionName, val$execDir.toString()});
                                buf.append(invokeMsg);
                                buf.append(System.getProperty("line.separator", "\n"));
                                buf.append(System.getProperty("line.separator", "\n"));
                                consoleOutStream.write(buf.toString().getBytes());
                                consoleOutStream.flush();
                                ArrayList<String> additionalEnvs = new ArrayList<String>();
                                String strippedCommand = MakeGenerator.stripEnvVars(val$command, additionalEnvs);
                                CommandLauncher launcher = new CommandLauncher();
                                IEnvironmentVariable[] variables = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(cfg, true);
                                String[] env = null;
                                ArrayList<String> envList = new ArrayList<String>();
                                if (variables != null) {
                                    int i = 0;
                                    while (i < variables.length) {
                                        envList.add(String.valueOf(variables[i].getName()) + "=" + variables[i].getValue());
                                        ++i;
                                    }
                                    if (additionalEnvs.size() > 0) {
                                        envList.addAll(additionalEnvs);
                                    }
                                    env = envList.toArray(new String[envList.size()]);
                                }
                                ConsoleOutputStream stdout = consoleOutStream;
                                ConsoleOutputStream stderr = consoleOutStream;
                                launcher.showCommand(true);
                                Process proc = launcher.execute((IPath)new Path(strippedCommand), val$argumentList, env, val$execDir, (IProgressMonitor)new NullProgressMonitor());
                                if (proc != null) {
                                    try {
                                        proc.getOutputStream().close();
                                    }
                                    catch (IOException iOException) {}
                                    if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)new SubProgressMonitor(monitor, -1)) != 0) {
                                        errMsg = launcher.getErrorMessage();
                                    }
                                    monitor.subTask(AutotoolsPlugin.getResourceString("MakeGenerator.refresh"));
                                    try {
                                        project.refreshLocal(2, null);
                                    }
                                    catch (CoreException coreException) {
                                        monitor.subTask(AutotoolsPlugin.getResourceString("MakeGenerator.refresh.error"));
                                    }
                                } else {
                                    errMsg = launcher.getErrorMessage();
                                }
                                if (errMsg != null) {
                                    AutotoolsPlugin.logErrorMessage(errMsg);
                                }
                            }
                            catch (IOException e) {
                                AutotoolsPlugin.log(e);
                            }
                        }
                    }, this.val$rule, 1, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                IStatus returnStatus = Status.OK_STATUS;
                return returnStatus;
            }
        };
        backgroundJob.setRule((ISchedulingRule)rule);
        backgroundJob.schedule();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecuteProgressDialog
    implements IRunnableWithProgress {
        private IPath command;
        private String[] argumentList;
        private String[] envList;
        private IPath execDir;
        private int status;
        private HashMap<String, String> outputs = null;

        public ExecuteProgressDialog(IPath command, String[] argumentList, String[] envList, IPath execDir) {
            this.command = command;
            this.argumentList = argumentList;
            this.envList = envList;
            this.execDir = execDir;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            ByteArrayOutputStream stderr;
            ByteArrayOutputStream stdout;
            block7: {
                stdout = new ByteArrayOutputStream();
                stderr = new ByteArrayOutputStream();
                CommandLauncher cmdL = new CommandLauncher();
                this.outputs = null;
                try {
                    monitor.beginTask(InvokeMessages.getFormattedString("InvokeAction.progress.message", new String[]{this.command.toOSString()}), -1);
                    monitor.worked(1);
                    Process process = cmdL.execute(this.command, this.argumentList, this.envList, this.execDir, (IProgressMonitor)new NullProgressMonitor());
                    if (cmdL.waitAndRead((OutputStream)stdout, (OutputStream)stderr) == 0) {
                        try {
                            this.status = 0;
                            monitor.done();
                            process.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                        break block7;
                    }
                    this.status = -1;
                    monitor.done();
                    return;
                }
                catch (CoreException e) {
                    monitor.done();
                    throw new InvocationTargetException(e);
                }
            }
            this.outputs = new HashMap();
            this.outputs.put("stdout", stdout.toString());
            this.outputs.put("stderr", stderr.toString());
            try {
                stdout.close();
                stderr.close();
            }
            catch (IOException iOException) {}
        }

        public HashMap<String, String> getOutputs() {
            return this.outputs;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

