/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.actions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.linuxtools.cdt.autotools.actions.InvokeAction;
import org.eclipse.linuxtools.cdt.autotools.actions.InvokeMessages;
import org.eclipse.linuxtools.cdt.autotools.actions.TwoInputDialog;
import org.eclipse.linuxtools.cdt.autotools.ui.properties.AutotoolsPropertyConstants;
import org.eclipse.swt.widgets.Shell;

public class InvokeAutomakeAction
extends InvokeAction {
    private static final String DEFAULT_OPTION = "";
    private static final String DEFAULT_COMMAND = "automake";

    public void run(IAction action) {
        IContainer container = this.getSelectedContainer();
        if (container == null) {
            return;
        }
        IPath execDir = this.getExecDir(container);
        String cwd = String.valueOf(InvokeMessages.getString("CWD")) + this.getCWD(container);
        TwoInputDialog optionDialog = new TwoInputDialog(new Shell(), cwd, InvokeMessages.getString("InvokeAutomakeAction.windowTitle.options"), InvokeMessages.getString("InvokeAutomakeAction.message.options.otherOptions"), InvokeMessages.getString("InvokeAutomakeAction.message.options.makeTargets"), DEFAULT_OPTION, null);
        optionDialog.open();
        String rawArgList = optionDialog.getValue();
        String[] optionsList = this.separateOptions(rawArgList);
        rawArgList = optionDialog.getSecondValue();
        String[] targetList = this.separateTargets(rawArgList);
        if (targetList == null) {
            this.showError(InvokeMessages.getString("InvokeAction.execute.windowTitle.error"), InvokeMessages.getString("InvokeAction.windowTitle.quoteError"));
            return;
        }
        String[] argumentList = new String[targetList.length + optionsList.length];
        System.arraycopy(optionsList, 0, argumentList, 0, optionsList.length);
        System.arraycopy(targetList, 0, argumentList, optionsList.length, targetList.length);
        if (container != null) {
            IProject project = container.getProject();
            String automakeCommand = null;
            try {
                automakeCommand = project.getPersistentProperty(AutotoolsPropertyConstants.AUTOMAKE_TOOL);
            }
            catch (CoreException coreException) {}
            if (automakeCommand == null) {
                automakeCommand = DEFAULT_COMMAND;
            }
            this.executeConsoleCommand(DEFAULT_COMMAND, automakeCommand, argumentList, execDir);
        }
    }

    public void dispose() {
    }
}

