/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.actions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.linuxtools.cdt.autotools.actions.InvokeAction;
import org.eclipse.linuxtools.cdt.autotools.actions.InvokeMessages;
import org.eclipse.linuxtools.cdt.autotools.actions.SingleInputDialog;
import org.eclipse.linuxtools.cdt.autotools.ui.properties.AutotoolsPropertyConstants;
import org.eclipse.swt.widgets.Shell;

public class InvokeLibtoolizeAction
extends InvokeAction {
    private static final String DEFAULT_OPTION = "";
    private static final String DEFAULT_COMMAND = "libtoolize";

    public void run(IAction action) {
        IContainer container = this.getSelectedContainer();
        if (container == null) {
            return;
        }
        IPath execDir = this.getExecDir(container);
        String cwd = String.valueOf(InvokeMessages.getString("CWD")) + this.getCWD(container);
        SingleInputDialog optionDialog = new SingleInputDialog(new Shell(), cwd, InvokeMessages.getString("InvokeLibtoolizeAction.windowTitle.options"), InvokeMessages.getString("InvokeLibtoolizeAction.message.options.otherOptions"), DEFAULT_OPTION, null);
        optionDialog.open();
        String rawArgList = optionDialog.getValue();
        String[] optionsList = this.simpleParseOptions(rawArgList);
        String[] argumentList = new String[optionsList.length];
        System.arraycopy(optionsList, 0, argumentList, 0, optionsList.length);
        if (container != null) {
            String libtoolizeCommand = null;
            IProject project = this.getSelectedContainer().getProject();
            try {
                libtoolizeCommand = project.getPersistentProperty(AutotoolsPropertyConstants.AUTOHEADER_TOOL);
            }
            catch (CoreException coreException) {}
            if (libtoolizeCommand == null) {
                libtoolizeCommand = DEFAULT_COMMAND;
            }
            this.executeConsoleCommand(DEFAULT_COMMAND, libtoolizeCommand, argumentList, execDir);
        }
    }

    public void dispose() {
    }
}

