/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.ui.editors.parser;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.AutoconfEditorMessages;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.IAutoconfErrorHandler;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.ParseException;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.Token;

public class AutoconfTokenizer {
    private static final String UNTERMINATED_STRING = "UnterminatedString";
    public static final String UNMATCHED_RIGHT_QUOTE = "UnmatchedRightQuote";
    public static final String UNMATCHED_LEFT_QUOTE = "UnmatchedLeftQuote";
    public static final String UNMATCHED_CLOSE_COMMENT = "UnmatchedCloseComment";
    private IDocument document;
    private int offset;
    private String m4OpenQuote;
    private String m4CloseQuote;
    private String m4OpenComment;
    private String m4CloseComment;
    private char[] chars;
    private int startOffset;
    private boolean isM4Context;
    private Token eofToken;
    private IAutoconfErrorHandler errorHandler;

    public AutoconfTokenizer(IDocument document, IAutoconfErrorHandler errorHandler) {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        this.document = document;
        this.errorHandler = errorHandler;
        this.chars = document.get().toCharArray();
        this.offset = 0;
        this.eofToken = new Token(0, "", document, this.chars.length, 0);
        this.m4OpenQuote = "`";
        this.m4CloseQuote = "'";
        this.m4OpenComment = "#";
        this.m4CloseComment = "\n";
    }

    public boolean isM4Context() {
        return this.isM4Context;
    }

    public void setM4Context(boolean flag) {
        this.isM4Context = flag;
    }

    public void setM4Quote(String open, String close) {
        this.m4OpenQuote = open;
        this.m4CloseQuote = close;
    }

    public void setM4Comment(String open, String close) {
        this.m4OpenComment = open;
        this.m4CloseComment = close;
    }

    public void unreadToken(Token token) {
        if (token.getLength() > 0 && this.offset == token.getOffset()) {
            throw new IllegalStateException();
        }
        this.offset = token.getOffset();
    }

    public Token readToken() {
        if (this.offset >= this.chars.length) {
            return this.eofToken;
        }
        char ch = this.chars[this.offset];
        while (this.isWhitespace(ch)) {
            ++this.offset;
            if (this.offset >= this.chars.length) {
                return this.eofToken;
            }
            ch = this.chars[this.offset];
        }
        if (!this.isM4Context && ch == '#') {
            while (this.offset < this.chars.length) {
                ch = this.chars[this.offset];
                if (ch == '\n') break;
                ++this.offset;
            }
            if (this.offset >= this.chars.length) {
                --this.offset;
            }
        }
        this.startOffset = this.offset;
        StringBuffer buffer = new StringBuffer();
        if (ch == '\r' || ch == '\n') {
            buffer.append(ch);
            ++this.offset;
            if (ch == '\r' && this.offset < this.chars.length && this.chars[this.offset] == '\n') {
                buffer.append(this.chars[this.offset++]);
            }
            return this.makeToken(1, buffer.toString());
        }
        if (this.isLeadIdentifierChar(ch)) {
            return this.parseWord(ch);
        }
        if (this.isM4Context) {
            if (this.lookAhead(this.m4OpenComment)) {
                boolean found = false;
                while (this.offset < this.chars.length) {
                    if (this.lookAhead(this.m4CloseComment)) {
                        found = true;
                        break;
                    }
                    ++this.offset;
                }
                if (!found) {
                    this.handleError(this.startOffset, this.offset, AutoconfEditorMessages.getFormattedString(UNMATCHED_CLOSE_COMMENT, this.m4CloseComment.equals("\n") ? "newline" : this.m4CloseComment));
                }
                return this.makeToken(22);
            }
            if (this.lookAhead(this.m4OpenQuote)) {
                return this.parseQuote();
            }
        }
        if (!this.isM4Context) {
            if (ch == ';' && this.offset + 1 < this.chars.length && this.chars[this.offset + 1] == ';') {
                this.offset += 2;
                return this.makeToken(53);
            }
            if (ch == '<' && this.offset + 1 < this.chars.length && this.chars[this.offset + 1] == '<') {
                this.offset += 2;
                if (this.offset < this.chars.length && this.chars[this.offset] == '-') {
                    ++this.offset;
                    return this.makeToken(66);
                }
                return this.makeToken(65);
            }
            switch (ch) {
                case '$': {
                    ++this.offset;
                    return this.makeToken(60);
                }
                case '[': {
                    ++this.offset;
                    return this.makeToken(63);
                }
                case ']': {
                    ++this.offset;
                    return this.makeToken(64);
                }
                case '{': {
                    ++this.offset;
                    return this.makeToken(61);
                }
                case '}': {
                    ++this.offset;
                    return this.makeToken(62);
                }
                case '\'': {
                    return this.parseString(68, ch);
                }
                case '\"': {
                    return this.parseString(67, ch);
                }
                case '`': {
                    return this.parseString(69, ch);
                }
            }
        }
        if (ch == ';') {
            ++this.offset;
            return this.makeToken(5);
        }
        if (ch == ',') {
            ++this.offset;
            return this.makeToken(4);
        }
        if (ch == '(') {
            ++this.offset;
            return this.makeToken(2);
        }
        if (ch == ')') {
            ++this.offset;
            return this.makeToken(3);
        }
        ++this.offset;
        return this.makeToken(7);
    }

    private Token parseWord(char ch) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ch);
        ++this.offset;
        while (this.offset < this.chars.length && this.isIdentifierChar(ch = this.chars[this.offset])) {
            buffer.append(ch);
            ++this.offset;
        }
        String text = buffer.toString();
        if (!this.isM4Context) {
            if ("case".equals(text)) {
                return this.makeToken(51, text);
            }
            if ("in".equals(text)) {
                return this.makeToken(52, text);
            }
            if ("esac".equals(text)) {
                return this.makeToken(54, text);
            }
            if ("while".equals(text)) {
                return this.makeToken(45, text);
            }
            if ("select".equals(text)) {
                return this.makeToken(47, text);
            }
            if ("until".equals(text)) {
                return this.makeToken(48, text);
            }
            if ("for".equals(text)) {
                return this.makeToken(46, text);
            }
            if ("do".equals(text)) {
                return this.makeToken(49, text);
            }
            if ("done".equals(text)) {
                return this.makeToken(50, text);
            }
            if ("if".equals(text)) {
                return this.makeToken(40, text);
            }
            if ("then".equals(text)) {
                return this.makeToken(41, text);
            }
            if ("else".equals(text)) {
                return this.makeToken(42, text);
            }
            if ("elif".equals(text)) {
                return this.makeToken(43, text);
            }
            if ("fi".equals(text)) {
                return this.makeToken(44, text);
            }
        }
        return this.makeToken(6, text);
    }

    private Token parseQuote() {
        StringBuffer buffer = new StringBuffer();
        int quoteLevel = 1;
        while (this.offset < this.chars.length) {
            if (this.lookAhead(this.m4CloseQuote)) {
                if (--quoteLevel == 0) break;
                buffer.append(this.m4CloseQuote);
                continue;
            }
            if (this.lookAhead(this.m4OpenQuote)) {
                buffer.append(this.m4OpenQuote);
                ++quoteLevel;
                continue;
            }
            buffer.append(this.chars[this.offset]);
            ++this.offset;
        }
        if (quoteLevel > 0) {
            this.handleError(this.startOffset, this.offset, AutoconfEditorMessages.getFormattedString(UNMATCHED_LEFT_QUOTE, this.m4CloseQuote));
        } else if (quoteLevel < 0) {
            this.handleError(this.startOffset, this.offset, AutoconfEditorMessages.getFormattedString(UNMATCHED_RIGHT_QUOTE, this.m4OpenQuote));
        }
        return this.makeToken(21, buffer.toString());
    }

    private Token parseString(int type, char terminal) {
        this.startOffset = this.offset++;
        StringBuffer buffer = new StringBuffer();
        char ch = '\u0000';
        while (this.offset < this.chars.length) {
            if ((ch = this.chars[this.offset++]) == '\\') {
                if (this.offset < this.chars.length) {
                    buffer.append(this.chars[this.offset++]);
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            if (ch == terminal) break;
            buffer.append(ch);
        }
        if (ch != terminal) {
            this.handleError(this.startOffset, this.offset, AutoconfEditorMessages.getFormattedString(UNTERMINATED_STRING, "" + ch));
        }
        return this.makeToken(type, buffer.toString());
    }

    private void handleError(int start, int end, String message) {
        if (this.errorHandler != null) {
            int lineNumber = 0;
            int startColumn = 0;
            int endColumn = 0;
            try {
                lineNumber = this.document.getLineOfOffset(start);
                int lineOffs = this.document.getLineOffset(lineNumber);
                startColumn = start - lineOffs;
                endColumn = end - lineOffs;
            }
            catch (BadLocationException badLocationException) {}
            this.errorHandler.handleError(new ParseException(message, start, end, lineNumber, startColumn, endColumn, 2));
        }
    }

    private boolean lookAhead(String keyword) {
        int length = keyword.length();
        if (this.offset + length > this.chars.length) {
            return false;
        }
        int idx = 0;
        while (idx < length) {
            if (this.chars[this.offset + idx] != keyword.charAt(idx)) {
                return false;
            }
            ++idx;
        }
        this.offset += length;
        return true;
    }

    private boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\f';
    }

    private Token makeToken(int type) {
        return new Token(type, new String(this.chars, this.startOffset, this.offset - this.startOffset), this.document, this.startOffset, this.offset - this.startOffset);
    }

    private Token makeToken(int type, String text) {
        return new Token(type, text, this.document, this.startOffset, this.offset - this.startOffset);
    }

    private boolean isIdentifierChar(char ch) {
        return this.isLeadIdentifierChar(ch) || ch >= '0' && ch <= '9';
    }

    private boolean isLeadIdentifierChar(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_';
    }

    public Token peekToken() {
        Token token = this.readToken();
        this.unreadToken(token);
        return token;
    }
}

