/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.ui.properties;

import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.cdt.autotools.AutotoolsMakefileBuilder;
import org.eclipse.linuxtools.cdt.autotools.ui.properties.AutotoolsPropertyConstants;
import org.eclipse.linuxtools.cdt.autotools.ui.properties.AutotoolsPropertyMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AutotoolsBuildPropertyPage
extends AbstractCBuildPropertyTab {
    private String TRUE = "true";
    private String FALSE = "false";
    private String SCANNERMAKEW_LABEL = "ScannerMakeW.label";
    private String SCANNERMAKEW_TOOLTIP = "ScannerMakeW.tooltip";
    protected Button fCleanDelete;
    protected Button fCleanMake;
    protected Text fCleanMakeTarget;
    protected Button fScannerMakeW;

    private IProject getProject() {
        return (IProject)this.getCfg().getManagedProject().getOwner();
    }

    public boolean canBeVisible() {
        return AutotoolsMakefileBuilder.hasTargetBuilder(this.getProject());
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        Composite composite = this.usercomp;
        GridData gd = new GridData(848);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Group g = new Group(composite, 16);
        g.setText(AutotoolsPropertyMessages.getString("CleanBehavior.title"));
        gd = new GridData(834);
        gd.horizontalSpan = 2;
        g.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        g.setLayout((Layout)layout);
        this.fCleanDelete = new Button((Composite)g, 16);
        this.fCleanDelete.setText(AutotoolsPropertyMessages.getString("CleanDelete.label"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fCleanDelete.setLayoutData((Object)gd);
        this.fCleanMake = new Button((Composite)g, 16);
        this.fCleanMake.setText(AutotoolsPropertyMessages.getString("CleanMake.label"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fCleanMake.setLayoutData((Object)gd);
        Label label = new Label((Composite)g, 16384);
        label.setText(AutotoolsPropertyMessages.getString("CleanMakeTarget.label"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fCleanMakeTarget = new Text((Composite)g, 2052);
        this.fCleanMakeTarget.setText("distclean");
        gd = new GridData(802);
        this.fCleanMakeTarget.setLayoutData((Object)gd);
        this.fCleanDelete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AutotoolsBuildPropertyPage.this.fCleanMake.setSelection(false);
                AutotoolsBuildPropertyPage.this.fCleanDelete.setSelection(true);
                AutotoolsBuildPropertyPage.this.fCleanMakeTarget.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fCleanMake.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AutotoolsBuildPropertyPage.this.fCleanDelete.setSelection(false);
                AutotoolsBuildPropertyPage.this.fCleanMake.setSelection(true);
                AutotoolsBuildPropertyPage.this.fCleanMakeTarget.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fCleanMakeTarget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AutotoolsBuildPropertyPage.this.fCleanMakeTarget.getText().equals("");
            }
        });
        this.fScannerMakeW = new Button(composite, 16416);
        this.fScannerMakeW.setText(AutotoolsPropertyMessages.getString(this.SCANNERMAKEW_LABEL));
        this.fScannerMakeW.setToolTipText(AutotoolsPropertyMessages.getString(this.SCANNERMAKEW_TOOLTIP));
        gd = new GridData(34);
        this.fScannerMakeW.setLayoutData((Object)gd);
        this.initialize();
    }

    protected void performOK() {
        IProject project = this.getProject();
        if (this.fCleanDelete.getSelection()) {
            try {
                project.setPersistentProperty(AutotoolsPropertyConstants.CLEAN_DELETE, this.TRUE);
            }
            catch (CoreException coreException) {}
        } else {
            try {
                project.setPersistentProperty(AutotoolsPropertyConstants.CLEAN_DELETE, this.FALSE);
            }
            catch (CoreException coreException) {}
            try {
                project.setPersistentProperty(AutotoolsPropertyConstants.CLEAN_MAKE_TARGET, this.fCleanMakeTarget.getText());
            }
            catch (CoreException coreException) {}
        }
        boolean setScannerInfoDirty = false;
        try {
            String oldScannerMakeW = project.getPersistentProperty(AutotoolsPropertyConstants.SCANNER_USE_MAKE_W);
            if (this.fScannerMakeW.getSelection()) {
                project.setPersistentProperty(AutotoolsPropertyConstants.SCANNER_USE_MAKE_W, this.TRUE);
                if (oldScannerMakeW == null || !oldScannerMakeW.equals(this.TRUE)) {
                    setScannerInfoDirty = true;
                }
            } else {
                project.setPersistentProperty(AutotoolsPropertyConstants.SCANNER_USE_MAKE_W, null);
                if (oldScannerMakeW != null && oldScannerMakeW.equals(this.TRUE)) {
                    setScannerInfoDirty = true;
                }
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        if (setScannerInfoDirty) {
            try {
                project.setSessionProperty(AutotoolsPropertyConstants.SCANNER_INFO_DIRTY, (Object)Boolean.TRUE);
            }
            catch (CoreException coreException) {}
        }
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.performOK();
    }

    protected void performDefaults() {
        this.fCleanDelete.setSelection(false);
        this.fCleanMake.setSelection(true);
        this.fCleanMakeTarget.setText("distclean");
        this.fCleanMakeTarget.setEnabled(true);
        this.fScannerMakeW.setSelection(true);
    }

    public void updateData(ICResourceDescription cfgd) {
    }

    public void updateButtons() {
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    private void initialize() {
        IProject project = this.getProject();
        String cleanDelete = null;
        String cleanMakeTarget = null;
        String scannerMakeW = null;
        try {
            cleanDelete = project.getPersistentProperty(AutotoolsPropertyConstants.CLEAN_DELETE);
            cleanMakeTarget = project.getPersistentProperty(AutotoolsPropertyConstants.CLEAN_MAKE_TARGET);
            scannerMakeW = project.getPersistentProperty(AutotoolsPropertyConstants.SCANNER_USE_MAKE_W);
        }
        catch (CoreException coreException) {}
        if (cleanMakeTarget == null) {
            cleanMakeTarget = "distclean";
        }
        this.fCleanMakeTarget.setText(cleanMakeTarget);
        if (cleanDelete == null || cleanDelete.equals(this.FALSE)) {
            this.fCleanDelete.setSelection(false);
            this.fCleanMake.setSelection(true);
            this.fCleanMakeTarget.setEnabled(true);
        } else {
            this.fCleanDelete.setSelection(true);
            this.fCleanMake.setSelection(false);
            this.fCleanMakeTarget.setEnabled(false);
        }
        if (scannerMakeW == null || !scannerMakeW.equals(this.TRUE)) {
            this.fScannerMakeW.setSelection(false);
        } else {
            this.fScannerMakeW.setSelection(true);
        }
    }
}

