/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.ui.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.linuxtools.cdt.autotools.ui.properties.IProjectPropertyListener;
import org.eclipse.linuxtools.cdt.autotools.ui.properties.IPropertyChangeManager;

public class AutotoolsPropertyManager
implements IPropertyChangeManager {
    private static AutotoolsPropertyManager fInstance;
    private Map<IProject, ListenerList> projectList = new HashMap<IProject, ListenerList>();

    private AutotoolsPropertyManager() {
    }

    public static AutotoolsPropertyManager getDefault() {
        if (fInstance == null) {
            fInstance = new AutotoolsPropertyManager();
        }
        return fInstance;
    }

    public synchronized void addProjectPropertyListener(IProject project, IProjectPropertyListener listener) {
        ListenerList list = this.projectList.get(project);
        if (list == null) {
            list = new ListenerList();
            this.projectList.put(project, list);
        }
        list.add((Object)listener);
    }

    public synchronized void notifyPropertyListeners(IProject project, String property) {
        ListenerList list = this.projectList.get(project);
        if (list != null) {
            Object[] listeners = list.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IProjectPropertyListener)listeners[i]).handleProjectPropertyChanged(project, property);
                ++i;
            }
        }
    }

    public synchronized void removeProjectPropertyListener(IProject project, IProjectPropertyListener listener) {
        ListenerList list = this.projectList.get(project);
        if (list != null) {
            list.remove((Object)listener);
        }
    }
}

