/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.properties;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.cdt.libhover.LibhoverPlugin;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHover;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHoverMessages;
import org.eclipse.linuxtools.internal.cdt.libhover.preferences.PreferenceConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.PropertyPage;

public class LibHoverPropertyPage
extends PropertyPage {
    private static final String PROJECT_SPECIFIC_MSG = "Libhover.projectSpecific.msg";
    private static final String LIBHOVER_PROPERTY = "LIBHOVER";
    private QualifiedName libhoverProperty = new QualifiedName(LibhoverPlugin.getID(), "LIBHOVER");
    private Button projectSpecific;
    private HashMap<String, String> mapItems = new HashMap();
    private Table table;
    private CheckboxTableViewer tv;
    private Button[] buttons;
    private Composite buttoncomp;
    public static final String EMPTY_STR = "";
    public static final String MOVEUP_STR = LibHoverMessages.getString("FileListControl.moveup");
    public static final String MOVEDOWN_STR = LibHoverMessages.getString("FileListControl.movedown");

    public LibHoverPropertyPage() {
        this.setPreferenceStore(LibhoverPlugin.getDefault().getPreferenceStore());
    }

    private IProject getProject() {
        IResource r = (IResource)this.getElement().getAdapter(IResource.class);
        return r.getProject();
    }

    private String getPropertyString() {
        String p;
        try {
            p = this.getProject().getPersistentProperty(this.libhoverProperty);
        }
        catch (CoreException coreException) {
            p = null;
        }
        return p;
    }

    private void addFirstSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        this.projectSpecific = new Button(composite, 32);
        this.projectSpecific.setText(LibHoverMessages.getString(PROJECT_SPECIFIC_MSG));
        String p = this.getPropertyString();
        this.projectSpecific.setSelection(p != null);
        this.projectSpecific.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LibHoverPropertyPage.this.projectSpecificPressed(event);
            }
        });
    }

    private void projectSpecificPressed(SelectionEvent event) {
        if (this.projectSpecific.getSelection()) {
            this.buttoncomp.setEnabled(true);
            this.table.setEnabled(true);
            this.updateCheckboxData(true);
        } else {
            this.buttoncomp.setEnabled(false);
            this.table.setEnabled(false);
            this.updateCheckboxData(false);
        }
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addLabel(Composite parent) {
        Label label = new Label(parent, 256);
        label.setText(LibHoverMessages.getString("LibhoverPreferences.title"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    private Control getCheckboxControl(Composite parent) {
        if (this.table == null) {
            this.table = new Table(parent, 2084);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.horizontalSpan = 2;
            this.table.setLayoutData((Object)gridData);
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LibHoverPropertyPage.this.updateButtons();
                }
            });
            this.tv = new CheckboxTableViewer(this.table);
            this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return (Object[])inputElement;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.tv.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent e) {
                }
            });
        }
        return this.table;
    }

    private Control getButtonControl(Composite parent) {
        if (this.buttoncomp == null) {
            this.buttoncomp = new Composite(parent, 0);
            GridData d = new GridData(3);
            d.widthHint = 1;
            d.horizontalSpan = 1;
            this.buttoncomp.setLayoutData((Object)d);
            this.buttoncomp.setFont(parent.getFont());
            String[] stringArray = new String[5];
            stringArray[0] = MOVEUP_STR;
            stringArray[1] = MOVEDOWN_STR;
            stringArray[3] = UIMessages.getString((String)"ErrorParsTab.0");
            stringArray[4] = UIMessages.getString((String)"ErrorParsTab.1");
            this.initButtons(this.buttoncomp, stringArray);
        }
        return this.buttoncomp;
    }

    private void addSecondSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        this.getCheckboxControl(composite);
        this.getButtonControl(composite);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        this.addFirstSection(composite);
        this.addSeparator(composite);
        this.addLabel(composite);
        this.addSecondSection(composite);
        String p = this.getPropertyString();
        this.updateCheckboxData(p != null);
        this.buttoncomp.setEnabled(p != null);
        this.table.setEnabled(p != null);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
        this.updateCheckboxData(this.projectSpecific.getSelection());
    }

    public boolean performOk() {
        try {
            this.save();
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    private void initButtons(Composite c, String[] names) {
        this.initButtons(c, names, 80);
    }

    private void initButtons(Composite c, String[] names, int width) {
        if (names == null || names.length == 0) {
            return;
        }
        c.setLayoutData((Object)new GridData(1040));
        c.setLayout((Layout)new GridLayout(1, false));
        this.buttons = new Button[names.length];
        int i = 0;
        while (i < names.length) {
            this.buttons[i] = new Button(c, 8);
            this.buttons[i].setFont(c.getFont());
            GridData gdb = new GridData(4);
            gdb.grabExcessHorizontalSpace = false;
            gdb.horizontalAlignment = 4;
            gdb.minimumWidth = width;
            if (names[i] != null) {
                this.buttons[i].setText(names[i]);
            } else {
                this.buttons[i].setVisible(false);
                this.buttons[i].setEnabled(false);
                gdb.heightHint = 10;
            }
            this.buttons[i].setLayoutData((Object)gdb);
            this.buttons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    LibHoverPropertyPage.this.buttonPressed(event);
                }
            });
            ++i;
        }
    }

    private void buttonPressed(SelectionEvent e) {
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i].equals(e.widget)) {
                this.buttonPressed(i);
                return;
            }
            ++i;
        }
    }

    private void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.moveItem(true);
                break;
            }
            case 1: {
                this.moveItem(false);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.tv.setAllChecked(true);
                break;
            }
            case 4: {
                this.tv.setAllChecked(false);
                break;
            }
        }
    }

    private void moveItem(boolean up) {
        int n = this.table.getSelectionIndex();
        if (n < 0 || up && n == 0 || !up && n + 1 == this.table.getItemCount()) {
            return;
        }
        TableData d = (TableData)this.tv.getElementAt(n);
        boolean checked = this.tv.getChecked((Object)d);
        this.tv.remove((Object)d);
        n = up ? n - 1 : n + 1;
        this.tv.insert((Object)d, n);
        this.tv.setChecked((Object)d, checked);
        this.table.setSelection(n);
    }

    private void buttonSetEnabled(int i, boolean state) {
        if (this.buttons == null || this.buttons.length <= i) {
            return;
        }
        this.buttons[i].setEnabled(state);
    }

    private void updateButtons() {
        int cnt = this.table.getItemCount();
        int pos = this.table.getSelectionIndex();
        this.buttonSetEnabled(0, pos > 0);
        this.buttonSetEnabled(1, pos != -1 && pos < cnt - 1);
        this.buttonSetEnabled(3, cnt > 0);
        this.buttonSetEnabled(4, cnt > 0);
    }

    private void getExtensions() {
        this.mapItems.clear();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(LibHover.LIBHOVER_DOC_EXTENSION);
        if (point != null) {
            IExtension[] exts;
            IExtension[] iExtensionArray = exts = point.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                if (ext.getConfigurationElements().length > 0) {
                    this.mapItems.put(ext.getUniqueIdentifier(), ext.getLabel());
                }
                ++n2;
            }
        }
    }

    private void updateCheckboxData(boolean useProject) {
        String[] tokens;
        this.getExtensions();
        HashMap copyMap = (HashMap)this.mapItems.clone();
        ArrayList<TableData> data = new ArrayList<TableData>();
        ArrayList<TableData> checkedData = new ArrayList<TableData>();
        String prop = null;
        String pref = null;
        if (useProject) {
            prop = this.getPropertyString();
        }
        if ((tokens = (pref = prop == null ? this.getPreferenceStore().getString(PreferenceConstants.P_LIBHOVER) : prop).split(":")).length > 1) {
            int i = 0;
            while (i < tokens.length) {
                String id = tokens[i];
                Boolean checked = Boolean.valueOf(tokens[i + 1]);
                String value = (String)copyMap.get(id);
                if (value != null) {
                    TableData d = new TableData(id, value);
                    data.add(d);
                    if (checked.booleanValue()) {
                        checkedData.add(d);
                    }
                    copyMap.remove(id);
                }
                i += 2;
            }
        }
        String[] leftovers = new String[copyMap.size()];
        leftovers = copyMap.keySet().toArray(leftovers);
        int i = 0;
        while (i < leftovers.length) {
            TableData d = new TableData(leftovers[i], (String)copyMap.get(leftovers[i]));
            data.add(d);
            if (!useProject || prop == null) {
                checkedData.add(d);
            }
            ++i;
        }
        this.tv.setInput((Object)data.toArray());
        this.tv.setCheckedElements(checkedData.toArray());
        this.updateButtons();
    }

    private void save() throws CoreException {
        if (!this.projectSpecific.getSelection()) {
            this.getProject().setPersistentProperty(this.libhoverProperty, null);
        }
        boolean inRange = true;
        int i = 0;
        String outString = new String();
        String del = EMPTY_STR;
        while (inRange) {
            Object obj = this.tv.getElementAt(i);
            if (obj == null) {
                inRange = false;
                continue;
            }
            ++i;
            TableData t = (TableData)obj;
            outString = String.valueOf(outString) + del + t.key + ":" + this.tv.getChecked(obj);
            del = ":";
        }
        if (outString.length() > 1) {
            this.getProject().setPersistentProperty(this.libhoverProperty, outString);
        }
    }

    private class TableData {
        String key;
        String value;

        public TableData(String _key, String _value) {
            this.key = _key;
            this.value = _value;
        }

        public String toString() {
            return this.value;
        }
    }
}

