/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.Serializer;
import org.eclipse.birt.chart.model.impl.SerializerImpl;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.jface.action.Action;
import org.eclipse.linuxtools.dataviewers.charts.UIHelper;
import org.eclipse.linuxtools.dataviewers.charts.view.ChartView;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class OpenChartAction
extends Action {
    private Chart chart = null;
    private FileDialog dialog;
    private ChartView chartView;

    public OpenChartAction(Shell shell, ChartView cView) {
        this.setImageDescriptor(UIHelper.getImageDescriptor("icons/eimport.gif"));
        this.setDisabledImageDescriptor(UIHelper.getImageDescriptor("icons/dimport.gif"));
        this.setToolTipText("Open XML Source");
        this.setEnabled(true);
        this.chartView = cView;
        this.dialog = new FileDialog(shell, 4096);
        this.dialog.setText("Select a chart file ");
        this.dialog.setFilterExtensions(new String[]{"*.chart"});
    }

    public void run() {
        String path = this.dialog.open();
        if (path == null) {
            return;
        }
        Serializer serializer = null;
        File chartFile = new File(path);
        try {
            serializer = SerializerImpl.instance();
            if (chartFile.exists()) {
                this.chart = serializer.read((InputStream)new FileInputStream(chartFile));
                this.chartView.getChartViewer().setBuffer(null);
                this.chartView.setChart(this.chart);
            }
        }
        catch (Exception e) {
            WizardBase.displayException((Throwable)e);
        }
    }

    public Chart getChart() {
        return this.chart;
    }
}

