/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.GradientImpl;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.dataviewers.charts.provider.IChartField;

public class ChartFactory {
    public static final Chart producePieChart(Object[] objects, ISTDataViewersField nameField, List<IChartField> valFields) {
        ChartWithoutAxes cwoaPie = ChartWithoutAxesImpl.create();
        cwoaPie.setSeriesThickness(20.0);
        cwoaPie.setGridColumnCount(valFields.size());
        cwoaPie.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        cwoaPie.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        Plot p = cwoaPie.getPlot();
        p.getClientArea().setBackground(null);
        p.getClientArea().getOutline().setVisible(true);
        p.getOutline().setVisible(true);
        Legend lg = cwoaPie.getLegend();
        lg.getText().getFont().setSize(16.0f);
        lg.setBackground(null);
        lg.getOutline().setVisible(true);
        cwoaPie.getTitle().getLabel().getCaption().setValue(nameField.getColumnHeaderText());
        cwoaPie.getTitle().getOutline().setVisible(true);
        ArrayList<String> textLabels = new ArrayList<String>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            String label = nameField.getValue(obj);
            textLabels.add(label);
            ++n2;
        }
        TextDataSet categoryValues = TextDataSetImpl.create(textLabels);
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)categoryValues);
        SeriesDefinition sdBase = SeriesDefinitionImpl.create();
        cwoaPie.getSeriesDefinitions().add((Object)sdBase);
        sdBase.getSeriesPalette().shift(-1);
        sdBase.getSeries().add((Object)seCategory);
        SeriesDefinition sdValue = SeriesDefinitionImpl.create();
        sdBase.getSeriesDefinitions().add((Object)sdValue);
        for (IChartField field : valFields) {
            ArrayList<Double> doubleValues = new ArrayList<Double>();
            Object[] objectArray2 = objects;
            int n3 = objects.length;
            int n4 = 0;
            while (n4 < n3) {
                Object obj = objectArray2[n4];
                doubleValues.add(field.getNumber(obj).doubleValue());
                ++n4;
            }
            NumberDataSet Values = NumberDataSetImpl.create(doubleValues);
            PieSeries sePie = (PieSeries)PieSeriesImpl.create();
            sePie.setSeriesIdentifier((Object)field.getColumnHeaderText());
            sePie.setExplosion(3);
            sePie.setDataSet((DataSet)Values);
            ChartFactory.setTriggering((Series)sePie);
            sdValue.getSeries().add((Object)sePie);
        }
        return cwoaPie;
    }

    public static final Chart produceBarChart(Object[] objects, ISTDataViewersField nameField, List<IChartField> valFields, String title, boolean horizontal) {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Plot p = cwaBar.getPlot();
        p.getClientArea().setBackground((Fill)GradientImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)225, (int)225, (int)255), (ColorDefinition)ColorDefinitionImpl.create((int)255, (int)255, (int)225), (double)-35.0, (boolean)false));
        p.getOutline().setVisible(true);
        cwaBar.getTitle().getLabel().getCaption().setValue(title);
        cwaBar.getTitle().getOutline().setVisible(true);
        if (horizontal) {
            cwaBar.setTransposed(true);
        }
        Legend lg = cwaBar.getLegend();
        lg.getText().getFont().setSize(16.0f);
        Axis xAxisPrimary = cwaBar.getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(true);
        xAxisPrimary.setTitlePosition(Position.BELOW_LITERAL);
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.setLabelPosition(Position.BELOW_LITERAL);
        xAxisPrimary.getTitle().getCaption().setValue(nameField.getColumnHeaderText());
        Axis yAxisPrimary = cwaBar.getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        double max = -1.0;
        ArrayList<String> textLabels = new ArrayList<String>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            String label = nameField.getValue(obj);
            textLabels.add(label);
            ++n2;
        }
        TextDataSet categoryValues = TextDataSetImpl.create(textLabels);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().shift(-1);
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        for (IChartField field : valFields) {
            ArrayList<Double> doubleValues = new ArrayList<Double>();
            Object[] objectArray2 = objects;
            int n3 = objects.length;
            int n4 = 0;
            while (n4 < n3) {
                Object obj = objectArray2[n4];
                Number num = field.getNumber(obj);
                double longVal = num.doubleValue();
                max = longVal > max ? longVal : max;
                doubleValues.add(longVal);
                ++n4;
            }
            NumberDataSet orthoValues = NumberDataSetImpl.create(doubleValues);
            BarSeries bs = (BarSeries)BarSeriesImpl.create();
            bs.setSeriesIdentifier((Object)field.getColumnHeaderText());
            bs.setDataSet((DataSet)orthoValues);
            bs.setRiserOutline(null);
            ChartFactory.setTriggering((Series)bs);
            sdY.getSeries().add((Object)bs);
        }
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)categoryValues);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seCategory);
        return cwaBar;
    }

    public ISTDataViewersField getLabelField(AbstractSTViewer viewer) {
        return viewer.getAllFields()[0];
    }

    public static void setTriggering(Series series) {
        Trigger tr = TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)TooltipValueImpl.create((int)200, null)));
        series.getTriggers().add((Object)tr);
    }
}

