/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gcov.view;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.linuxtools.dataviewers.abstractview.AbstractSTDataView;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersImages;
import org.eclipse.linuxtools.dataviewers.actions.STExportToCSVAction;
import org.eclipse.linuxtools.dataviewers.charts.actions.ChartAction;
import org.eclipse.linuxtools.gcov.Activator;
import org.eclipse.linuxtools.gcov.action.SwitchContentProviderAction;
import org.eclipse.linuxtools.gcov.parser.CovManager;
import org.eclipse.linuxtools.gcov.parser.SourceFile;
import org.eclipse.linuxtools.gcov.view.CovFileContentProvider;
import org.eclipse.linuxtools.gcov.view.CovFolderContentProvider;
import org.eclipse.linuxtools.gcov.view.CovFunctionContentProvider;
import org.eclipse.linuxtools.gcov.view.CovViewer;
import org.eclipse.linuxtools.gcov.view.annotatedsource.OpenSourceFileAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CovView
extends AbstractSTDataView {
    private String defaultCSVPath = "gcov.csv";
    private Label label;
    private Action folderAction;
    private Action fileAction;
    private Action functionAction;

    protected AbstractSTViewer createAbstractSTViewer(Composite parent) {
        return new CovViewer(parent);
    }

    protected void contributeToToolbar(IToolBarManager manager) {
        super.contributeToToolbar(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.folderAction);
        manager.add((IAction)this.fileAction);
        manager.add((IAction)this.functionAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ChartAction(this.getViewSite().getShell(), this.getSTViewer()));
    }

    protected void createActions() {
        STDataViewersImages.getImageDescriptor((String)"");
        super.createActions();
        this.folderAction = new SwitchContentProviderAction("Sort coverage per folder", "icons/directory_obj.gif", this.getSTViewer().getViewer(), (IContentProvider)CovFolderContentProvider.sharedInstance);
        this.fileAction = new SwitchContentProviderAction("Sort coverage per file", "icons/c_file_obj.gif", this.getSTViewer().getViewer(), (IContentProvider)CovFileContentProvider.sharedInstance);
        this.fileAction.setChecked(true);
        this.functionAction = new SwitchContentProviderAction("Sort coverage per function", "icons/function_obj.gif", this.getSTViewer().getViewer(), (IContentProvider)CovFunctionContentProvider.sharedInstance);
    }

    public void createPartControl(Composite parent) {
        STDataViewersImages.getImageDescriptor((String)"");
        super.createPartControl(parent);
        GridLayout l = (GridLayout)parent.getLayout();
        l.horizontalSpacing = 0;
        l.verticalSpacing = 0;
        l.marginHeight = 0;
        l.marginWidth = 0;
    }

    protected void createTitle(Composite parent) {
        this.label = new Label(parent, 64);
        GridData data = new GridData(4, 1, true, false, 1, 1);
        this.label.setLayoutData((Object)data);
    }

    public static void setCovViewTitle(CovView view, String title, String binaryPath) {
        view.label.setText(" \n program runs = " + title + " \n program file : " + binaryPath + "\n ");
        view.label.getParent().layout(true);
    }

    public static void displayCovDetailedResult(String binaryPath, String gcdaFile) {
        try {
            CovManager cvrgeMnger = new CovManager(binaryPath);
            LinkedList<String> gcdaPaths = new LinkedList<String>();
            gcdaPaths.add(gcdaFile);
            cvrgeMnger.processCovFiles(gcdaPaths);
            cvrgeMnger.fillGcovView();
            for (SourceFile sf : cvrgeMnger.getSourceMap().values()) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile binary = root.getFileForLocation((IPath)new Path(binaryPath));
                IProject project = null;
                if (binary != null) {
                    project = binary.getProject();
                }
                OpenSourceFileAction.sharedInstance.openAnnotatedSourceFile(project, binary, sf, 0);
            }
        }
        catch (Exception _) {
            final String message = "An error has occured when parsing the coverage data files :\n" + _.getMessage();
            Status status = new Status(4, "org.eclipse.linuxtools.gcov", 4, message, (Throwable)_);
            Activator.getDefault().getLog().log((IStatus)status);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell s = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                    MessageDialog.openError((Shell)s, (String)"Gcov Parsing Error", (String)message);
                }
            });
            return;
        }
    }

    public static CovView displayCovResults(String binaryPath) {
        try {
            CovManager cvrgeMnger = new CovManager(binaryPath);
            List<String> gcdaPaths = cvrgeMnger.getGCDALocations();
            cvrgeMnger.processCovFiles(gcdaPaths);
            cvrgeMnger.fillGcovView();
            CovView cvrgeView = CovView.displayCovResults(cvrgeMnger);
            return cvrgeView;
        }
        catch (Exception _) {
            final String message = "An error has occured when parsing the coverage data files :\n" + _.getMessage();
            Status status = new Status(4, "org.eclipse.linuxtools.gcov", 4, message, (Throwable)_);
            Activator.getDefault().getLog().log((IStatus)status);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell s = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                    MessageDialog.openError((Shell)s, (String)"Gcov Parsing Error", (String)message);
                }
            });
            return null;
        }
    }

    public static CovView displayCovResults(CovManager cvrgeMnger) throws PartInitException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        CovView cvrgeView = (CovView)page.showView("org.eclipse.linuxtools.gcov.view");
        CovView.setCovViewTitle(cvrgeView, Integer.toString((int)cvrgeMnger.getNbrPgmRuns()), cvrgeMnger.getBinaryPath());
        cvrgeView.setInput(cvrgeMnger);
        CovViewer stviewer = (CovViewer)cvrgeView.getSTViewer();
        stviewer.getViewer().expandToLevel(2);
        return cvrgeView;
    }

    protected IAction createExportToCSVAction() {
        STExportToCSVAction action = new STExportToCSVAction(this.getSTViewer()){

            public void run() {
                Object o = CovView.this.getSTViewer().getInput();
                if (o instanceof CovManager) {
                    this.getExporter().setFilePath(CovView.this.getDefaultCSVPath());
                }
                super.run();
            }
        };
        return action;
    }

    public String getDefaultCSVPath() {
        return this.defaultCSVPath;
    }

    public void setDefaultCSVPath(String defaultCSVPath) {
        this.defaultCSVPath = defaultCSVPath;
    }
}

