/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.gprof.Activator;
import org.eclipse.linuxtools.gprof.dialog.OpenGmonDialog;
import org.eclipse.linuxtools.gprof.view.GmonView;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.PlatformUI;

public class OpenGmonAction
implements IEditorLauncher {
    private static int instanceNum = 0;

    public void open(IPath file) {
        String s = this.getDefaultBinary(file);
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        OpenGmonDialog d = new OpenGmonDialog(shell, s, file);
        if (d.open() != 0) {
            return;
        }
        String binaryPath = d.getBinaryFile();
        GmonView.displayGprofView(binaryPath, file.toOSString(), Integer.toString(instanceNum++));
    }

    private String getDefaultBinary(IPath file) {
        block9: {
            File gmonFile = file.toFile();
            File parent = gmonFile.getParentFile();
            File info = new File(parent, "AnalysisInfo.txt");
            IProject project = null;
            IFile ifile = null;
            try {
                ICProject cproject;
                if (info.exists()) {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(info.toString()));
                    while ((line = br.readLine()) != null) {
                        String[] tab = line.split("=");
                        String name = "";
                        String value = "";
                        if (tab.length <= 1) continue;
                        name = tab[0];
                        value = tab[1].trim();
                        if (name.equals("Project Name ")) {
                            project = ResourcesPlugin.getWorkspace().getRoot().getProject(value);
                            continue;
                        }
                        if (!name.equals("Program Name ") || project == null) continue;
                        ifile = project.getFile(value);
                        br.close();
                        if (!ifile.exists()) continue;
                        return ifile.getLocation().toString();
                    }
                    break block9;
                }
                IFile c = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
                if (c == null || (project = c.getProject()) == null || !project.exists() || (cproject = CoreModel.getDefault().create(project)) == null) break block9;
                try {
                    IBinary[] b = cproject.getBinaryContainer().getBinaries();
                    if (b != null && b.length > 0 && b[0] != null) {
                        IResource r = b[0].getResource();
                        return r.getLocation().toOSString();
                    }
                }
                catch (CModelException cModelException) {}
            }
            catch (FileNotFoundException e) {
                Status status = new Status(2, "org.eclipse.linuxtools.gprof", 2, e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.linuxtools.gprof", 4, e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return "";
    }
}

