/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.parser;

import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.linuxtools.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.gprof.symbolManager.CallGraphArc;
import org.eclipse.linuxtools.gprof.symbolManager.CallGraphNode;
import org.eclipse.linuxtools.gprof.view.histogram.HistRoot;

public class CallGraphDecoder {
    protected final GmonDecoder decoder;
    private final Map<IBinaryParser.ISymbol, CallGraphNode> nodes = new HashMap<IBinaryParser.ISymbol, CallGraphNode>();

    public CallGraphDecoder(GmonDecoder decoder) {
        this.decoder = decoder;
    }

    public void decodeCallGraphRecord(DataInput stream) throws IOException {
        int _from_pc = stream.readInt();
        int _self_pc = stream.readInt();
        long from_pc = (long)_from_pc & 0xFFFFFFFFL;
        long self_pc = (long)_self_pc & 0xFFFFFFFFL;
        int count = stream.readInt();
        IBinaryParser.IBinaryObject program = this.decoder.getProgram();
        IAddressFactory addressFactory = program.getAddressFactory();
        IAddress parentAddress = addressFactory.createAddress(Long.toString(from_pc));
        IBinaryParser.ISymbol parentSymbol = program.getSymbol(parentAddress);
        IAddress childAddress = addressFactory.createAddress(Long.toString(self_pc));
        IBinaryParser.ISymbol childSymbol = program.getSymbol(childAddress);
        if (childSymbol == null || parentSymbol == null) {
            return;
        }
        this.addCallArc(parentSymbol, parentAddress, childSymbol, count);
    }

    public void addCallArc(IBinaryParser.ISymbol parent, IAddress parentAddress, IBinaryParser.ISymbol child, int count) {
        CallGraphArc arc;
        CallGraphNode parentNode = this.nodes.get(parent);
        CallGraphNode childNode = this.nodes.get(child);
        if (parentNode == null) {
            parentNode = new CallGraphNode(parent);
            this.nodes.put(parent, parentNode);
        }
        if (childNode == null) {
            childNode = new CallGraphNode(child);
            this.nodes.put(child, childNode);
        }
        if ((arc = parentNode.getOutputArc(childNode)) == null) {
            arc = new CallGraphArc(parentNode, parentAddress, childNode, count, this.decoder.getProgram());
            parentNode.getChildren().add(arc);
            childNode.getParents().add(arc);
        } else {
            arc.setCount(arc.getCount() + count);
        }
    }

    public Map<IBinaryParser.ISymbol, CallGraphNode> getNodes() {
        return this.nodes;
    }

    void populate(HistRoot rootNode) {
        for (CallGraphNode callGraphNode : this.getNodes().values()) {
            rootNode.addCallGraphNode(callGraphNode);
        }
    }
}

