/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.parser;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.gprof.parser.CallGraphDecoder;
import org.eclipse.linuxtools.gprof.parser.CallGraphDecoder_64;
import org.eclipse.linuxtools.gprof.parser.HistogramDecoder;
import org.eclipse.linuxtools.gprof.parser.HistogramDecoder_64;
import org.eclipse.linuxtools.gprof.utils.LEDataInputStream;
import org.eclipse.linuxtools.gprof.view.histogram.HistRoot;

public class GmonDecoder {
    public static final int VPF_GMON_RECORD_TYPE_HISTOGRAM = 0;
    public static final int VPF_GMON_RECORD_TYPE_CALLGRAPH = 1;
    public static final int VPF_GMON_RECORD_TYPE_UNKNOWN = -1;
    private String cookie;
    private int gmon_version;
    private byte[] spare;
    private final IBinaryParser.IBinaryObject program;
    private HistogramDecoder histo;
    private CallGraphDecoder callGraph;
    private final PrintStream ps;
    private final HistRoot rootNode = new HistRoot(this);
    private String file;
    private int tag = -1;
    private final HashMap<IBinaryParser.ISymbol, String> filenames = new HashMap();
    private boolean shouldDump = false;

    public GmonDecoder(IBinaryParser.IBinaryObject program) {
        this(program, null);
    }

    public GmonDecoder(IBinaryParser.IBinaryObject program, PrintStream ps) {
        this.program = program;
        this.ps = ps;
        program.getBinaryParser().getFormat();
        if ("x86_64".equals(program.getCPU())) {
            this.histo = new HistogramDecoder_64(this);
            this.callGraph = new CallGraphDecoder_64(this);
        } else {
            this.histo = new HistogramDecoder(this);
            this.callGraph = new CallGraphDecoder(this);
        }
    }

    public void read(String file) throws IOException {
        this.file = file;
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        if (this.program.isLittleEndian()) {
            LEDataInputStream s = new LEDataInputStream(stream);
            this.read(s);
        } else {
            this.read(stream);
        }
    }

    public void read(DataInput stream) throws IOException {
        this.readHeader(stream);
        this.ReadGmonContent(stream);
        ((FilterInputStream)((Object)stream)).close();
    }

    public void readHeader(DataInput stream) throws IOException {
        byte[] _cookie = new byte[4];
        stream.readFully(_cookie);
        this.cookie = new String(_cookie);
        if (!"gmon".equals(this.cookie)) {
            throw new IOException("Invalid gmon file");
        }
        this.gmon_version = stream.readInt();
        this.spare = new byte[12];
        stream.readFully(this.spare);
    }

    public void ReadGmonContent(DataInput stream) throws IOException {
        while (true) {
            this.tag = -1;
            try {
                this.tag = stream.readByte();
            }
            catch (EOFException eOFException) {
                break;
            }
            switch (this.tag) {
                case 0: {
                    this.histo.decodeHeader(stream);
                    this.histo.decodeHistRecord(stream);
                    break;
                }
                case 1: {
                    this.callGraph.decodeCallGraphRecord(stream);
                    break;
                }
                default: {
                    throw new IOException("Error while reading GMON content : Found bad tag (file corrupted?) ");
                }
            }
            if (!this.shouldDump) continue;
            this.dumpGmonResult(this.ps == null ? System.out : this.ps);
        }
        this.callGraph.populate(this.rootNode);
        this.histo.AssignSamplesSymbol();
    }

    public void dumpGmonResult(PrintStream ps) throws FileNotFoundException {
        ps.println("-- gmon Results --");
        ps.println("cookie " + this.cookie);
        ps.println("gmon_version " + this.gmon_version);
        ps.println("tag " + this.tag);
        switch (this.tag) {
            case 0: {
                this.histo.printHistHeader(ps);
                this.histo.printHistRecords(ps);
                break;
            }
        }
    }

    public HistogramDecoder getHistogramDecoder() {
        return this.histo;
    }

    public CallGraphDecoder getCallGraphDecoder() {
        return this.callGraph;
    }

    public IBinaryParser.IBinaryObject getProgram() {
        return this.program;
    }

    public HistRoot getRootNode() {
        return this.rootNode;
    }

    public int getGmonVersion() {
        return this.gmon_version;
    }

    public String getGmonFile() {
        return this.file;
    }

    public String getFileName(IBinaryParser.ISymbol s) {
        String ret = this.filenames.get(s);
        if (ret == null) {
            ret = STSymbolManager.sharedInstance.getFilename(s);
            if (ret == null) {
                ret = "??";
            }
            this.filenames.put(s, ret);
        }
        return ret;
    }

    public boolean isICache() {
        Path p = new Path(this.file);
        String s = p.lastSegment();
        return s.endsWith("ICACHE");
    }

    public boolean isDCache() {
        Path p = new Path(this.file);
        String s = p.lastSegment();
        return s.endsWith("DCACHE");
    }

    public void setShouldDump(boolean shouldDump) {
        this.shouldDump = shouldDump;
    }
}

