/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.parser;

import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.linuxtools.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.gprof.symbolManager.Bucket;
import org.eclipse.linuxtools.gprof.view.histogram.HistRoot;

public class HistogramDecoder {
    protected final GmonDecoder decoder;
    protected long lowpc;
    protected long highpc;
    protected int prof_rate;
    protected String dimen;
    protected char dimen_abbrev;
    protected boolean initialized = false;
    protected int[] hist_sample;
    protected double total_time;
    protected long bucketSize;

    public HistogramDecoder(GmonDecoder decoder) {
        this.decoder = decoder;
    }

    public boolean hasValues() {
        return this.hist_sample != null && this.hist_sample.length > 0;
    }

    protected void decodeAll(DataInput stream) throws IOException {
        this.decodeHeader(stream);
        this.decodeHistRecord(stream);
        this.AssignSamplesSymbol();
    }

    public void decodeHeader(DataInput stream) throws IOException {
        int _lowpc = stream.readInt();
        long lowpc = (long)_lowpc & 0xFFFFFFFFL;
        int _highpc = stream.readInt();
        long highpc = (long)_highpc & 0xFFFFFFFFL;
        int hist_num_bins = stream.readInt();
        int prof_rate = stream.readInt();
        byte[] bytes = new byte[15];
        stream.readFully(bytes);
        byte b = stream.readByte();
        if (!this.isCompatible(lowpc, highpc, prof_rate, hist_num_bins)) {
            throw new RuntimeException("Histogram header's incompatibility among gmon files");
        }
        this.lowpc = lowpc;
        this.highpc = highpc;
        this.prof_rate = prof_rate;
        this.hist_sample = new int[hist_num_bins];
        this.dimen = new String(bytes);
        this.dimen_abbrev = (char)b;
        long temp = highpc - lowpc;
        this.bucketSize = Math.round((double)temp / (double)hist_num_bins);
    }

    public boolean isCompatible(long lowpc, long highpc, int profrate, int sample_count) {
        if (!this.initialized) {
            return true;
        }
        return this.lowpc == lowpc && this.highpc == highpc && this.prof_rate == profrate && this.hist_sample.length == sample_count;
    }

    public void decodeHistRecord(DataInput stream) throws IOException {
        int i = 0;
        while (i < this.hist_sample.length) {
            short _rv = stream.readShort();
            int hist_size = _rv & 0xFFFF;
            int n = i++;
            this.hist_sample[n] = this.hist_sample[n] + hist_size;
        }
    }

    public void printHistHeader(PrintStream ps) {
        ps.println(" \nHistogram Header : \n");
        ps.print("  Base pc address of sample buffer = 0x");
        ps.println(Long.toHexString(this.lowpc));
        ps.print("  Max pc address of sampled buffer = 0x");
        ps.println(Long.toHexString(this.highpc));
        ps.print("  Number of histogram samples      = ");
        ps.println(this.hist_sample.length);
        ps.print("  Profiling clock rate             = ");
        ps.println(this.prof_rate);
        ps.print("  Physical dimension abreviation : 's' for \"seconds\"  'm' for \"milliseconds\" = ");
        ps.println(this.dimen_abbrev);
    }

    public void printHistRecords(PrintStream ps) {
        ps.println();
        ps.println(" ==  HISTOGRAM RECORDS  == ");
        ps.println(" ========================= ");
        this.printHistHeader(ps);
    }

    public void AssignSamplesSymbol() {
        if (this.hist_sample == null || this.hist_sample.length == 0) {
            return;
        }
        IBinaryParser.ISymbol[] symblist = this.decoder.getProgram().getSymbols();
        int j = 1;
        int i = 0;
        while (i < this.hist_sample.length) {
            int ccnt = this.hist_sample[i];
            if (ccnt != 0) {
                long pcl = this.lowpc + this.bucketSize * (long)i;
                long pch = pcl + this.bucketSize;
                this.total_time += (double)ccnt;
                long svalue1 = symblist[j - 1].getAddress().getValue().longValue();
                --j;
                while (j < symblist.length - 1) {
                    long start_addr;
                    long end_addr;
                    long overlap;
                    long svalue0 = svalue1;
                    svalue1 = symblist[j + 1].getAddress().getValue().longValue();
                    if (pch < svalue0) break;
                    if (pcl < svalue1 && (overlap = (end_addr = pch < svalue1 ? pch : svalue1) - (start_addr = pcl > svalue0 ? pcl : svalue0)) > 0L) {
                        int time = (int)(overlap * (long)ccnt / this.bucketSize);
                        Bucket bck = new Bucket(start_addr, end_addr, time);
                        this.addBucket(bck, symblist[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addBucket(Bucket b, IBinaryParser.ISymbol s) {
        HistRoot root = this.decoder.getRootNode();
        root.addBucket(b, s, this.decoder.getProgram());
    }

    public int getProf_rate() {
        return this.prof_rate;
    }

    public char getTimeDimension() {
        return this.dimen_abbrev;
    }

    public long getBucketSize() {
        return this.bucketSize;
    }
}

