/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.parser;

import java.io.DataInput;
import java.io.IOException;
import org.eclipse.linuxtools.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.gprof.parser.HistogramDecoder;

public class HistogramDecoder_64
extends HistogramDecoder {
    public HistogramDecoder_64(GmonDecoder decoder) {
        super(decoder);
    }

    @Override
    public void decodeHeader(DataInput stream) throws IOException {
        long lowpc = stream.readLong();
        long highpc = stream.readLong();
        int hist_num_bins = stream.readInt();
        int prof_rate = stream.readInt();
        byte[] bytes = new byte[15];
        stream.readFully(bytes);
        byte b = stream.readByte();
        if (!this.isCompatible(lowpc, highpc, prof_rate, hist_num_bins)) {
            throw new RuntimeException("Histogram header's incompatibility among gmon files");
        }
        this.lowpc = lowpc;
        this.highpc = highpc;
        this.prof_rate = prof_rate;
        this.hist_sample = new int[hist_num_bins];
        this.dimen = new String(bytes);
        this.dimen_abbrev = (char)b;
        long temp = highpc - lowpc;
        this.bucketSize = Math.round((double)temp / (double)hist_num_bins);
    }
}

