/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.view.fields;

import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTDataViewersField;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.dataviewers.charts.provider.IChartField;
import org.eclipse.linuxtools.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.gprof.parser.HistogramDecoder;
import org.eclipse.linuxtools.gprof.view.GmonView;
import org.eclipse.linuxtools.gprof.view.histogram.HistFile;
import org.eclipse.linuxtools.gprof.view.histogram.HistFunction;
import org.eclipse.linuxtools.gprof.view.histogram.HistLine;
import org.eclipse.linuxtools.gprof.view.histogram.HistRoot;
import org.eclipse.linuxtools.gprof.view.histogram.TreeElement;
import org.eclipse.swt.graphics.Color;

public class SampleProfField
extends AbstractSTDataViewersField
implements IChartField {
    private boolean samples = true;
    protected final AbstractSTTreeViewer viewer;
    protected static final double UNINITIALIZED = 0.0;

    public SampleProfField(AbstractSTTreeViewer viewer) {
        this.viewer = viewer;
    }

    public int compare(Object obj1, Object obj2) {
        TreeElement e1 = (TreeElement)obj1;
        TreeElement e2 = (TreeElement)obj2;
        int s1 = e1.getSamples();
        int s2 = e2.getSamples();
        return s1 - s2;
    }

    public String getColumnHeaderText() {
        String prefix = "";
        Object o = this.viewer.getInput();
        if (o instanceof GmonDecoder) {
            GmonDecoder decoder = (GmonDecoder)o;
            if (decoder.isICache()) {
                prefix = "ICACHE ";
            } else if (decoder.isDCache()) {
                prefix = "DCACHE ";
            }
        }
        if (this.samples) {
            return String.valueOf(prefix) + "Samples";
        }
        return String.valueOf(prefix) + "Time";
    }

    public String getColumnHeaderTooltip() {
        Object o = this.viewer.getInput();
        if (o instanceof GmonDecoder) {
            GmonDecoder decoder = (GmonDecoder)o;
            if (decoder.isICache()) {
                return "Time spent by function accessing instruction cache";
            }
            if (decoder.isDCache()) {
                return "Time spent by function accessing data cache";
            }
        }
        return null;
    }

    public String getValue(Object obj) {
        TreeElement e = (TreeElement)obj;
        int i = e.getSamples();
        if (i == -1) {
            return "";
        }
        if (this.samples) {
            return String.valueOf(i);
        }
        double prof_rate = this.getProfRate();
        if (prof_rate == 0.0) {
            return "?";
        }
        return SampleProfField.getValue(i, prof_rate);
    }

    public static String getValue(double i, double prof_rate) {
        long timeInNs = (long)(i / prof_rate);
        long ns = timeInNs % 1000L;
        long timeInUs = timeInNs / 1000L;
        if (timeInUs == 0L) {
            return String.valueOf(ns) + "ns";
        }
        long us = timeInUs % 1000L;
        long timeInMs = timeInUs / 1000L;
        if (timeInMs == 0L) {
            return String.valueOf(us) + "." + ns + "us";
        }
        long ms = timeInMs % 1000L;
        long timeInS = timeInMs / 1000L;
        if (timeInS == 0L) {
            return String.valueOf(ms) + "." + us + "ms";
        }
        long s = timeInS % 60L;
        long timeInMin = timeInS / 60L;
        if (timeInMin == 0L) {
            return String.valueOf(s) + "." + ms + "s";
        }
        long min = timeInMin % 60L;
        long timeInHour = timeInMin / 60L;
        if (timeInHour == 0L) {
            return String.valueOf(min) + "min " + s + "s";
        }
        return String.valueOf(timeInHour) + "h " + min + "min";
    }

    protected double getProfRate() {
        double prof_rate = 0.0;
        Object o = this.viewer.getViewer().getInput();
        if (o instanceof GmonDecoder) {
            GmonDecoder decoder = (GmonDecoder)o;
            HistogramDecoder histo = decoder.getHistogramDecoder();
            prof_rate = histo.getProf_rate();
            char tUnit = histo.getTimeDimension();
            switch (tUnit) {
                case 's': {
                    prof_rate /= 1.0E9;
                    break;
                }
                case 'm': {
                    prof_rate /= 1000000.0;
                    break;
                }
                case 'u': {
                    prof_rate /= 1000.0;
                }
            }
        }
        return prof_rate;
    }

    public Color getBackground(Object element) {
        return GmonView.getBackground(element);
    }

    public String getToolTipText(Object element) {
        String suffix = "";
        Object o = this.viewer.getInput();
        if (o instanceof GmonDecoder) {
            GmonDecoder decoder = (GmonDecoder)o;
            if (decoder.isICache()) {
                suffix = " in instruction cache";
            } else if (decoder.isDCache()) {
                suffix = " in data cache";
            }
        }
        if (element instanceof HistRoot) {
            return "total time spent in the program" + suffix;
        }
        if (element instanceof HistFunction) {
            return "time spent in this function" + suffix;
        }
        if (element instanceof HistFile) {
            return "time spent in this file" + suffix;
        }
        if (element instanceof HistLine) {
            return "time spent at this location" + suffix;
        }
        return null;
    }

    public void toggle() {
        this.samples = !this.samples;
    }

    public Number getNumber(Object obj) {
        TreeElement e = (TreeElement)obj;
        int i = e.getSamples();
        if (i == -1) {
            return 0L;
        }
        return i;
    }
}

