/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.model.trange;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.lttng.state.StateStrings;
import org.eclipse.linuxtools.lttng.ui.model.trange.ITimeRangeComponent;
import org.eclipse.linuxtools.lttng.ui.model.trange.Messages;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeComponent;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeComposite;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEvent;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEventProcess;
import org.eclipse.linuxtools.lttng.ui.views.common.ParamsUpdater;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeAnalysisProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;

public class TimeRangeViewerProvider
extends TmfTimeAnalysisProvider {
    Map<String, TmfTimeAnalysisProvider.StateColor> procStateToColor = new HashMap<String, TmfTimeAnalysisProvider.StateColor>(16);
    Map<String, TmfTimeAnalysisProvider.StateColor> bdevStateToColor = new HashMap<String, TmfTimeAnalysisProvider.StateColor>(4);
    Map<String, TmfTimeAnalysisProvider.StateColor> softIrqStateToColor = new HashMap<String, TmfTimeAnalysisProvider.StateColor>(4);
    Map<String, TmfTimeAnalysisProvider.StateColor> trapStateToColor = new HashMap<String, TmfTimeAnalysisProvider.StateColor>(4);
    Map<String, TmfTimeAnalysisProvider.StateColor> irqStateToColor = new HashMap<String, TmfTimeAnalysisProvider.StateColor>(4);
    Map<String, TmfTimeAnalysisProvider.StateColor> cpuStateToColor = new HashMap<String, TmfTimeAnalysisProvider.StateColor>(8);
    private final ParamsUpdater fviewParameters;

    public TimeRangeViewerProvider(ParamsUpdater paramsUpdater) {
        this.fillProcessStateToColor();
        this.fillBdevStateToColor();
        this.fillSoftIRQStateToColor();
        this.fillTrapStateToColor();
        this.fillIrqStateToColor();
        this.fillCpuStateToColor();
        this.fviewParameters = paramsUpdater;
    }

    public TmfTimeAnalysisProvider.StateColor getEventColor(ITimeEvent event) {
        TmfTimeAnalysisProvider.StateColor retColor = null;
        if (event instanceof TimeRangeEvent) {
            TimeRangeEvent devent = (TimeRangeEvent)event;
            String stateMode = devent.getStateMode();
            switch (devent.getEventType()) {
                case PROCESS_MODE: {
                    retColor = this.procStateToColor.get(stateMode);
                    break;
                }
                case BDEV_MODE: {
                    retColor = this.bdevStateToColor.get(stateMode);
                    break;
                }
                case IRQ_MODE: {
                    retColor = this.irqStateToColor.get(stateMode);
                    break;
                }
                case SOFT_IRQ_MODE: {
                    retColor = this.softIrqStateToColor.get(stateMode);
                    break;
                }
                case CPU_MODE: {
                    retColor = this.cpuStateToColor.get(stateMode);
                    break;
                }
                case TRAP_MODE: {
                    retColor = this.trapStateToColor.get(stateMode);
                }
            }
        }
        if (retColor == null) {
            return TmfTimeAnalysisProvider.StateColor.MAGENTA3;
        }
        return retColor;
    }

    public String getStateName(TmfTimeAnalysisProvider.StateColor color) {
        return "Not mapped";
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent revent) {
        HashMap<String, String> toolTipEventMsgs = new HashMap<String, String>();
        if (revent instanceof TimeRangeComponent) {
            long eventEnd;
            ITimeRangeComponent parent = ((TimeRangeComponent)revent).getEventParent();
            String extraInfo = "\n" + Messages.TimeRangeViewerProvider_BadRangeExtraInfo;
            long eventStart = revent.getTime();
            if (eventStart < this.fviewParameters.getStartTime()) {
                toolTipEventMsgs.put(Messages.TimeRangeViewerProvider_StartTime, String.valueOf(Messages.TimeRangeViewerProvider_UndefinedStartTime) + extraInfo);
                extraInfo = "";
            }
            if ((eventEnd = revent.getTime() + revent.getDuration()) > this.fviewParameters.getEndTime()) {
                toolTipEventMsgs.put(Messages.TimeRangeViewerProvider_EndTime, String.valueOf(Messages.TimeRangeViewerProvider_UndefinedEndTime) + extraInfo);
            }
            if (parent != null && parent instanceof TimeRangeEventProcess) {
                TimeRangeEventProcess localProcess = (TimeRangeEventProcess)parent;
                toolTipEventMsgs.put(Messages.TimeRangeViewerProvider_ProcessType, localProcess.getProcessType());
            }
        }
        return toolTipEventMsgs;
    }

    public String getEventName(ITimeEvent event, boolean upper, boolean extInfo) {
        String name = null;
        if (event instanceof TimeRangeEvent) {
            TimeRangeEvent devent = (TimeRangeEvent)event;
            StringBuilder sb = new StringBuilder(devent.getStateMode());
            name = sb.toString();
        }
        if (name == null) {
            return "Unknown";
        }
        return name;
    }

    public String getTraceClassName(ITmfTimeAnalysisEntry trace) {
        String name = "";
        if (trace instanceof TimeRangeComposite) {
            TimeRangeComposite dTrace = (TimeRangeComposite)trace;
            name = dTrace.getClassName();
        }
        return name;
    }

    private void fillCpuStateToColor() {
        this.cpuStateToColor.put(StateStrings.CpuMode.LTTV_CPU_UNKNOWN.getInName(), TmfTimeAnalysisProvider.StateColor.BLACK);
        this.cpuStateToColor.put(StateStrings.CpuMode.LTTV_CPU_IDLE.getInName(), TmfTimeAnalysisProvider.StateColor.GRAY);
        this.cpuStateToColor.put(StateStrings.CpuMode.LTTV_CPU_BUSY.getInName(), TmfTimeAnalysisProvider.StateColor.LIGHT_BLUE);
        this.cpuStateToColor.put(StateStrings.CpuMode.LTTV_CPU_IRQ.getInName(), TmfTimeAnalysisProvider.StateColor.ORANGE);
        this.cpuStateToColor.put(StateStrings.CpuMode.LTTV_CPU_SOFT_IRQ.getInName(), TmfTimeAnalysisProvider.StateColor.PURPLE1);
        this.cpuStateToColor.put(StateStrings.CpuMode.LTTV_CPU_TRAP.getInName(), TmfTimeAnalysisProvider.StateColor.GOLD);
    }

    private void fillIrqStateToColor() {
        this.irqStateToColor.put(StateStrings.IRQMode.LTTV_IRQ_UNKNOWN.getInName(), TmfTimeAnalysisProvider.StateColor.BLACK);
        this.irqStateToColor.put(StateStrings.IRQMode.LTTV_IRQ_IDLE.getInName(), TmfTimeAnalysisProvider.StateColor.GRAY);
        this.irqStateToColor.put(StateStrings.IRQMode.LTTV_IRQ_BUSY.getInName(), TmfTimeAnalysisProvider.StateColor.ORANGE);
    }

    private void fillTrapStateToColor() {
        this.trapStateToColor.put(StateStrings.TrapMode.LTTV_TRAP_UNKNOWN.getInName(), TmfTimeAnalysisProvider.StateColor.BLACK);
        this.trapStateToColor.put(StateStrings.TrapMode.LTTV_TRAP_IDLE.getInName(), TmfTimeAnalysisProvider.StateColor.BLACK);
        this.trapStateToColor.put(StateStrings.TrapMode.LTTV_TRAP_BUSY.getInName(), TmfTimeAnalysisProvider.StateColor.GOLD);
    }

    private void fillSoftIRQStateToColor() {
        this.softIrqStateToColor.put(StateStrings.SoftIRQMode.LTTV_SOFT_IRQ_UNKNOWN.getInName(), TmfTimeAnalysisProvider.StateColor.BLACK);
        this.softIrqStateToColor.put(StateStrings.SoftIRQMode.LTTV_SOFT_IRQ_IDLE.getInName(), TmfTimeAnalysisProvider.StateColor.BLACK);
        this.softIrqStateToColor.put(StateStrings.SoftIRQMode.LTTV_SOFT_IRQ_PENDING.getInName(), TmfTimeAnalysisProvider.StateColor.PINK1);
        this.softIrqStateToColor.put(StateStrings.SoftIRQMode.LTTV_SOFT_IRQ_BUSY.getInName(), TmfTimeAnalysisProvider.StateColor.PURPLE1);
    }

    private void fillBdevStateToColor() {
        this.softIrqStateToColor.put(StateStrings.BdevMode.LTTV_BDEV_UNKNOWN.getInName(), TmfTimeAnalysisProvider.StateColor.BLACK);
        this.softIrqStateToColor.put(StateStrings.BdevMode.LTTV_BDEV_IDLE.getInName(), TmfTimeAnalysisProvider.StateColor.BLACK);
        this.softIrqStateToColor.put(StateStrings.BdevMode.LTTV_BDEV_BUSY_READING.getInName(), TmfTimeAnalysisProvider.StateColor.DARK_BLUE);
        this.softIrqStateToColor.put(StateStrings.BdevMode.LTTV_BDEV_BUSY_WRITING.getInName(), TmfTimeAnalysisProvider.StateColor.RED);
    }

    private void fillProcessStateToColor() {
        this.procStateToColor.put(StateStrings.ProcessStatus.LTTV_STATE_UNNAMED.getInName(), TmfTimeAnalysisProvider.StateColor.GRAY);
        this.procStateToColor.put(StateStrings.ProcessStatus.LTTV_STATE_DEAD.getInName(), TmfTimeAnalysisProvider.StateColor.BLACK);
        this.procStateToColor.put(StateStrings.ProcessStatus.LTTV_STATE_WAIT_FORK.getInName(), TmfTimeAnalysisProvider.StateColor.DARK_GREEN);
        this.procStateToColor.put(StateStrings.ProcessStatus.LTTV_STATE_WAIT_CPU.getInName(), TmfTimeAnalysisProvider.StateColor.DARK_YELLOW);
        this.procStateToColor.put(StateStrings.ProcessStatus.LTTV_STATE_EXIT.getInName(), TmfTimeAnalysisProvider.StateColor.MAGENTA3);
        this.procStateToColor.put(StateStrings.ProcessStatus.LTTV_STATE_ZOMBIE.getInName(), TmfTimeAnalysisProvider.StateColor.PURPLE1);
        this.procStateToColor.put(StateStrings.ProcessStatus.LTTV_STATE_WAIT.getInName(), TmfTimeAnalysisProvider.StateColor.RED);
        this.procStateToColor.put(StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN.getInName(), TmfTimeAnalysisProvider.StateColor.BLACK);
        this.procStateToColor.put(StateStrings.ExecutionMode.LTTV_STATE_USER_MODE.getInName(), TmfTimeAnalysisProvider.StateColor.GREEN);
        this.procStateToColor.put(StateStrings.ExecutionMode.LTTV_STATE_SYSCALL.getInName(), TmfTimeAnalysisProvider.StateColor.DARK_BLUE);
        this.procStateToColor.put(StateStrings.ExecutionMode.LTTV_STATE_TRAP.getInName(), TmfTimeAnalysisProvider.StateColor.GOLD);
        this.procStateToColor.put(StateStrings.ExecutionMode.LTTV_STATE_IRQ.getInName(), TmfTimeAnalysisProvider.StateColor.ORANGE);
        this.procStateToColor.put(StateStrings.ExecutionMode.LTTV_STATE_SOFT_IRQ.getInName(), TmfTimeAnalysisProvider.StateColor.PINK1);
    }
}

