/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.DelayedMouseScroll;
import org.eclipse.linuxtools.lttng.ui.views.histogram.ParentHistogramCanvas;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;

public class HistogramCanvasMouseListener
implements MouseMoveListener,
MouseListener,
MouseWheelListener {
    private DelayedMouseScroll mouseScrollListener = null;
    private ParentHistogramCanvas parentCanvas = null;
    private int oldWindowXPositionCenter = 0;
    private boolean isWindowMoving = false;

    public HistogramCanvasMouseListener(ParentHistogramCanvas newCanvas) {
        this.parentCanvas = newCanvas;
    }

    public void mouseMove(MouseEvent event) {
        if (this.parentCanvas.getHistogramContent() != null && this.isWindowMoving) {
            this.parentCanvas.setWindowCenterPosition(event.x);
        }
    }

    public void mouseDown(MouseEvent event) {
        if (this.parentCanvas.getHistogramContent() != null && event.button == 1) {
            this.isWindowMoving = true;
            this.oldWindowXPositionCenter = this.parentCanvas.getCurrentWindow().getWindowXPositionCenter();
            this.parentCanvas.setWindowCenterPosition(event.x);
        }
    }

    public void mouseUp(MouseEvent event) {
        if (this.parentCanvas.getHistogramContent() != null && event.button == 1) {
            this.isWindowMoving = false;
            if (this.oldWindowXPositionCenter != this.parentCanvas.getCurrentWindow().getWindowXPositionCenter()) {
                this.parentCanvas.notifyParentSelectionWindowChangedAsynchronously();
            }
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseScrolled(MouseEvent event) {
        if (this.mouseScrollListener == null) {
            this.mouseScrollListener = new DelayedMouseScroll(this, 1000L, 100L);
            this.mouseScrollListener.start();
        }
        if (event.count > 0) {
            this.mouseScrollListener.incrementMouseScroll();
        } else {
            this.mouseScrollListener.decrementMouseScroll();
        }
    }

    public long receiveMouseScrollCount(int nbMouseScroll) {
        double ajustedTime = 0.0;
        long selectedWindowSize = this.parentCanvas.getSelectedWindowSize();
        if (nbMouseScroll < 0) {
            ajustedTime = (double)selectedWindowSize * 0.1;
            ajustedTime *= (double)Math.abs(nbMouseScroll);
            ajustedTime = (double)selectedWindowSize + ajustedTime;
        } else if (selectedWindowSize > 2L) {
            ajustedTime = (double)selectedWindowSize * 0.1;
            ajustedTime *= (double)Math.abs(nbMouseScroll);
            ajustedTime = (double)selectedWindowSize - ajustedTime;
        }
        return (long)ajustedTime;
    }

    public void receiveMouseScrollCountWithNotification(int nbMouseScroll) {
        if (this.parentCanvas.getHistogramContent() != null) {
            this.mouseScrollListener = null;
            this.parentCanvas.resizeWindowByAbsoluteTime(this.receiveMouseScrollCount(nbMouseScroll));
        }
    }

    public void receiveMouseScrollCountWithoutNotification(int nbMouseScroll) {
        if (this.parentCanvas.getHistogramContent() != null) {
            this.parentCanvas.resizeWindowByAbsoluteTimeWithoutNotification(this.receiveMouseScrollCount(nbMouseScroll));
        }
    }
}

