/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;

public abstract class HistogramConstant {
    public static final int MAX_EVENTS_PER_READ = 1;
    public static final int REDRAW_EVERY_NB_EVENTS = 20000;
    public static final Boolean SKIP_EMPTY_INTERVALS_WHEN_CALCULATING_AVERAGE = true;
    public static final double DEFAULT_DIFFERENCE_TO_AVERAGE = 1000.0;
    public static final double ZOOM_IN_FACTOR = 0.1;
    public static final double ZOOM_OUT_FACTOR = 0.1;
    public static final long FULL_WAIT_MS_TIME_BETWEEN_MOUSE_SCROLL = 1000L;
    public static final long INTERVAL_WAIT_MS_TIME_BETWEEN_POLL = 100L;
    public static final int BASIC_DISPLACEMENT_FACTOR = 1;
    public static final double FAST_DISPLACEMENT_MULTIPLE = 10.0;
    public static final int EMPTY_BACKGROUND_COLOR = 1;
    public static final int SELECTED_EVENT_COLOR = 3;
    public static final int MINIMUM_WINDOW_WIDTH = 3;
    public static final int SELECTION_LINE_WIDTH = 1;
    public static final int SELECTION_CROSSHAIR_WIDTH = 1;

    public static String formatNanoSecondsTime(long nanosecTime) {
        String returnedTime = Long.toString(nanosecTime);
        if (returnedTime.length() > 9) {
            returnedTime = String.valueOf(returnedTime.substring(0, returnedTime.length() - 9)) + "." + returnedTime.substring(returnedTime.length() - 9);
        } else {
            int curSize = returnedTime.length();
            int l = 0;
            while (curSize + l < 9) {
                returnedTime = "0" + returnedTime;
                ++l;
            }
            returnedTime = "0." + returnedTime;
        }
        return returnedTime;
    }

    public static long convertStringToNanoseconds(String timeString) {
        long returnedNumber = 0L;
        try {
            timeString = timeString.replace(",", ".");
            int dotPosition = timeString.indexOf(".");
            if (dotPosition == 0) {
                timeString = "0" + timeString;
                dotPosition = 1;
            }
            if (dotPosition != -1) {
                int decimalNumber = timeString.length() - dotPosition - 1;
                if (decimalNumber <= 9) {
                    StringBuffer strBuffer = new StringBuffer(timeString);
                    int nbDec = decimalNumber;
                    while (nbDec < 9) {
                        strBuffer.append("0");
                        ++nbDec;
                    }
                    timeString = strBuffer.toString();
                } else {
                    timeString = timeString.substring(dotPosition, 9);
                }
            }
            double dblMaxTimerange = Double.parseDouble(timeString);
            returnedNumber = (long)(dblMaxTimerange * 1.0E9);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Warning : Could not convert string into nanoseconds (convertStringToLong)");
        }
        return returnedNumber;
    }

    public static int getTextSizeInControl(Composite parent, String text) {
        GC graphicContext = new GC((Drawable)parent);
        int textSize = 0;
        int pos = 0;
        while (pos < text.length()) {
            textSize += graphicContext.getAdvanceWidth(text.charAt(pos));
            ++pos;
        }
        return textSize += graphicContext.getAdvanceWidth(' ');
    }
}

