/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramCanvas;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramConstant;
import org.eclipse.linuxtools.tmf.event.TmfData;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.TmfEventRequest;

public class HistogramRequest
extends TmfEventRequest<LttngEvent> {
    private int lastInterval = 0;
    private long lastRangeTime = 0L;
    private long nbEventsInInterval = 0L;
    private int nbIntervalNotEmpty = 1;
    private int nbEventRead = 0;
    private int lastDrawPosition = 0;
    private HistogramCanvas parentCanvas = null;
    private boolean isCompleted = false;

    public HistogramRequest(TmfTimeRange range, int nbRequested, HistogramCanvas newParentCanvas, long timeInterval, ITmfDataRequest.ExecutionType execType) {
        super(LttngEvent.class, range, nbRequested, 1, execType);
        this.setIsCompleted(false);
        this.parentCanvas = newParentCanvas;
        this.parentCanvas.getHistogramContent().clearContentData();
        this.parentCanvas.getHistogramContent().resetTable(range.getStartTime().getValue(), range.getEndTime().getValue(), timeInterval);
        this.lastRangeTime = range.getStartTime().getValue();
        this.parentCanvas.notifyParentUpdatedInformationAsynchronously();
    }

    public void handleData(LttngEvent event) {
        super.handleData((TmfData)event);
        if (event != null) {
            if (event.getTimestamp().getValue() >= this.parentCanvas.getHistogramContent().getStartTime() && event.getTimestamp().getValue() <= this.parentCanvas.getHistogramContent().getEndTime()) {
                long distance = event.getTimestamp().getValue() - this.lastRangeTime;
                if (distance > this.parentCanvas.getHistogramContent().getElementsTimeInterval()) {
                    this.parentCanvas.getHistogramContent().getElementByIndex((int)this.lastInterval).intervalNbEvents = this.nbEventsInInterval;
                    this.lastRangeTime = event.getTimestamp().getValue();
                    this.lastInterval = (int)((this.lastRangeTime - this.parentCanvas.getHistogramContent().getStartTime()) / this.parentCanvas.getHistogramContent().getElementsTimeInterval());
                    if (this.lastInterval < 0) {
                        this.lastInterval = 0;
                    } else if (this.lastInterval >= this.parentCanvas.getHistogramContent().getNbElement()) {
                        this.lastInterval = this.parentCanvas.getHistogramContent().getNbElement() - 1;
                    }
                    this.parentCanvas.getHistogramContent().getElementByIndex((int)this.lastInterval).firstIntervalTimestamp = this.lastRangeTime;
                    this.parentCanvas.getHistogramContent().setReadyUpToPosition(this.lastInterval);
                    ++this.nbIntervalNotEmpty;
                    this.nbEventsInInterval = 1L;
                } else {
                    ++this.nbEventsInInterval;
                }
                if (this.nbEventsInInterval > this.parentCanvas.getHistogramContent().getHeighestEventCount()) {
                    this.parentCanvas.getHistogramContent().setHeighestEventCount(this.nbEventsInInterval);
                }
                ++this.nbEventRead;
                if (this.nbEventRead % 20000 == 0) {
                    this.redrawAsyncronously();
                }
            }
        } else {
            this.parentCanvas.getHistogramContent().getElementByIndex((int)this.lastInterval).intervalNbEvents = this.nbEventsInInterval;
            this.parentCanvas.getHistogramContent().setReadyUpToPosition(this.parentCanvas.getHistogramContent().getNbElement());
            if (this.nbEventsInInterval > 0L) {
                ++this.nbIntervalNotEmpty;
            }
        }
    }

    public void handleCompleted() {
        this.setIsCompleted(true);
        this.parentCanvas.notifyParentUpdatedInformationAsynchronously();
        this.redrawAsyncronously();
        super.handleCompleted();
    }

    public void handleCancel() {
        this.redrawAsyncronously();
    }

    public void updateEventsInfo() {
        int averageNumberOfEvents = 0;
        averageNumberOfEvents = HistogramConstant.SKIP_EMPTY_INTERVALS_WHEN_CALCULATING_AVERAGE != false ? (int)Math.ceil((double)this.nbEventRead / (double)this.nbIntervalNotEmpty) : (int)Math.ceil((double)this.nbEventRead / (double)this.parentCanvas.getHistogramContent().getNbElement());
        this.parentCanvas.getHistogramContent().setAverageNumberOfEvents(averageNumberOfEvents);
        double previousHeightFactor = this.parentCanvas.getHistogramContent().getHeightFactor();
        this.parentCanvas.getHistogramContent().recalculateHeightFactor();
        if (this.parentCanvas.getHistogramContent().getHeightFactor() != previousHeightFactor) {
            this.parentCanvas.getHistogramContent().recalculateEventHeight();
        } else {
            this.parentCanvas.getHistogramContent().recalculateEventHeightInInterval(this.lastDrawPosition, this.parentCanvas.getHistogramContent().getReadyUpToPosition());
        }
        this.lastDrawPosition = this.parentCanvas.getHistogramContent().getReadyUpToPosition();
    }

    public void redrawAsyncronously() {
        this.updateEventsInfo();
        this.parentCanvas.redrawAsynchronously();
    }

    public boolean getIsCompleted() {
        return this.isCompleted;
    }

    public void setIsCompleted(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }
}

