/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.model;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.linuxtools.lttng.ui.views.project.model.ILTTngProjectTreeNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngExperimentFolderNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngExperimentNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngTraceFolderNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngTraceNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class LTTngProjectLabelProvider
implements ILabelProvider {
    private final String fTraceIconFile = "icons/garland16.png";
    private final Image fOpenedProjectIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    private final Image fClosedProjectIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
    private final Image fFolderIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private final Image fTraceIcon = this.loadIcon("icons/garland16.png");
    private final Image fExperimentIcon = this.fFolderIcon;

    private Image loadIcon(String url) {
        LTTngUiPlugin plugin = LTTngUiPlugin.getDefault();
        Image icon = plugin.getImageRegistry().get(url);
        if (icon == null) {
            URL imageURL = plugin.getBundle().getEntry(url);
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)imageURL);
            icon = descriptor.createImage();
            plugin.getImageRegistry().put(url, icon);
        }
        return icon;
    }

    public Image getImage(Object element) {
        if (element instanceof LTTngProjectNode) {
            LTTngProjectNode project = (LTTngProjectNode)element;
            return project.isOpen() ? this.fOpenedProjectIcon : this.fClosedProjectIcon;
        }
        if (element instanceof LTTngTraceFolderNode) {
            return this.fFolderIcon;
        }
        if (element instanceof LTTngTraceNode) {
            return this.fTraceIcon;
        }
        if (element instanceof LTTngExperimentFolderNode) {
            return this.fFolderIcon;
        }
        if (element instanceof LTTngExperimentNode) {
            return this.fExperimentIcon;
        }
        return null;
    }

    public String getText(Object element) {
        ILTTngProjectTreeNode node = (ILTTngProjectTreeNode)element;
        String label = node.getName();
        if (node instanceof LTTngTraceFolderNode || node instanceof LTTngExperimentFolderNode || node instanceof LTTngExperimentNode) {
            label = String.valueOf(label) + " [" + node.getChildren().size() + "]";
        }
        return label;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

