/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.event;

import java.util.HashMap;
import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.event.LttngEventField;
import org.eclipse.linuxtools.lttng.event.LttngEventType;
import org.eclipse.linuxtools.lttng.jni.JniEvent;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfEventContent;
import org.eclipse.linuxtools.tmf.event.TmfNoSuchFieldException;

public class LttngEventContent
extends TmfEventContent {
    HashMap<String, LttngEventField> fFieldsMap = new HashMap();

    public LttngEventContent() {
        super(null, null);
    }

    public LttngEventContent(LttngEvent thisParent) {
        super((TmfEvent)thisParent, null);
    }

    public LttngEventContent(LttngEvent thisParent, HashMap<String, LttngEventField> thisContent) {
        super((TmfEvent)thisParent, null);
        this.fFieldsMap = thisContent;
    }

    public LttngEventContent(LttngEventContent oldContent) {
        this(oldContent.getEvent(), oldContent.getRawContent());
    }

    public LttngEvent getEvent() {
        return (LttngEvent)this.fParentEvent;
    }

    public void setEvent(LttngEvent newParent) {
        this.fParentEvent = newParent;
    }

    public LttngEventType getType() {
        return (LttngEventType)this.fParentEvent.getType();
    }

    public void setType(LttngEventType newType) {
        ((LttngEvent)this.fParentEvent).setType(newType);
    }

    public void emptyContent() {
        this.fFieldsMap.clear();
    }

    public Object[] getContent() {
        Object[] returnedContent = this.fFieldsMap.values().toArray(new Object[this.fFieldsMap.size()]);
        return returnedContent;
    }

    public HashMap<String, LttngEventField> getRawContent() {
        return this.fFieldsMap;
    }

    public synchronized LttngEventField[] getFields() {
        if (this.fFieldsMap.size() < this.fParentEvent.getType().getNbFields()) {
            LttngEventField tmpField = null;
            LttngEventType tmpType = (LttngEventType)this.fParentEvent.getType();
            int pos = 0;
            while (pos < tmpType.getNbFields()) {
                String name = null;
                LttngEvent lttngTmpEvent = this.getEvent();
                JniEvent tmpEvent = lttngTmpEvent.convertEventTmfToJni();
                if (tmpEvent != null) {
                    try {
                        name = tmpType.getLabel(pos);
                        Object newValue = tmpEvent.parseFieldByName(name);
                        tmpField = new LttngEventField(this, name, newValue);
                        this.fFieldsMap.put(name, tmpField);
                    }
                    catch (TmfNoSuchFieldException tmfNoSuchFieldException) {
                        System.out.println("Invalid field position requested : " + pos + ", ignoring (getFields).");
                    }
                }
                ++pos;
            }
        }
        return this.fFieldsMap.values().toArray(new LttngEventField[this.fFieldsMap.size()]);
    }

    public LttngEventField getField(int position) {
        LttngEventField returnedField = null;
        String label = null;
        try {
            label = this.fParentEvent.getType().getLabel(position);
            returnedField = this.getField(label);
        }
        catch (TmfNoSuchFieldException tmfNoSuchFieldException) {
            System.out.println("Invalid field position requested : " + position + ", ignoring (getField).");
        }
        return returnedField;
    }

    public synchronized LttngEventField getField(String name) {
        Object newValue;
        JniEvent tmpEvent;
        LttngEventField returnedField = this.fFieldsMap.get(name);
        if (returnedField == null && (tmpEvent = this.getEvent().convertEventTmfToJni()) != null && (newValue = tmpEvent.parseFieldByName(name)) != null) {
            returnedField = new LttngEventField(this, name, newValue);
            this.fFieldsMap.put(name, returnedField);
        }
        return returnedField;
    }

    protected void parseContent() {
        this.fFields = this.getFields();
    }

    public String toString() {
        LttngEventField[] allFields = this.getFields();
        StringBuffer strBuffer = new StringBuffer();
        int pos = 0;
        while (pos < allFields.length) {
            if (pos != 0) {
                strBuffer.append(",");
            }
            strBuffer.append(allFields[pos].toString());
            ++pos;
        }
        return strBuffer.toString();
    }

    public LttngEventContent clone() {
        LttngEventContent clone = (LttngEventContent)super.clone();
        LttngEventField[] fields = this.getFields();
        clone.fFields = new LttngEventField[fields.length];
        int i = 0;
        while (i < fields.length) {
            clone.fFields[i] = fields[i].clone();
            ++i;
        }
        clone.fFieldsMap = new HashMap();
        for (String key : this.fFieldsMap.keySet()) {
            clone.fFieldsMap.put(new String(key), this.fFieldsMap.get(key).clone());
        }
        return clone;
    }
}

