/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.trace;

import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.experiment.TmfExperimentContext;
import org.eclipse.linuxtools.tmf.experiment.TmfExperimentLocation;
import org.eclipse.linuxtools.tmf.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.trace.TmfContext;

public class LTTngExperiment<T extends TmfEvent>
extends TmfExperiment<T>
implements ITmfTrace {
    private static final int DEFAULT_INDEX_PAGE_SIZE = 50000;

    public LTTngExperiment(Class<T> type, String id, ITmfTrace[] traces, TmfTimestamp epoch, int indexPageSize) {
        this(type, id, traces, TmfTimestamp.Zero, indexPageSize, false);
    }

    public LTTngExperiment(Class<T> type, String id, ITmfTrace[] traces, TmfTimestamp epoch, int indexPageSize, boolean preIndexExperiment) {
        super(type, id, traces, epoch, indexPageSize, preIndexExperiment);
    }

    public LTTngExperiment(Class<T> type, String id, ITmfTrace[] traces) {
        this(type, id, traces, TmfTimestamp.Zero, 50000);
    }

    public LTTngExperiment(Class<T> type, String id, ITmfTrace[] traces, int indexPageSize) {
        this(type, id, traces, TmfTimestamp.Zero, indexPageSize);
    }

    public LTTngExperiment(LTTngExperiment<T> other) {
        super(String.valueOf(other.getName()) + "(clone)", other.fType);
        this.fEpoch = other.fEpoch;
        this.fIndexPageSize = other.fIndexPageSize;
        this.fTraces = new ITmfTrace[other.fTraces.length];
        int trace = 0;
        while (trace < other.fTraces.length) {
            this.fTraces[trace] = other.fTraces[trace].createTraceCopy();
            ++trace;
        }
        this.fNbEvents = other.fNbEvents;
        this.fTimeRange = other.fTimeRange;
    }

    public LTTngExperiment<T> createTraceCopy() {
        LTTngExperiment<T> experiment = new LTTngExperiment<T>(this);
        TmfSignalManager.deregister(experiment);
        return experiment;
    }

    public synchronized TmfEvent getNextEvent(TmfContext context) {
        TmfEvent[] eventArray;
        TmfExperimentContext expContext;
        int lastTrace;
        if (!(context instanceof TmfExperimentContext)) {
            return null;
        }
        if (!context.equals((Object)this.fExperimentContext)) {
            this.seekLocation(context.getLocation());
        }
        if ((lastTrace = (expContext = (TmfExperimentContext)context).getLastTrace()) != -1) {
            TmfContext traceContext = expContext.getContexts()[lastTrace];
            expContext.getEvents()[lastTrace] = expContext.getTraces()[lastTrace].getNextEvent(traceContext);
            expContext.setLastTrace(-1);
        }
        if ((eventArray = expContext.getEvents()) == null) {
            return null;
        }
        int trace = -1;
        TmfTimestamp timestamp = TmfTimestamp.BigCrunch;
        if (eventArray.length == 1) {
            if (eventArray[0] != null) {
                timestamp = eventArray[0].getTimestamp();
                trace = 0;
            }
        } else {
            int i = 0;
            while (i < eventArray.length) {
                TmfTimestamp otherTS;
                TmfEvent event = eventArray[i];
                if (event != null && event.getTimestamp() != null && (otherTS = event.getTimestamp()).compareTo(timestamp, true) < 0) {
                    trace = i;
                    timestamp = otherTS;
                }
                ++i;
            }
        }
        TmfEvent event = null;
        if (trace != -1) {
            TmfContext traceContext = expContext.getContexts()[trace];
            TmfExperimentLocation expLocation = (TmfExperimentLocation)expContext.getLocation();
            ((ITmfLocation[])expLocation.getLocation())[trace] = traceContext.getLocation();
            this.updateIndex((ITmfContext)expContext, timestamp);
            expLocation.getRanks()[trace] = traceContext.getRank();
            expContext.setLastTrace(trace);
            expContext.updateRank(1);
            event = expContext.getEvents()[trace];
        }
        return event;
    }

    public String toString() {
        return "[LTTngExperiment (" + this.getName() + ")]";
    }
}

