/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.view;

import java.util.HashMap;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelEvent;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelImage;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSample;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSession;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSymbol;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.ui.PartInitException;

public class OprofileViewDoubleClickListener
implements IDoubleClickListener {
    public void doubleClick(DoubleClickEvent event) {
        TreeViewer tv = (TreeViewer)event.getSource();
        TreeSelection tsl = (TreeSelection)tv.getSelection();
        IUiModelElement element = (IUiModelElement)tsl.getFirstElement();
        try {
            if (!(element instanceof UiModelEvent || element instanceof UiModelSession || element instanceof UiModelImage)) {
                if (element instanceof UiModelSymbol) {
                    UiModelSymbol symbol = (UiModelSymbol)element;
                    String imageLabel = symbol.getParent().getLabelText();
                    String fileName = symbol.getFileName();
                    String functionName = symbol.getFunctionName();
                    int numOfArgs = -1;
                    String absPath = imageLabel.substring(imageLabel.indexOf(" in ") + 4);
                    ICProject project = ProfileUIUtils.findCProjectWithAbsolutePath((String)absPath);
                    if (project == null) {
                        return;
                    }
                    if (functionName.matches(".*\\(.*\\)")) {
                        int start = functionName.indexOf(40);
                        if (functionName.contains(",")) {
                            int end = functionName.indexOf(41);
                            numOfArgs = functionName.substring(start, end).split(",").length;
                        } else {
                            numOfArgs = 1;
                        }
                        functionName = functionName.substring(0, start);
                    } else {
                        numOfArgs = 0;
                    }
                    if (fileName.length() > 0 && functionName.length() > 0) {
                        HashMap map = ProfileUIUtils.findFunctionsInProject((ICProject)project, (String)functionName, (int)numOfArgs, (String)fileName, (boolean)true);
                        if (map.isEmpty()) {
                            ProfileUIUtils.openEditorAndSelect((String)fileName, (int)1);
                        } else {
                            for (String loc : map.keySet()) {
                                ProfileUIUtils.openEditorAndSelect((String)loc, (int)((int[])map.get(loc))[0], (int)((int[])map.get(loc))[1]);
                            }
                        }
                    } else if (functionName.length() > 0) {
                        HashMap map = ProfileUIUtils.findFunctionsInProject((ICProject)project, (String)functionName, (int)numOfArgs, null, (boolean)true);
                        for (String loc : map.keySet()) {
                            ProfileUIUtils.openEditorAndSelect((String)loc, (int)((int[])map.get(loc))[0], (int)((int[])map.get(loc))[1]);
                        }
                    } else if (fileName.length() > 0) {
                        ProfileUIUtils.openEditorAndSelect((String)fileName, (int)1);
                    }
                } else if (element instanceof UiModelSample) {
                    UiModelSample sample = (UiModelSample)element;
                    int line = sample.getLine();
                    UiModelSymbol symbol = (UiModelSymbol)sample.getParent();
                    String fileName = symbol.getFileName();
                    ProfileUIUtils.openEditorAndSelect((String)fileName, (int)line);
                }
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        catch (PartInitException e2) {
            e2.printStackTrace();
        }
        catch (CoreException e3) {
            e3.printStackTrace();
        }
    }
}

