/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.linuxtools.rpm.core.RPMConfiguration;
import org.eclipse.linuxtools.rpm.core.utils.Utils;

public class RPMBuild {
    private static final String DEFINE = "--define";
    private String[] macroDefines;
    private String rpmBuildCmd;

    public RPMBuild(RPMConfiguration config) {
        IEclipsePreferences node = new DefaultScope().getNode("org.eclipse.linuxtools.rpm.core");
        this.rpmBuildCmd = node.get("RPMBUILD_CMD", "");
        String[] tmpMacroDefines = new String[]{this.rpmBuildCmd, "-v", DEFINE, "_sourcedir " + config.getSourcesFolder().getLocation().toOSString(), DEFINE, "_srcrpmdir " + config.getSrpmsFolder().getLocation().toOSString(), DEFINE, "_builddir " + config.getBuildFolder().getLocation().toOSString(), DEFINE, "_rpmdir " + config.getRpmsFolder().getLocation().toOSString(), DEFINE, "_specdir " + config.getSpecsFolder().getLocation().toOSString()};
        this.macroDefines = tmpMacroDefines;
    }

    public InputStream buildPrep(IFile specFile) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(this.macroDefines));
        command.add("-bp");
        command.add(specFile.getLocation().toString());
        try {
            return Utils.runCommandToInputStream(command.toArray(new String[command.size()]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
        }
    }

    public void buildBinary(IFile specFile, OutputStream outStream) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(this.macroDefines));
        command.add("-bb");
        command.add(specFile.getLocation().toString());
        try {
            Utils.runCommand(outStream, command.toArray(new String[command.size()]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
        }
    }

    public void buildAll(IFile specFile, OutputStream outStream) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(this.macroDefines));
        command.add("-ba");
        command.add(specFile.getLocation().toString());
        try {
            Utils.runCommand(outStream, command.toArray(new String[command.size()]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
        }
    }

    public void buildSource(IFile specFile, OutputStream outStream) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(this.macroDefines));
        command.add("-bs");
        command.add(specFile.getLocation().toString());
        try {
            Utils.runCommand(outStream, command.toArray(new String[command.size()]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
        }
    }
}

