/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.rpmlint.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.rpm.rpmlint.RpmlintLog;
import org.eclipse.linuxtools.rpm.rpmlint.builder.RpmlintBuilder;
import org.eclipse.linuxtools.rpm.rpmlint.parser.RpmlintItem;
import org.eclipse.linuxtools.rpm.rpmlint.parser.RpmlintParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpmlintMarkerVisitor
implements IResourceVisitor {
    private ArrayList<RpmlintItem> rpmlintItems;
    private int lineNumber;
    private RpmlintBuilder builder;
    private String specContent;
    private boolean firstWarningInResource;
    private IFile currentFile;
    private IDocument document;
    private int charStart;
    private int charEnd;

    public RpmlintMarkerVisitor(RpmlintBuilder builder, ArrayList<RpmlintItem> rpmlintItems) {
        this.rpmlintItems = rpmlintItems;
        this.builder = builder;
        rpmlintItems = new ArrayList();
    }

    public boolean visit(IResource resource) throws CoreException {
        block9: {
            block8: {
                if (!"spec".equals(resource.getFileExtension())) break block8;
                this.firstWarningInResource = true;
                for (RpmlintItem item : this.rpmlintItems) {
                    if (!item.getFileName().equals(resource.getLocation().toOSString())) continue;
                    this.currentFile = (IFile)resource;
                    if (this.firstWarningInResource) {
                        RpmlintParser.getInstance().deleteMarkers(resource);
                        this.currentFile.deleteMarkers("org.eclipse.linuxtools.rpm.ui.editor.specfileerror", false, 0);
                        this.firstWarningInResource = false;
                    }
                    this.specContent = this.fileToString(this.currentFile);
                    if (item.getId().equals("configure-without-libdir-spec")) {
                        item.setLineNbr(-1);
                        this.lineNumber = RpmlintParser.getInstance().getRealLineNbr(this.specContent, "./configure");
                        if (this.lineNumber == -1) {
                            this.lineNumber = RpmlintParser.getInstance().getRealLineNbr(this.specContent, "%configure");
                        }
                        item.setLineNbr(this.lineNumber);
                    }
                    this.lineNumber = item.getLineNbr();
                    if (this.lineNumber == -1) {
                        this.lineNumber = RpmlintParser.getInstance().getRealLineNbr(this.specContent, item.getRefferedContent());
                        if (this.lineNumber == -1) {
                            this.lineNumber = 1;
                        }
                    }
                    --this.lineNumber;
                    this.builder.getSpecfileParser().setErrorHandler(this.builder.getSpecfileErrorHandler(this.currentFile, this.specContent));
                    this.builder.getSpecfileParser().setTaskHandler(this.builder.getSpecfileTaskHandler(this.currentFile, this.specContent));
                    this.builder.getSpecfileParser().parse(this.specContent);
                    this.document = new Document(this.specContent);
                    this.charStart = this.getLineOffset(this.lineNumber);
                    this.charEnd = this.charStart + this.getLineLenght(this.lineNumber);
                    RpmlintParser.getInstance().addMarker((IFile)resource, String.valueOf(item.getId()) + ": " + item.getMessage(), this.lineNumber, this.charStart, this.charEnd, item.getSeverity(), item.getId(), item.getRefferedContent());
                }
                break block9;
            }
            if (!"rpm".equals(resource.getFileExtension())) break block9;
            this.firstWarningInResource = true;
            for (RpmlintItem item : this.rpmlintItems) {
                this.currentFile = (IFile)resource;
                if (this.firstWarningInResource) {
                    RpmlintParser.getInstance().deleteMarkers(resource);
                    this.currentFile.deleteMarkers("org.eclipse.linuxtools.rpm.ui.editor.specfileerror", false, 0);
                    this.firstWarningInResource = false;
                }
                this.builder.getSpecfileParser().setErrorHandler(this.builder.getSpecfileErrorHandler(this.currentFile, this.specContent));
                this.builder.getSpecfileParser().setTaskHandler(this.builder.getSpecfileTaskHandler(this.currentFile, this.specContent));
                RpmlintParser.getInstance().addMarker((IFile)resource, String.valueOf(item.getId()) + ": " + item.getMessage(), item.getSeverity(), item.getId(), item.getRefferedContent());
            }
        }
        return true;
    }

    private int getLineOffset(int lineNumber) {
        try {
            return this.document.getLineOffset(lineNumber);
        }
        catch (BadLocationException e) {
            RpmlintLog.logError(e);
            return 1;
        }
    }

    private int getLineLenght(int lineNumber) {
        try {
            return this.document.getLineLength(lineNumber);
        }
        catch (BadLocationException e) {
            RpmlintLog.logError(e);
            return 1;
        }
    }

    private String fileToString(IFile file) {
        String ret = "";
        try {
            InputStream in = file.getContents();
            int nbrOfByte = in.available();
            byte[] bytes = new byte[nbrOfByte];
            in.read(bytes);
            ret = new String(bytes);
            in.close();
        }
        catch (CoreException e) {
            RpmlintLog.logError(e);
        }
        catch (IOException e) {
            RpmlintLog.logError(e);
        }
        return ret;
    }
}

