/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui;

import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.linuxtools.rpm.ui.IRPMUIConstants;
import org.eclipse.linuxtools.rpm.ui.Messages;
import org.eclipse.linuxtools.rpm.ui.RpmConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class RPMExportOperation
extends Job {
    private IProgressMonitor monitor;
    private RPMProject rpmProject;
    private IRPMUIConstants.BuildType exportType;

    public RPMExportOperation(RPMProject rpmProject, IRPMUIConstants.BuildType exportType) {
        super(Messages.getString("RPMExportWizard.0"));
        this.rpmProject = rpmProject;
        this.exportType = exportType;
    }

    public IStatus run(IProgressMonitor progressMonitor) {
        int totalWork = 2;
        this.monitor = progressMonitor;
        this.monitor.beginTask(Messages.getString("RPMExportOperation.Starting"), totalWork);
        this.monitor.worked(1);
        IOConsole myConsole = this.findConsole();
        IOConsoleOutputStream out = myConsole.newOutputStream();
        myConsole.clearConsole();
        myConsole.activate();
        switch (this.exportType) {
            case ALL: {
                try {
                    this.monitor.setTaskName(Messages.getString("RPMExportOperation.Executing_RPM_Export"));
                    this.rpmProject.buildAll((OutputStream)out);
                    break;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.linuxtools.rpm.ui", e.getMessage(), (Throwable)e);
                }
            }
            case BINARY: {
                this.monitor.setTaskName(Messages.getString("RPMExportOperation.Executing_RPM_Export"));
                try {
                    this.rpmProject.buildBinaryRPM((OutputStream)out);
                    break;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.linuxtools.rpm.ui", e.getMessage(), (Throwable)e);
                }
            }
            case SOURCE: {
                this.monitor.setTaskName(Messages.getString("RPMExportOperation.Executing_SRPM_Export"));
                try {
                    this.rpmProject.buildSourceRPM((OutputStream)out);
                    break;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.linuxtools.rpm.ui", e.getMessage(), (Throwable)e);
                }
            }
        }
        this.monitor.worked(1);
        this.monitor.done();
        return Status.OK_STATUS;
    }

    private IOConsole findConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if ("rpmbuild".equals(existing[i].getName())) {
                return (RpmConsole)existing[i];
            }
            ++i;
        }
        RpmConsole myConsole = new RpmConsole(this.rpmProject);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

