/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.rpm.ui.Messages;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class RPMNewProject
extends Wizard
implements INewWizard {
    WizardNewProjectCreationPage namePage;

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    RPMNewProject.this.createProject((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.addPages();
        this.namePage = new WizardNewProjectCreationPage(Messages.getString("RPMNewProject.0"));
        this.namePage.setTitle(Messages.getString("RPMNewProject.1"));
        this.namePage.setDescription(Messages.getString("RPMNewProject.2"));
        this.namePage.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/rpm.gif"));
        this.addPage((IWizardPage)this.namePage);
    }

    protected void createProject(IProgressMonitor monitor) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(this.namePage.getProjectName());
            IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            if (!Platform.getLocation().equals((Object)this.namePage.getLocationPath())) {
                description.setLocation(this.namePage.getLocationPath());
            }
            description.setNatureIds(new String[]{"org.eclipse.linuxtools.rpm.core.rpmnature"});
            project.create(description, monitor);
            monitor.worked(10);
            project.open(monitor);
            project.getFolder("SPECS").create(true, true, monitor);
            project.getFolder("SOURCES").create(true, true, monitor);
            IFolder buildFolder = project.getFolder("BUILD");
            buildFolder.create(true, true, monitor);
            buildFolder.setHidden(true);
            project.getFolder("RPMS").create(true, true, monitor);
            project.getFolder("SRPMS").create(true, true, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

