/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.rpm.core.utils.FileDownloadJob;
import org.eclipse.linuxtools.rpm.ui.Messages;
import org.eclipse.linuxtools.rpm.ui.RPMNewProject;
import org.eclipse.linuxtools.rpm.ui.SRPMImportOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SRPMImportPage
extends WizardPage
implements Listener {
    private Combo sourceSRPM;
    private Button intoConfigured;
    private Button intoExisting;
    private List projectList;
    private IStructuredSelection selection;
    private static Vector<String> srpmVector;

    public SRPMImportPage(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        super(Messages.getString("SRPMImportPage.Import_SRPM"), Messages.getString("SRPMImportPage.Select_project_to_import"), null);
        this.setPageComplete(false);
        this.setDescription(Messages.getString("SRPMImportPage.Select_project_to_import"));
        this.selection = currentSelection;
    }

    private String getSelectedProjectName() {
        String[] selections = this.projectList.getSelection();
        if (selections.length > 0) {
            return selections[0];
        }
        return null;
    }

    private File getSelectedSRPM() {
        String srpmName = this.sourceSRPM.getText();
        if (srpmName == null || srpmName.equals("")) {
            return null;
        }
        if (srpmName.startsWith("http://")) {
            try {
                URL url = new URL(srpmName);
                URLConnection content = url.openConnection();
                File tempFile = new File(System.getProperty("java.io.tmpdir"), srpmName.substring(srpmName.lastIndexOf(47) + 1));
                if (tempFile.exists()) {
                    tempFile.delete();
                }
                final FileDownloadJob downloadJob = new FileDownloadJob(tempFile, content);
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        downloadJob.run(monitor);
                    }
                });
                return tempFile;
            }
            catch (Exception exception) {}
        }
        return new File(this.sourceSRPM.getText());
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        this.createSourceRPMCombo(composite);
        this.createProjectBox(composite);
    }

    private void createSourceRPMCombo(Composite parent) {
        Group specGrid = new Group(parent, 0);
        specGrid.setLayout((Layout)new GridLayout());
        specGrid.setText(Messages.getString("SRPMImportPage.SRPM_Name"));
        specGrid.setLayoutData((Object)new GridData(768));
        Composite sourceSpecComposite = new Composite((Composite)specGrid, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        sourceSpecComposite.setLayout((Layout)layout);
        sourceSpecComposite.setLayoutData((Object)new GridData(768));
        this.sourceSRPM = new Combo(sourceSpecComposite, 2048);
        this.sourceSRPM.setToolTipText(Messages.getString("SRPMImportPage.toolTip_SRPM_Name"));
        if (srpmVector == null) {
            srpmVector = new Vector();
        }
        int i = srpmVector.size();
        while (i > 0) {
            this.sourceSRPM.add(srpmVector.elementAt(i - 1));
            --i;
        }
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.sourceSRPM.setLayoutData((Object)gridData);
        this.sourceSRPM.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SRPMImportPage.this.handleEvent(null);
            }
        });
        Button srpmBrowse = new Button(sourceSpecComposite, 8);
        srpmBrowse.setToolTipText(Messages.getString("SRPMImportPage.toolTip_Open_file_navigator"));
        srpmBrowse.setText(Messages.getString("RPMPage.Browse"));
        srpmBrowse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                File testSRPMfilename;
                FileDialog srpmBrowseDialog = new FileDialog(SRPMImportPage.this.getContainer().getShell(), 4096);
                String selectedSRPM_name = srpmBrowseDialog.open();
                if (selectedSRPM_name != null && (testSRPMfilename = new File(selectedSRPM_name)).isFile()) {
                    SRPMImportPage.this.sourceSRPM.setText(selectedSRPM_name);
                }
            }
        });
        srpmBrowse.addListener(16, (Listener)this);
    }

    private void createProjectBox(Composite parent) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.getString("SRPMImportPage.import_srpm_into"));
        group.setLayoutData((Object)new GridData(768));
        this.intoExisting = new Button((Composite)group, 16);
        this.intoExisting.setText(Messages.getString("RPMPage.Select_a_project"));
        this.projectList = new List((Composite)group, 2564);
        this.projectList.setLayoutData((Object)new GridData(768));
        this.projectList.setToolTipText(Messages.getString("SRPMImportPage.toolTip_project_destination"));
        this.intoConfigured = new Button((Composite)group, 16);
        this.intoConfigured.setText(Messages.getString("SRPMImportPage.Configured_New_Project"));
        GridData projectLayout = new GridData(768);
        projectLayout.heightHint = this.projectList.getItemHeight() * 4;
        this.projectList.setLayoutData((Object)projectLayout);
        IProject[] internalProjectList = workspaceRoot.getProjects();
        Iterator iter = this.selection.iterator();
        Object selectedObject = null;
        IProject selectedProject = null;
        boolean isSelection = false;
        if (iter.hasNext() && (selectedObject = iter.next()) instanceof IResource) {
            selectedProject = ((IResource)selectedObject).getProject();
            isSelection = true;
        }
        int a = 0;
        while (a < internalProjectList.length) {
            this.projectList.add(internalProjectList[a].getName());
            if (isSelection && internalProjectList[a].equals((Object)selectedProject)) {
                this.projectList.setSelection(a);
            }
            ++a;
        }
        if (this.projectList.getItemCount() == 0) {
            this.projectList.add(Messages.getString("SRPMImportPage.No_projects_found"));
            this.intoExisting.setEnabled(false);
            this.projectList.setEnabled(false);
            this.intoConfigured.setSelection(true);
            isSelection = true;
        } else {
            this.intoExisting.setSelection(true);
        }
        if (!isSelection) {
            this.projectList.setSelection(0);
        } else {
            this.projectList.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SRPMImportPage.this.handleEvent(null);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.intoExisting.addListener(13, (Listener)this);
        this.intoConfigured.addListener(13, (Listener)this);
        this.projectList.addListener(16, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event != null) {
            if (event.widget == this.intoExisting && this.intoExisting.getSelection()) {
                this.projectList.setEnabled(true);
            } else if (event.widget == this.intoConfigured && this.intoConfigured.getSelection()) {
                this.projectList.setEnabled(false);
            }
        }
        this.setPageComplete(this.canFinish());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canFinish() {
        if (this.getSelectedProjectName() == null && !this.intoConfigured.getSelection()) {
            return false;
        }
        String sourceSRPMName = this.sourceSRPM.getText();
        if (this.sourceSRPM.getText().lastIndexOf(".src.rpm") == -1) {
            this.setErrorMessage(Messages.getString("SRPMImportPage.No_src_rpm_ext"));
            return false;
        }
        if (sourceSRPMName.startsWith("http://")) {
            try {
                URL url = new URL(sourceSRPMName);
                if (404 == ((HttpURLConnection)url.openConnection()).getResponseCode()) {
                    this.setErrorMessage("HTTP not found!!!");
                    return false;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            if (sourceSRPMName.equals("")) {
                return false;
            }
            File srpm = new File(sourceSRPMName);
            if (!srpm.isFile()) {
                this.setErrorMessage(Messages.getString("SRPMImportPage.Source_not_Valid"));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean finish() {
        IProject detailedProject;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (this.intoExisting.getSelection()) {
            String[] selectedProject = this.projectList.getSelection();
            detailedProject = workspaceRoot.getProject(selectedProject[0]);
        } else {
            detailedProject = this.getNewProject();
            if (detailedProject == null) {
                return false;
            }
        }
        int i = 0;
        while (i < srpmVector.size()) {
            if (srpmVector.elementAt(i).equals(this.sourceSRPM.getText())) {
                srpmVector.remove(i);
                break;
            }
            ++i;
        }
        srpmVector.add(this.sourceSRPM.getText());
        SRPMImportOperation srpmImportOp = null;
        try {
            srpmImportOp = new SRPMImportOperation(detailedProject, this.getSelectedSRPM());
            this.getContainer().run(true, true, (IRunnableWithProgress)srpmImportOp);
        }
        catch (Exception e) {
            this.setErrorMessage(e.toString());
            return false;
        }
        MultiStatus srpmImportStatus = srpmImportOp.getStatus();
        if (!srpmImportStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.getString("SRPMImportPage.Errors_importing_SRPM"), null, (IStatus)srpmImportStatus);
            return false;
        }
        return true;
    }

    private IProject getNewProject() {
        NewProjectListener listener = new NewProjectListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        RPMNewProject wizard = new RPMNewProject();
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        IProject project = listener.getNewProject();
        return project;
    }

    class NewProjectListener
    implements IResourceChangeListener {
        private IProject newProject = null;

        NewProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            IResourceDelta[] projectDeltas = root.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                IResourceDelta delta = projectDeltas[i];
                IResource resource = delta.getResource();
                if (delta.getKind() == 1) {
                    this.newProject = (IProject)resource;
                }
                ++i;
            }
        }

        public IProject getNewProject() {
            return this.newProject;
        }
    }
}

