/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.dialogs;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.ui.dialogs.Messages;
import org.eclipse.linuxtools.tmf.ui.parsers.ParserProviderManager;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTxtTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.views.project.ProjectView;
import org.eclipse.linuxtools.tmf.ui.wizards.CustomTxtParserWizard;
import org.eclipse.linuxtools.tmf.ui.wizards.CustomXmlParserWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ManageCustomParsersDialog
extends Dialog {
    private static final Image image = TmfUiPlugin.getDefault().getImageFromPath("/icons/customparser_wizard.gif");
    Button txtButton;
    Button xmlButton;
    List parserList;
    Button newButton;
    Button editButton;
    Button deleteButton;
    Button importButton;
    Button exportButton;
    Button parseButton;

    public ManageCustomParsersDialog(Shell parent) {
        super(parent);
        this.setShellStyle(0x410 | this.getShellStyle());
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ManageCustomParsersDialog_DialogHeader);
        this.getShell().setImage(image);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite listContainer = new Composite(composite, 0);
        listContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout lcgl = new GridLayout();
        lcgl.marginHeight = 0;
        lcgl.marginWidth = 0;
        listContainer.setLayout((Layout)lcgl);
        Composite radioContainer = new Composite(listContainer, 0);
        GridLayout rcgl = new GridLayout(2, true);
        rcgl.marginHeight = 0;
        rcgl.marginWidth = 0;
        radioContainer.setLayout((Layout)rcgl);
        this.txtButton = new Button(radioContainer, 16);
        this.txtButton.setText(Messages.ManageCustomParsersDialog_TextButtonLabel);
        this.txtButton.setSelection(true);
        this.txtButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ManageCustomParsersDialog.this.fillParserList();
            }
        });
        this.xmlButton = new Button(radioContainer, 16);
        this.xmlButton.setText("XML");
        this.xmlButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ManageCustomParsersDialog.this.fillParserList();
            }
        });
        this.parserList = new List(listContainer, 2820);
        this.parserList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.parserList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ManageCustomParsersDialog.this.parserList.getSelectionCount() == 0) {
                    ManageCustomParsersDialog.this.editButton.setEnabled(false);
                    ManageCustomParsersDialog.this.deleteButton.setEnabled(false);
                    ManageCustomParsersDialog.this.exportButton.setEnabled(false);
                    ManageCustomParsersDialog.this.parseButton.setEnabled(false);
                } else {
                    ManageCustomParsersDialog.this.editButton.setEnabled(true);
                    ManageCustomParsersDialog.this.deleteButton.setEnabled(true);
                    ManageCustomParsersDialog.this.exportButton.setEnabled(true);
                    ManageCustomParsersDialog.this.parseButton.setEnabled(true);
                }
            }
        });
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.newButton = new Button(buttonContainer, 8);
        this.newButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.newButton.setText(Messages.ManageCustomParsersDialog_NewButtonLabel);
        this.newButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WizardDialog dialog = null;
                if (ManageCustomParsersDialog.this.txtButton.getSelection()) {
                    dialog = new WizardDialog(ManageCustomParsersDialog.this.getShell(), (IWizard)new CustomTxtParserWizard());
                } else if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                    dialog = new WizardDialog(ManageCustomParsersDialog.this.getShell(), (IWizard)new CustomXmlParserWizard());
                }
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    ManageCustomParsersDialog.this.fillParserList();
                }
            }
        });
        this.editButton = new Button(buttonContainer, 8);
        this.editButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.editButton.setText(Messages.ManageCustomParsersDialog_EditButtonLabel);
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WizardDialog dialog = null;
                if (ManageCustomParsersDialog.this.txtButton.getSelection()) {
                    dialog = new WizardDialog(ManageCustomParsersDialog.this.getShell(), (IWizard)new CustomTxtParserWizard(CustomTxtTraceDefinition.load(ManageCustomParsersDialog.this.parserList.getSelection()[0])));
                } else if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                    dialog = new WizardDialog(ManageCustomParsersDialog.this.getShell(), (IWizard)new CustomXmlParserWizard(CustomXmlTraceDefinition.load(ManageCustomParsersDialog.this.parserList.getSelection()[0])));
                }
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    ManageCustomParsersDialog.this.fillParserList();
                }
            }
        });
        this.deleteButton = new Button(buttonContainer, 8);
        this.deleteButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.deleteButton.setText(Messages.ManageCustomParsersDialog_DeleteButtonLabel);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean confirm = MessageDialog.openQuestion((Shell)ManageCustomParsersDialog.this.getShell(), (String)Messages.ManageCustomParsersDialog_DeleteParserDialogHeader, (String)(String.valueOf(Messages.ManageCustomParsersDialog_DeleteConfirmation) + ManageCustomParsersDialog.this.parserList.getSelection()[0] + "?"));
                if (confirm) {
                    if (ManageCustomParsersDialog.this.txtButton.getSelection()) {
                        CustomTxtTraceDefinition.delete(ManageCustomParsersDialog.this.parserList.getSelection()[0]);
                    } else if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                        CustomXmlTraceDefinition.delete(ManageCustomParsersDialog.this.parserList.getSelection()[0]);
                    }
                    ManageCustomParsersDialog.this.fillParserList();
                }
            }
        });
        new Label(buttonContainer, 0);
        this.importButton = new Button(buttonContainer, 8);
        this.importButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.importButton.setText(Messages.ManageCustomParsersDialog_ImportButtonLabel);
        this.importButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setText(Messages.ManageCustomParsersDialog_ImportParserSelection);
                dialog.setFilterExtensions(new String[]{"*.xml", "*"});
                String path = dialog.open();
                if (path != null) {
                    CustomTraceDefinition[] defs = null;
                    if (ManageCustomParsersDialog.this.txtButton.getSelection()) {
                        defs = CustomTxtTraceDefinition.loadAll(path);
                    } else if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                        defs = CustomXmlTraceDefinition.loadAll(path);
                    }
                    if (defs != null && defs.length > 0) {
                        CustomTraceDefinition[] customTraceDefinitionArray = defs;
                        int n = defs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CustomTraceDefinition def = customTraceDefinitionArray[n2];
                            def.save();
                            ++n2;
                        }
                        ManageCustomParsersDialog.this.fillParserList();
                    }
                }
            }
        });
        this.exportButton = new Button(buttonContainer, 8);
        this.exportButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.exportButton.setText(Messages.ManageCustomParsersDialog_ExportButtonLabel);
        this.exportButton.setEnabled(false);
        this.exportButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                dialog.setText(String.valueOf(Messages.ManageCustomParsersDialog_ExportParserSelection) + ManageCustomParsersDialog.this.parserList.getSelection()[0]);
                dialog.setFilterExtensions(new String[]{"*.xml", "*"});
                String path = dialog.open();
                if (path != null) {
                    CustomTraceDefinition def = null;
                    if (ManageCustomParsersDialog.this.txtButton.getSelection()) {
                        def = CustomTxtTraceDefinition.load(ManageCustomParsersDialog.this.parserList.getSelection()[0]);
                    } else if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                        def = CustomXmlTraceDefinition.load(ManageCustomParsersDialog.this.parserList.getSelection()[0]);
                    }
                    if (def != null) {
                        ((CustomTraceDefinition)def).save(path);
                    }
                }
            }
        });
        this.parseButton = new Button(buttonContainer, 8);
        this.parseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.parseButton.setText(Messages.ManageCustomParsersDialog_ParseButtonLabel);
        this.parseButton.setEnabled(false);
        this.parseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setText(String.valueOf(Messages.ManageCustomParsersDialog_TraceSelection) + ManageCustomParsersDialog.this.parserList.getSelection()[0]);
                if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                    dialog.setFilterExtensions(new String[]{"*.xml", "*"});
                }
                String path = dialog.open();
                String parser = null;
                if (path != null) {
                    CustomTraceDefinition def = null;
                    if (ManageCustomParsersDialog.this.txtButton.getSelection()) {
                        def = CustomTxtTraceDefinition.load(ManageCustomParsersDialog.this.parserList.getSelection()[0]);
                        parser = String.valueOf(CustomTxtTrace.class.getCanonicalName()) + "." + def.definitionName;
                    } else if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                        def = CustomXmlTraceDefinition.load(ManageCustomParsersDialog.this.parserList.getSelection()[0]);
                        parser = String.valueOf(CustomXmlTrace.class.getCanonicalName()) + "." + def.definitionName;
                    }
                    if (def != null) {
                        try {
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IPath location = Path.fromOSString((String)path);
                            IFile file = workspace.getRoot().getFileForLocation(location);
                            if (file == null) {
                                file = ProjectView.createLink(new File(location.toPortableString()).toURI());
                            }
                            file.setPersistentProperty(ParserProviderManager.PARSER_PROPERTY, parser);
                            FileEditorInput editorInput = new FileEditorInput(file);
                            IWorkbench wb = PlatformUI.getWorkbench();
                            IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                            String editorId = "org.eclipse.linuxtools.tmf.ui.editors.events";
                            IEditorPart editor = activePage.findEditor((IEditorInput)editorInput);
                            if (editor != null && editor instanceof IReusableEditor) {
                                activePage.reuseEditor((IReusableEditor)editor, (IEditorInput)editorInput);
                                activePage.activate((IWorkbenchPart)editor);
                            } else {
                                editor = activePage.openEditor((IEditorInput)editorInput, editorId);
                            }
                        }
                        catch (CoreException e1) {
                            MessageDialog.openError((Shell)ManageCustomParsersDialog.this.getShell(), (String)"Parse Error", (String)e1.getMessage());
                        }
                    }
                }
            }
        });
        this.fillParserList();
        this.getShell().setMinimumSize(300, 275);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, false);
    }

    private void fillParserList() {
        this.parserList.removeAll();
        if (this.txtButton.getSelection()) {
            CustomTxtTraceDefinition[] customTxtTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
            int n = customTxtTraceDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                CustomTxtTraceDefinition def = customTxtTraceDefinitionArray[n2];
                this.parserList.add(def.definitionName);
                ++n2;
            }
        } else if (this.xmlButton.getSelection()) {
            CustomXmlTraceDefinition[] customXmlTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
            int n = customXmlTraceDefinitionArray.length;
            int n3 = 0;
            while (n3 < n) {
                CustomXmlTraceDefinition def = customXmlTraceDefinitionArray[n3];
                this.parserList.add(def.definitionName);
                ++n3;
            }
        }
        this.editButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.exportButton.setEnabled(false);
        this.parseButton.setEnabled(false);
    }
}

