/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.parsers.custom;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfEventContent;
import org.eclipse.linuxtools.tmf.event.TmfEventReference;
import org.eclipse.linuxtools.tmf.event.TmfEventSource;
import org.eclipse.linuxtools.tmf.event.TmfEventType;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTraceDefinition;

public class CustomEvent
extends TmfEvent {
    protected static final String TIMESTAMP_INPUT_FORMAT_KEY = "CE_TS_I_F";
    protected static final String NO_MESSAGE = "";
    public static final byte TIMESTAMP_SCALE = -3;
    protected CustomTraceDefinition fDefinition;
    protected Map<String, String> fData;
    private String[] fColumnData;

    public CustomEvent(CustomTraceDefinition definition, TmfEvent other) {
        super(other);
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
    }

    public CustomEvent(CustomTraceDefinition definition, TmfTimestamp timestamp, TmfEventSource source, TmfEventType type2, TmfEventReference reference) {
        super(timestamp, source, type2, reference);
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
    }

    public CustomEvent(CustomTraceDefinition definition, TmfTimestamp originalTS, TmfTimestamp effectiveTS, TmfEventSource source, TmfEventType type2, TmfEventReference reference) {
        super(originalTS, effectiveTS, source, type2, reference);
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
    }

    public TmfTimestamp getTimestamp() {
        if (this.fData != null) {
            this.processData();
        }
        return super.getTimestamp();
    }

    public TmfTimestamp getOriginalTimestamp() {
        if (this.fData != null) {
            this.processData();
        }
        return super.getOriginalTimestamp();
    }

    public TmfEventContent getContent() {
        if (this.fData != null) {
            this.processData();
        }
        return super.getContent();
    }

    public String[] extractItemFields() {
        if (this.fData != null) {
            this.processData();
        }
        return this.fColumnData;
    }

    private void processData() {
        String timeStampString = this.fData.get(CustomTraceDefinition.TAG_TIMESTAMP);
        String timeStampInputFormat = this.fData.get(TIMESTAMP_INPUT_FORMAT_KEY);
        Date date = null;
        if (timeStampInputFormat != null && timeStampString != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(timeStampInputFormat);
            try {
                date = dateFormat.parse(timeStampString);
                this.fOriginalTimestamp = this.fEffectiveTimestamp = new TmfTimestamp(date.getTime(), -3);
            }
            catch (ParseException parseException) {
                this.fOriginalTimestamp = this.fEffectiveTimestamp = TmfTimestamp.Zero;
            }
        } else {
            this.fOriginalTimestamp = this.fEffectiveTimestamp = TmfTimestamp.Zero;
        }
        int i = 0;
        this.fColumnData = new String[this.fDefinition.outputs.size()];
        for (CustomTraceDefinition.OutputColumn outputColumn : this.fDefinition.outputs) {
            String value = this.fData.get(outputColumn.name);
            if (outputColumn.name.equals(CustomTraceDefinition.TAG_TIMESTAMP) && date != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.fDefinition.timeStampOutputFormat);
                this.fColumnData[i++] = dateFormat.format(date);
                continue;
            }
            this.fColumnData[i++] = value;
        }
        String message = this.fData.get(CustomTraceDefinition.TAG_MESSAGE);
        this.setContent(new TmfEventContent((TmfEvent)this, (Object)message));
        this.fData = null;
    }
}

