/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.parsers.custom;

import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.TimeZone;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomEvent;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.linuxtools.tmf.ui.widgets.ColumnData;
import org.eclipse.swt.widgets.Composite;

public class CustomEventsTable
extends TmfEventsTable {
    private CustomTraceDefinition fDefinition;
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final SimpleDateFormat TIMESTAMP_SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    static {
        TIMESTAMP_SIMPLE_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public CustomEventsTable(CustomTraceDefinition definition, Composite parent, int cacheSize) {
        super(parent, cacheSize);
        this.fDefinition = definition;
        this.createColumnHeaders();
    }

    protected void createColumnHeaders() {
        if (this.fDefinition == null) {
            return;
        }
        LinkedList<ColumnData> columnData = new LinkedList<ColumnData>();
        for (CustomTraceDefinition.OutputColumn outputColumn : this.fDefinition.outputs) {
            ColumnData column = new ColumnData(outputColumn.name, 0, 16384);
            columnData.add(column);
        }
        this.setColumnHeaders(columnData.toArray(new ColumnData[0]));
    }

    @Override
    public String[] extractItemFields(TmfEvent event) {
        if (event instanceof CustomEvent) {
            return ((CustomEvent)event).extractItemFields();
        }
        return new String[0];
    }
}

