/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.parsers.custom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfEventReference;
import org.eclipse.linuxtools.tmf.event.TmfEventSource;
import org.eclipse.linuxtools.tmf.event.TmfEventType;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.trace.TmfContext;
import org.eclipse.linuxtools.tmf.trace.TmfLocation;
import org.eclipse.linuxtools.tmf.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTxtEvent;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTxtTraceContext;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTxtTraceDefinition;

public class CustomTxtTrace
extends TmfTrace<CustomTxtEvent> {
    private CustomTxtTraceDefinition fDefinition;

    public CustomTxtTrace(String name, CustomTxtTraceDefinition definition, String path, int cacheSize) throws FileNotFoundException {
        super(name, CustomTxtEvent.class, path, cacheSize);
        this.fDefinition = definition;
    }

    public ITmfTrace createTraceCopy() {
        return null;
    }

    public TmfContext seekLocation(ITmfLocation<?> location) {
        CustomTxtTraceContext context = new CustomTxtTraceContext((ITmfLocation<?>)new TmfLocation(null), -1L);
        if (!new File(this.getPath()).isFile()) {
            return context;
        }
        try {
            String line;
            RandomAccessFile raFile = new RandomAccessFile(this.getPath(), "r");
            if (location != null && location.getLocation() instanceof Long) {
                raFile.seek((Long)location.getLocation());
            }
            long rawPos = raFile.getFilePointer();
            while ((line = raFile.readLine()) != null) {
                for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                    Matcher matcher = input.getPattern().matcher(line);
                    if (!matcher.find()) continue;
                    context.setLocation((ITmfLocation)new TmfLocation((Object)rawPos));
                    context.raFile = raFile;
                    context.firstLineMatcher = matcher;
                    context.nextLineLocation = raFile.getFilePointer();
                    context.inputLine = input;
                    return context;
                }
                rawPos = raFile.getFilePointer();
            }
            return context;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return context;
        }
        catch (IOException e) {
            e.printStackTrace();
            return context;
        }
    }

    public ITmfLocation<?> getCurrentLocation() {
        return null;
    }

    public synchronized TmfEvent getNextEvent(TmfContext context) {
        TmfContext savedContext = context.clone();
        TmfEvent event = this.parseEvent(context);
        if (event != null) {
            this.updateIndex((ITmfContext)savedContext, savedContext.getRank(), event.getTimestamp());
            context.updateRank(1);
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TmfEvent parseEvent(TmfContext tmfContext) {
        if (!(tmfContext instanceof CustomTxtTraceContext)) {
            return null;
        }
        CustomTxtTraceContext context = (CustomTxtTraceContext)tmfContext;
        if (!(context.getLocation().getLocation() instanceof Long)) {
            return null;
        }
        CustomTxtEvent event = this.parseFirstLine(context);
        HashMap<CustomTxtTraceDefinition.InputLine, Integer> countMap = new HashMap<CustomTxtTraceDefinition.InputLine, Integer>();
        CustomTxtTraceDefinition.InputLine currentInput = null;
        if (context.inputLine.childrenInputs != null && context.inputLine.childrenInputs.size() > 0) {
            currentInput = context.inputLine.childrenInputs.get(0);
            countMap.put(currentInput, 0);
        }
        RandomAccessFile randomAccessFile = context.raFile;
        synchronized (randomAccessFile) {
            try {
                String line;
                if (context.raFile.getFilePointer() != context.nextLineLocation) {
                    context.raFile.seek(context.nextLineLocation);
                }
                long rawPos = context.raFile.getFilePointer();
                while ((line = context.raFile.readLine()) != null) {
                    boolean processed = false;
                    if (currentInput == null) {
                        for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                            Matcher matcher = input.getPattern().matcher(line);
                            if (!matcher.find()) continue;
                            context.setLocation((ITmfLocation)new TmfLocation((Object)rawPos));
                            context.firstLineMatcher = matcher;
                            context.nextLineLocation = context.raFile.getFilePointer();
                            context.inputLine = input;
                            return event;
                        }
                    } else {
                        Matcher matcher;
                        if ((Integer)countMap.get(currentInput) >= currentInput.getMinCount()) {
                            Matcher matcher2;
                            List<CustomTxtTraceDefinition.InputLine> nextInputs = currentInput.getNextInputs(countMap);
                            if (nextInputs.size() == 0 || nextInputs.get(nextInputs.size() - 1).getMinCount() == 0) {
                                for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                                    matcher2 = input.getPattern().matcher(line);
                                    if (!matcher2.find()) continue;
                                    context.setLocation((ITmfLocation)new TmfLocation((Object)rawPos));
                                    context.firstLineMatcher = matcher2;
                                    context.nextLineLocation = context.raFile.getFilePointer();
                                    context.inputLine = input;
                                    return event;
                                }
                            }
                            for (CustomTxtTraceDefinition.InputLine input : nextInputs) {
                                CustomTxtTraceDefinition.InputLine inputLine;
                                matcher2 = input.getPattern().matcher(line);
                                if (!matcher2.find()) continue;
                                event.processGroups(input, matcher2);
                                currentInput = input;
                                if (countMap.get(currentInput) == null) {
                                    countMap.put(currentInput, 1);
                                } else {
                                    countMap.put(currentInput, countMap.get(currentInput) + 1);
                                }
                                Iterator<CustomTxtTraceDefinition.InputLine> iter = countMap.keySet().iterator();
                                while (iter.hasNext()) {
                                    inputLine = iter.next();
                                    if (inputLine.level <= currentInput.level) continue;
                                    iter.remove();
                                }
                                if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                    currentInput = currentInput.childrenInputs.get(0);
                                    countMap.put(currentInput, 0);
                                } else if (countMap.get(currentInput) >= currentInput.getMaxCount()) {
                                    if (currentInput.getNextInputs(countMap).size() > 0) {
                                        if (countMap.get(currentInput = currentInput.getNextInputs(countMap).get(0)) == null) {
                                            countMap.put(currentInput, 0);
                                        }
                                        iter = countMap.keySet().iterator();
                                        while (iter.hasNext()) {
                                            inputLine = iter.next();
                                            if (inputLine.level <= currentInput.level) continue;
                                            iter.remove();
                                        }
                                    } else {
                                        currentInput = null;
                                    }
                                }
                                processed = true;
                                break;
                            }
                        }
                        if (!processed && (matcher = currentInput.getPattern().matcher(line)).find()) {
                            event.processGroups(currentInput, matcher);
                            countMap.put(currentInput, countMap.get(currentInput) + 1);
                            if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                currentInput = currentInput.childrenInputs.get(0);
                                countMap.put(currentInput, 0);
                            } else if (countMap.get(currentInput) >= currentInput.getMaxCount()) {
                                if (currentInput.getNextInputs(countMap).size() > 0) {
                                    if (countMap.get(currentInput = currentInput.getNextInputs(countMap).get(0)) == null) {
                                        countMap.put(currentInput, 0);
                                    }
                                    Iterator<CustomTxtTraceDefinition.InputLine> iter = countMap.keySet().iterator();
                                    while (iter.hasNext()) {
                                        CustomTxtTraceDefinition.InputLine inputLine = iter.next();
                                        if (inputLine.level <= currentInput.level) continue;
                                        iter.remove();
                                    }
                                } else {
                                    currentInput = null;
                                }
                            }
                        }
                    }
                    rawPos = context.raFile.getFilePointer();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : countMap.entrySet()) {
            if ((Integer)entry.getValue() >= ((CustomTxtTraceDefinition.InputLine)entry.getKey()).getMinCount()) continue;
            event = null;
        }
        context.setLocation((ITmfLocation)new TmfLocation(null));
        return event;
    }

    public List<CustomTxtTraceDefinition.InputLine> getFirstLines() {
        return this.fDefinition.inputs;
    }

    public CustomTxtEvent parseFirstLine(CustomTxtTraceContext context) {
        CustomTxtEvent event = new CustomTxtEvent(this.fDefinition, TmfTimestamp.Zero, new TmfEventSource((Object)""), new TmfEventType(this.fDefinition.definitionName, new String[0]), new TmfEventReference((Object)""));
        event.processGroups(context.inputLine, context.firstLineMatcher);
        return event;
    }

    public void parseNextLine(CustomTxtEvent event, String line, CustomTxtTraceDefinition.InputLine input) {
        Pattern pattern = input.getPattern();
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            event.processGroups(input, matcher);
            return;
        }
    }

    public CustomTraceDefinition getDefinition() {
        return this.fDefinition;
    }
}

