/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets;

import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.ui.widgets.ColumnData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TmfVirtualTable
extends Composite {
    private Table fTable;
    private int fTableRows = 0;
    private boolean fPartialRowVisible = false;
    private int fSelectedRow = 0;
    private int fTableTopEventRank = 0;
    private int fSelectedEventRank = 0;
    private TableItem[] fSelectedItems = new TableItem[1];
    private int fTableItemCount = 0;
    private TableItem[] fTableItems;
    private Slider fSlider;

    public TmfVirtualTable(Composite parent, int style) {
        super(parent, style | 0x800);
        this.createTable(style);
        this.createSlider();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GridData tableGridData = new GridData(4, 4, true, true);
        this.fTable.setLayoutData((Object)tableGridData);
        GridData sliderGridData = new GridData(4, 4, false, true);
        this.fSlider.setLayoutData((Object)sliderGridData);
        this.fTable.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent event) {
                TmfVirtualTable tmfVirtualTable = TmfVirtualTable.this;
                tmfVirtualTable.fTableTopEventRank = tmfVirtualTable.fTableTopEventRank - event.count;
                if (TmfVirtualTable.this.fTableTopEventRank < 0) {
                    TmfVirtualTable.this.fTableTopEventRank = 0;
                }
                int latestFirstRowOffset = TmfVirtualTable.this.fTableItemCount - TmfVirtualTable.this.fTableRows;
                if (TmfVirtualTable.this.fTableTopEventRank > latestFirstRowOffset) {
                    TmfVirtualTable.this.fTableTopEventRank = latestFirstRowOffset;
                }
                TmfVirtualTable.this.fSlider.setSelection(TmfVirtualTable.this.fTableTopEventRank);
                TmfVirtualTable.this.refreshTable();
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                TmfVirtualTable.this.resize();
            }
        });
        this.refresh();
    }

    private void createTable(int style) {
        int tableStyle = 65556;
        this.fTable = new Table((Composite)this, tableStyle);
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TmfVirtualTable.this.handleTableSelection();
            }
        });
        this.fTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                TmfVirtualTable.this.handleTableKeyEvent(event);
            }

            public void keyReleased(KeyEvent event) {
            }
        });
    }

    private void handleTableSelection() {
        this.fSelectedRow = this.fTable.getSelectionIndices()[0];
        this.fSelectedEventRank = this.fTableTopEventRank + this.fSelectedRow;
        this.fSelectedItems[0] = this.fTable.getSelection()[0];
    }

    private void handleTableKeyEvent(KeyEvent event) {
        int lastEventRank = this.fTableItemCount - 1;
        int lastPageTopEntryRank = this.fTableItemCount - this.fTableRows;
        int lastRowIndex = (this.fTableItemCount < this.fTableRows ? this.fTableItemCount : this.fTableRows) - 1;
        int numberOfFullyVisibleRows = this.fTableRows - (this.fPartialRowVisible ? 1 : 0);
        boolean needsRefresh = false;
        event.doit = false;
        switch (event.keyCode) {
            case 0x1000002: {
                if (this.fSelectedEventRank >= lastEventRank) break;
                ++this.fSelectedEventRank;
                this.fSelectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
                if (this.fSelectedRow <= lastRowIndex) break;
                ++this.fTableTopEventRank;
                this.fSelectedRow = lastRowIndex;
                needsRefresh = true;
                break;
            }
            case 0x1000001: {
                if (this.fSelectedEventRank <= 0) break;
                --this.fSelectedEventRank;
                this.fSelectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
                if (this.fSelectedRow >= 0) break;
                --this.fTableTopEventRank;
                this.fSelectedRow = 0;
                needsRefresh = true;
                break;
            }
            case 0x1000008: {
                this.fTableTopEventRank = lastPageTopEntryRank;
                this.fSelectedEventRank = lastEventRank;
                this.fSelectedRow = lastRowIndex;
                needsRefresh = true;
                break;
            }
            case 0x1000007: {
                this.fSelectedEventRank = 0;
                this.fSelectedRow = 0;
                this.fTableTopEventRank = 0;
                needsRefresh = true;
                break;
            }
            case 0x1000006: {
                if (this.fSelectedEventRank >= lastEventRank) break;
                this.fSelectedEventRank += numberOfFullyVisibleRows;
                if (this.fSelectedEventRank > lastEventRank) {
                    this.fSelectedEventRank = lastEventRank;
                }
                this.fSelectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
                if (this.fSelectedRow <= numberOfFullyVisibleRows - 1) break;
                this.fTableTopEventRank += numberOfFullyVisibleRows;
                if (this.fTableTopEventRank > lastPageTopEntryRank) {
                    this.fTableTopEventRank = lastPageTopEntryRank;
                }
                this.fSelectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
                needsRefresh = true;
                break;
            }
            case 0x1000005: {
                if (this.fSelectedEventRank <= 0) break;
                this.fSelectedEventRank -= numberOfFullyVisibleRows;
                if (this.fSelectedEventRank < 0) {
                    this.fSelectedEventRank = 0;
                }
                this.fSelectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
                if (this.fSelectedRow >= 0) break;
                this.fSelectedRow = 0;
                this.fTableTopEventRank -= numberOfFullyVisibleRows;
                if (this.fTableTopEventRank < 0) {
                    this.fTableTopEventRank = 0;
                }
                this.fSelectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
                needsRefresh = true;
            }
        }
        if (needsRefresh) {
            int i = 0;
            while (i < this.fTableItems.length) {
                this.setDataItem(i, this.fTableItems[i]);
                ++i;
            }
        }
        this.fSlider.setSelection(this.fSelectedEventRank);
        this.fTable.setSelection(this.fSelectedRow);
        this.fTable.showSelection();
        this.fSelectedItems[0] = this.fTable.getSelection()[0];
        TmfTimestamp ts = (TmfTimestamp)this.fSelectedItems[0].getData();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeSynchSignal((Object)this, ts));
    }

    private void setDataItem(int index, TableItem item) {
        if (index != -1) {
            Event event = new Event();
            event.item = item;
            event.index = index + this.fTableTopEventRank;
            event.doit = true;
            this.notifyListeners(36, event);
        }
    }

    private void createSlider() {
        this.fSlider = new Slider((Composite)this, 512);
        this.fSlider.setMinimum(0);
        this.fSlider.setMaximum(0);
        this.fSlider.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 0: 
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000005: 
                    case 0x1000006: 
                    case 0x1000007: 
                    case 0x1000008: {
                        TmfVirtualTable.this.fTableTopEventRank = TmfVirtualTable.this.fSlider.getSelection();
                        TmfVirtualTable.this.refreshTable();
                    }
                }
            }
        });
    }

    public void setHeaderVisible(boolean b) {
        this.fTable.setHeaderVisible(b);
    }

    public void setLinesVisible(boolean b) {
        this.fTable.setLinesVisible(b);
    }

    public TableItem[] getSelection() {
        return this.fSelectedItems;
    }

    public void addSelectionListener(SelectionAdapter sa) {
        this.fTable.addSelectionListener((SelectionListener)sa);
    }

    public void setItemCount(int nbItems) {
        if ((nbItems = Math.max(0, nbItems)) != this.fTableItemCount) {
            this.fTableItemCount = nbItems;
            this.fSlider.setMaximum(nbItems);
            this.resize();
        }
    }

    public int getItemHeight() {
        return this.fTable.getItemHeight();
    }

    public int getTopIndex() {
        return this.fTableTopEventRank;
    }

    public void setTopIndex(int i) {
        this.fSlider.setSelection(i);
    }

    public int indexOf(TableItem ti) {
        return this.fTable.indexOf(ti) + this.getTopIndex();
    }

    public TableColumn[] getColumns() {
        return this.fTable.getColumns();
    }

    private void resize() {
        int delta;
        int tableHeight = this.fTable.getClientArea().height - this.fTable.getHeaderHeight();
        if (tableHeight < 0) {
            tableHeight = 0;
        }
        int itemHeight = this.fTable.getItemHeight();
        this.fTableRows = tableHeight / itemHeight;
        this.fPartialRowVisible = false;
        if (this.fTableRows * itemHeight < tableHeight) {
            ++this.fTableRows;
            this.fPartialRowVisible = true;
        }
        if (this.fTableRows > this.fTableItemCount) {
            this.fTableRows = this.fTableItemCount;
        }
        if (this.fTableTopEventRank + this.fTableRows >= this.fTableItemCount) {
            this.fTableTopEventRank = this.fTableItemCount - this.fTableRows;
        }
        if (this.fTableItemCount > 0) {
            this.fSlider.setThumb(this.fTableRows);
        }
        if ((delta = this.fTable.getItemCount() - this.fTableRows) != 0) {
            int i;
            this.fTable.removeAll();
            if (this.fTableItems != null) {
                i = 0;
                while (i < this.fTableItems.length) {
                    if (this.fTableItems[i] != null) {
                        this.fTableItems[i].dispose();
                    }
                    this.fTableItems[i] = null;
                    ++i;
                }
            }
            this.fTableItems = new TableItem[this.fTableRows];
            i = 0;
            while (i < this.fTableItems.length) {
                this.fTableItems[i] = new TableItem(this.fTable, i);
                ++i;
            }
        }
        this.refresh();
    }

    public boolean setFocus() {
        boolean isVisible = this.isVisible();
        if (isVisible) {
            this.fTable.setFocus();
        }
        return isVisible;
    }

    public void refresh() {
        this.refreshTable();
    }

    public void setColumnHeaders(ColumnData[] columnData) {
        int i = 0;
        while (i < columnData.length) {
            TableColumn column = new TableColumn(this.fTable, columnData[i].alignment, i);
            column.setText(columnData[i].header);
            if (columnData[i].width > 0) {
                column.setWidth(columnData[i].width);
            } else {
                column.pack();
            }
            ++i;
        }
    }

    public int removeAll() {
        this.fSlider.setMaximum(0);
        this.fTable.removeAll();
        return 0;
    }

    private void refreshTable() {
        int lastRowOffset = this.fTableTopEventRank + this.fTableRows - 1;
        if (this.fSelectedEventRank >= this.fTableTopEventRank && this.fSelectedEventRank <= lastRowOffset) {
            this.fSelectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
            this.fTable.setSelection(this.fSelectedRow);
        } else {
            this.fTable.deselect(this.fSelectedRow);
        }
        int i = 0;
        while (i < this.fTableRows) {
            this.setDataItem(i, this.fTableItems[i]);
            ++i;
        }
    }

    public void setSelection(int i) {
        if (this.fTableItems != null) {
            i = Math.min(i, this.fTableItemCount);
            i = Math.max(i, 0);
            this.fSlider.setSelection(i);
            this.fSelectedEventRank = i;
            this.fTableTopEventRank = i - this.fTableRows / 2;
            if (this.fTableTopEventRank < 0) {
                this.fTableTopEventRank = 0;
            }
            this.fSelectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
            this.refreshTable();
        }
    }
}

