/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.component;

import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.eclipse.linuxtools.tmf.Tracer;
import org.eclipse.linuxtools.tmf.component.ITmfDataProvider;
import org.eclipse.linuxtools.tmf.component.TmfComponent;
import org.eclipse.linuxtools.tmf.component.TmfProviderManager;
import org.eclipse.linuxtools.tmf.component.TmfThread;
import org.eclipse.linuxtools.tmf.event.TmfData;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.TmfCoalescedDataRequest;
import org.eclipse.linuxtools.tmf.request.TmfDataRequest;
import org.eclipse.linuxtools.tmf.request.TmfRequestExecutor;
import org.eclipse.linuxtools.tmf.signal.TmfEndSynchSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.signal.TmfStartSynchSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfContext;

public abstract class TmfDataProvider<T extends TmfData>
extends TmfComponent
implements ITmfDataProvider<T> {
    protected final Class<T> fType;
    protected final boolean fLogData;
    protected final boolean fLogError;
    public static final int DEFAULT_BLOCK_SIZE = 50000;
    public static final int DEFAULT_QUEUE_SIZE = 1000;
    protected final int fQueueSize;
    protected final BlockingQueue<T> fDataQueue;
    protected final TmfRequestExecutor fExecutor;
    private int fSignalDepth = 0;
    private final Object fLock = new Object();
    private int fRequestPendingCounter = 0;
    protected Vector<TmfCoalescedDataRequest<T>> fPendingCoalescedRequests = new Vector();

    public TmfDataProvider(String name, Class<T> type) {
        this(name, type, 1000);
    }

    protected TmfDataProvider(String name, Class<T> type, int queueSize) {
        super(name);
        this.fType = type;
        this.fQueueSize = queueSize;
        this.fDataQueue = this.fQueueSize > 1 ? new LinkedBlockingQueue(this.fQueueSize) : new SynchronousQueue();
        this.fExecutor = new TmfRequestExecutor();
        this.fSignalDepth = 0;
        this.fLogData = Tracer.isEventTraced();
        this.fLogError = Tracer.isErrorTraced();
        TmfProviderManager.register(this.fType, this);
    }

    public TmfDataProvider(TmfDataProvider<T> other) {
        super(other);
        this.fType = other.fType;
        this.fQueueSize = other.fQueueSize;
        this.fDataQueue = this.fQueueSize > 1 ? new LinkedBlockingQueue(this.fQueueSize) : new SynchronousQueue();
        this.fExecutor = new TmfRequestExecutor();
        this.fSignalDepth = 0;
        this.fLogData = Tracer.isEventTraced();
        this.fLogError = Tracer.isErrorTraced();
    }

    @Override
    public void dispose() {
        TmfProviderManager.deregister(this.fType, this);
        this.fExecutor.stop();
        super.dispose();
    }

    public int getQueueSize() {
        return this.fQueueSize;
    }

    public Class<?> getType() {
        return this.fType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(ITmfDataRequest<T> request) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fSignalDepth > 0) {
                this.coalesceDataRequest(request);
            } else {
                this.dispatchRequest(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireRequest() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fRequestPendingCounter > 0) {
                return;
            }
            if (this.fPendingCoalescedRequests.size() > 0) {
                for (TmfDataRequest tmfDataRequest : this.fPendingCoalescedRequests) {
                    this.dispatchRequest(tmfDataRequest);
                }
                this.fPendingCoalescedRequests.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPendingRequest(boolean isIncrement) {
        Object object = this.fLock;
        synchronized (object) {
            if (isIncrement) {
                if (this.fSignalDepth > 0) {
                    ++this.fRequestPendingCounter;
                }
            } else {
                if (this.fRequestPendingCounter > 0) {
                    --this.fRequestPendingCounter;
                }
                if (this.fRequestPendingCounter == 0) {
                    this.fireRequest();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newCoalescedDataRequest(ITmfDataRequest<T> request) {
        Object object = this.fLock;
        synchronized (object) {
            TmfCoalescedDataRequest<T> coalescedRequest = new TmfCoalescedDataRequest<T>(this.fType, request.getIndex(), request.getNbRequested(), request.getExecType());
            coalescedRequest.addRequest(request);
            if (Tracer.isRequestTraced()) {
                Tracer.traceRequest(request, "coalesced with " + coalescedRequest.getRequestId());
                Tracer.traceRequest(coalescedRequest, "added " + request.getRequestId());
            }
            this.fPendingCoalescedRequests.add(coalescedRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void coalesceDataRequest(ITmfDataRequest<T> request) {
        Object object = this.fLock;
        synchronized (object) {
            for (TmfCoalescedDataRequest<T> req : this.fPendingCoalescedRequests) {
                if (!req.isCompatible(request)) continue;
                req.addRequest(request);
                if (Tracer.isRequestTraced()) {
                    Tracer.traceRequest(request, "coalesced with " + req.getRequestId());
                    Tracer.traceRequest(req, "added " + request.getRequestId());
                }
                return;
            }
            this.newCoalescedDataRequest(request);
        }
    }

    private void dispatchRequest(ITmfDataRequest<T> request) {
        if (request.getExecType() == ITmfDataRequest.ExecutionType.FOREGROUND) {
            this.queueRequest(request);
        } else {
            this.queueBackgroundRequest(request, 50000, true);
        }
    }

    protected void queueRequest(final ITmfDataRequest<T> request) {
        if (this.fExecutor.isShutdown()) {
            request.cancel();
            return;
        }
        final TmfDataProvider provider = this;
        TmfThread thread = new TmfThread(request.getExecType()){

            @Override
            public void run() {
                if (Tracer.isRequestTraced()) {
                    Tracer.traceRequest(request, "started");
                }
                request.start();
                int nbRequested = request.getNbRequested();
                int nbRead = 0;
                ITmfContext context = TmfDataProvider.this.armRequest(request);
                if (context == null) {
                    request.cancel();
                    return;
                }
                try {
                    if (Tracer.isRequestTraced()) {
                        Tracer.trace("Request #" + request.getRequestId() + " is being serviced by " + provider.getName());
                    }
                    Object data = TmfDataProvider.this.getNext(context);
                    if (Tracer.isRequestTraced()) {
                        Tracer.trace("Request #" + request.getRequestId() + " read first event");
                    }
                    while (data != null && !TmfDataProvider.this.isCompleted(request, data, nbRead)) {
                        if (TmfDataProvider.this.fLogData) {
                            Tracer.traceEvent(provider, request, data);
                        }
                        request.handleData(data);
                        if (++nbRead >= nbRequested) continue;
                        data = TmfDataProvider.this.getNext(context);
                        if (!Tracer.isRequestTraced() || data != null && !((TmfData)data).isNullRef()) continue;
                        Tracer.trace("Request #" + request.getRequestId() + " end of data");
                    }
                    if (request.isCancelled()) {
                        request.cancel();
                    } else {
                        request.done();
                    }
                    if (Tracer.isRequestTraced()) {
                        Tracer.traceRequest(request, "completed");
                    }
                }
                catch (Exception exception) {
                    if (Tracer.isRequestTraced()) {
                        Tracer.traceRequest(request, "exception (failed)");
                    }
                    request.fail();
                }
            }
        };
        this.fExecutor.execute(thread);
        if (Tracer.isRequestTraced()) {
            Tracer.traceRequest(request, "queued");
        }
    }

    protected void queueBackgroundRequest(ITmfDataRequest<T> request, int blockSize, boolean indexing) {
        this.queueRequest(request);
    }

    public abstract ITmfContext armRequest(ITmfDataRequest<T> var1);

    public abstract T getNext(ITmfContext var1);

    public boolean isCompleted(ITmfDataRequest<T> request, T data, int nbRead) {
        return request.isCompleted() || nbRead >= request.getNbRequested() || ((TmfData)data).isNullRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void startSynch(TmfStartSynchSignal signal) {
        Object object = this.fLock;
        synchronized (object) {
            ++this.fSignalDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void endSynch(TmfEndSynchSignal signal) {
        Object object = this.fLock;
        synchronized (object) {
            --this.fSignalDepth;
            if (this.fSignalDepth == 0) {
                this.fireRequest();
            }
        }
    }
}

