/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.event;

import org.eclipse.linuxtools.tmf.event.TmfData;
import org.eclipse.linuxtools.tmf.event.TmfEventContent;
import org.eclipse.linuxtools.tmf.event.TmfEventReference;
import org.eclipse.linuxtools.tmf.event.TmfEventSource;
import org.eclipse.linuxtools.tmf.event.TmfEventType;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;

public class TmfEvent
extends TmfData
implements Cloneable {
    public static final TmfEvent NullEvent = new TmfEvent();
    protected TmfTimestamp fEffectiveTimestamp;
    protected TmfTimestamp fOriginalTimestamp;
    protected TmfEventSource fSource;
    protected TmfEventType fType;
    protected TmfEventReference fReference;
    protected TmfEventContent fContent;

    public TmfEvent(TmfTimestamp originalTS, TmfTimestamp effectiveTS, TmfEventSource source, TmfEventType type, TmfEventReference reference) {
        this.fOriginalTimestamp = originalTS;
        this.fEffectiveTimestamp = effectiveTS;
        this.fSource = source;
        this.fType = type;
        this.fReference = reference;
    }

    public TmfEvent(TmfTimestamp timestamp, TmfEventSource source, TmfEventType type, TmfEventReference reference) {
        this(timestamp, timestamp, source, type, reference);
    }

    public TmfEvent(TmfEvent other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.fOriginalTimestamp = new TmfTimestamp(other.fOriginalTimestamp);
        this.fEffectiveTimestamp = new TmfTimestamp(other.fEffectiveTimestamp);
        this.fSource = new TmfEventSource(other.fSource);
        this.fType = new TmfEventType(other.fType);
        this.fContent = new TmfEventContent(other.fContent);
        this.fReference = new TmfEventReference(other.fReference);
    }

    private TmfEvent() {
    }

    @Override
    public boolean isNullRef() {
        return this == NullEvent;
    }

    public TmfTimestamp getTimestamp() {
        return this.fEffectiveTimestamp;
    }

    public TmfTimestamp getOriginalTimestamp() {
        return this.fOriginalTimestamp;
    }

    public TmfEventSource getSource() {
        return this.fSource;
    }

    public TmfEventType getType() {
        return this.fType;
    }

    public TmfEventContent getContent() {
        return this.fContent;
    }

    public TmfEventReference getReference() {
        return this.fReference;
    }

    public void setContent(TmfEventContent content) {
        this.fContent = content;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.fSource.hashCode();
        result = 37 * result + this.fType.hashCode();
        result = 37 * result + this.fEffectiveTimestamp.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TmfEvent)) {
            return false;
        }
        TmfEvent o = (TmfEvent)other;
        return this.fEffectiveTimestamp.equals(o.fEffectiveTimestamp) && this.fSource.equals(o.fSource) && this.fType.equals(o.fType) && this.fContent.equals(o.fContent);
    }

    public String toString() {
        return "[TmfEvent(" + this.fEffectiveTimestamp + "," + this.fSource + "," + this.fType + "," + this.fContent + ")]";
    }

    public TmfEvent clone() {
        TmfEvent clone = null;
        try {
            clone = (TmfEvent)super.clone();
            clone.fOriginalTimestamp = this.fOriginalTimestamp.clone();
            clone.fEffectiveTimestamp = this.fEffectiveTimestamp.clone();
            clone.fSource = this.fSource.clone();
            clone.fType = this.fType.clone();
            clone.fReference = this.fReference.clone();
            clone.fContent = this.fContent.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }
}

