/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.request;

import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.request.TmfCoalescedDataRequest;
import org.eclipse.linuxtools.tmf.request.TmfDataRequest;
import org.eclipse.linuxtools.tmf.request.TmfEventRequest;

public class TmfCoalescedEventRequest<T extends TmfEvent>
extends TmfCoalescedDataRequest<T>
implements ITmfEventRequest<T> {
    private TmfTimeRange fRange;

    public TmfCoalescedEventRequest(Class<T> dataType) {
        this(dataType, TmfTimeRange.Eternity, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, ITmfDataRequest.ExecutionType execType) {
        this(dataType, TmfTimeRange.Eternity, Integer.MAX_VALUE, 1000, execType);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range) {
        this(dataType, range, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range, ITmfDataRequest.ExecutionType execType) {
        this(dataType, range, Integer.MAX_VALUE, 1000, execType);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested) {
        this(dataType, range, nbRequested, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, ITmfDataRequest.ExecutionType execType) {
        this(dataType, range, nbRequested, 1000, execType);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, int blockSize) {
        super(dataType, 0, nbRequested, blockSize, ITmfDataRequest.ExecutionType.FOREGROUND);
        this.fRange = range;
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType execType) {
        super(dataType, 0, nbRequested, blockSize, execType);
        this.fRange = range;
    }

    @Override
    public boolean isCompatible(ITmfDataRequest<T> request) {
        if (request instanceof ITmfEventRequest) {
            boolean ok = this.getNbRequested() == request.getNbRequested();
            if (ok &= this.getExecType() == request.getExecType()) {
                TmfTimestamp startTime = ((ITmfEventRequest)request).getRange().getStartTime();
                TmfTimestamp endTime = ((ITmfEventRequest)request).getRange().getEndTime();
                if (!this.fRange.contains(startTime)) {
                    this.fRange = new TmfTimeRange(startTime, this.fRange.getEndTime());
                }
                if (!this.fRange.contains(endTime)) {
                    this.fRange = new TmfTimeRange(this.fRange.getStartTime(), endTime);
                }
            }
            return ok;
        }
        return false;
    }

    @Override
    public void handleData(T data) {
        super.handleData(data);
        for (ITmfDataRequest request : this.fRequests) {
            TmfDataRequest req;
            if (data == null) {
                request.handleData(null);
                continue;
            }
            if (request instanceof TmfEventRequest) {
                req = (TmfEventRequest)request;
                if (req.isCompleted()) continue;
                TmfTimestamp ts = ((TmfEvent)data).getTimestamp();
                if (!((TmfEventRequest)req).getRange().contains(ts)) continue;
                req.handleData(data);
                continue;
            }
            req = (TmfDataRequest)request;
            if (req.isCompleted()) continue;
            req.handleData(data);
        }
    }

    @Override
    public TmfTimeRange getRange() {
        return this.fRange;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TmfCoalescedEventRequest) {
            TmfCoalescedEventRequest request = (TmfCoalescedEventRequest)other;
            return request.getDataType() == this.getDataType() && request.getIndex() == this.getIndex() && request.getNbRequested() == this.getNbRequested() && request.getRange().equals(this.getRange());
        }
        if (other instanceof TmfCoalescedDataRequest) {
            return super.equals(other);
        }
        return false;
    }

    @Override
    public String toString() {
        return "[TmfCoalescedEventRequest(" + this.getRequestId() + "," + this.getDataType().getSimpleName() + "," + this.getRange() + "," + this.getNbRequested() + ")]";
    }
}

