/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.request;

import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.request.TmfDataRequest;

public abstract class TmfEventRequest<T extends TmfEvent>
extends TmfDataRequest<T>
implements ITmfEventRequest<T> {
    private final TmfTimeRange fRange;

    public TmfEventRequest(Class<T> dataType) {
        this(dataType, TmfTimeRange.Eternity, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<T> dataType, ITmfDataRequest.ExecutionType execType) {
        this(dataType, TmfTimeRange.Eternity, Integer.MAX_VALUE, 1000, execType);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range) {
        this(dataType, range, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, ITmfDataRequest.ExecutionType execType) {
        this(dataType, range, Integer.MAX_VALUE, 1000, execType);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested) {
        this(dataType, range, nbRequested, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, ITmfDataRequest.ExecutionType execType) {
        this(dataType, range, nbRequested, 1000, execType);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, int blockSize) {
        super(dataType, 0, nbRequested, blockSize, ITmfDataRequest.ExecutionType.FOREGROUND);
        this.fRange = range;
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType execType) {
        super(dataType, 0, nbRequested, blockSize, execType);
        this.fRange = range;
    }

    @Override
    public TmfTimeRange getRange() {
        return this.fRange;
    }

    @Override
    public int hashCode() {
        return this.getRequestId();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TmfEventRequest) {
            TmfEventRequest request = (TmfEventRequest)other;
            return super.equals(other) && request.fRange.equals(this.fRange);
        }
        return false;
    }

    @Override
    public String toString() {
        return "[TmfEventRequest(" + this.getRequestId() + "," + this.getDataType().getSimpleName() + "," + this.getRange() + "," + this.getNbRequested() + ")]";
    }
}

