/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.trace;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.linuxtools.tmf.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.trace.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.trace.TmfContext;

public abstract class TmfTrace<T extends TmfEvent>
extends TmfEventProvider<T>
implements ITmfTrace,
Cloneable {
    public static final int DEFAULT_INDEX_PAGE_SIZE = 50000;
    private final String fPath;
    protected int fIndexPageSize;
    protected Vector<TmfCheckpoint> fCheckpoints = new Vector();
    protected long fNbEvents = 0L;
    private TmfTimestamp fStartTime = TmfTimestamp.BigCrunch;
    private TmfTimestamp fEndTime = TmfTimestamp.BigBang;

    protected TmfTrace(String name, Class<T> type, String path) throws FileNotFoundException {
        this(name, type, path, 50000);
    }

    protected TmfTrace(String name, Class<T> type, String path, int cacheSize) throws FileNotFoundException {
        super(name, type);
        int sep = path.lastIndexOf(File.separator);
        String simpleName = sep >= 0 ? path.substring(sep + 1) : path;
        this.setName(simpleName);
        this.fPath = path;
        this.fIndexPageSize = cacheSize > 0 ? cacheSize : 50000;
    }

    public TmfTrace<T> clone() throws CloneNotSupportedException {
        TmfTrace clone = (TmfTrace)super.clone();
        clone.fCheckpoints = this.fCheckpoints;
        clone.fStartTime = new TmfTimestamp(this.fStartTime);
        clone.fEndTime = new TmfTimestamp(this.fEndTime);
        return clone;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    @Override
    public long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public int getCacheSize() {
        return this.fIndexPageSize;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange(this.fStartTime, this.fEndTime);
    }

    @Override
    public TmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    @Override
    public TmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    public Vector<TmfCheckpoint> getCheckpoints() {
        return (Vector)this.fCheckpoints.clone();
    }

    @Override
    public long getRank(TmfTimestamp timestamp) {
        TmfContext context = this.seekEvent(timestamp);
        return context.getRank();
    }

    protected void setTimeRange(TmfTimeRange range) {
        this.fStartTime = range.getStartTime();
        this.fEndTime = range.getEndTime();
    }

    protected void setStartTime(TmfTimestamp startTime) {
        this.fStartTime = startTime;
    }

    protected void setEndTime(TmfTimestamp endTime) {
        this.fEndTime = endTime;
    }

    @Override
    public ITmfContext armRequest(ITmfDataRequest<T> request) {
        if (request instanceof ITmfEventRequest) {
            return this.seekEvent(((ITmfEventRequest)request).getRange().getStartTime());
        }
        return this.seekEvent(request.getIndex());
    }

    @Override
    public T getNext(ITmfContext context) {
        if (context instanceof TmfContext) {
            return (T)this.getNextEvent((TmfContext)context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TmfContext seekEvent(TmfTimestamp timestamp) {
        ITmfLocation<?> location;
        int index;
        if (timestamp == null) {
            timestamp = TmfTimestamp.BigBang;
        }
        if ((index = Collections.binarySearch(this.fCheckpoints, new TmfCheckpoint(timestamp, null))) < 0) {
            index = Math.max(0, -(index + 2));
        }
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fCheckpoints.size() > 0) {
                if (index >= this.fCheckpoints.size()) {
                    index = this.fCheckpoints.size() - 1;
                }
                location = this.fCheckpoints.elementAt(index).getLocation();
            } else {
                location = null;
            }
        }
        TmfContext context = this.seekLocation(location);
        context.setRank(index * this.fIndexPageSize);
        TmfContext nextEventContext = context.clone();
        TmfEvent event = this.getNextEvent(nextEventContext);
        while (event != null && event.getTimestamp().compareTo(timestamp, false) < 0) {
            context.setLocation(nextEventContext.getLocation().clone());
            context.updateRank(1);
            event = this.getNextEvent(nextEventContext);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TmfContext seekEvent(long rank) {
        ITmfLocation<?> location;
        int index = (int)rank / this.fIndexPageSize;
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fCheckpoints.size() == 0) {
                location = null;
            } else {
                if (index >= this.fCheckpoints.size()) {
                    index = this.fCheckpoints.size() - 1;
                }
                location = this.fCheckpoints.elementAt(index).getLocation();
            }
        }
        TmfContext context = this.seekLocation(location);
        long pos = index * this.fIndexPageSize;
        context.setRank(pos);
        if (pos < rank) {
            TmfEvent event = this.getNextEvent(context);
            while (event != null && ++pos < rank) {
                event = this.getNextEvent(context);
            }
        }
        return context;
    }

    @Override
    public synchronized TmfEvent getNextEvent(TmfContext context) {
        TmfEvent event = this.parseEvent(context);
        if (event != null) {
            this.updateIndex(context, context.getRank(), event.getTimestamp());
            context.setLocation(this.getCurrentLocation());
            context.updateRank(1);
            this.processEvent(event);
        }
        return event;
    }

    protected synchronized void updateIndex(ITmfContext context, long rank, TmfTimestamp timestamp) {
        if (this.fStartTime.compareTo(timestamp, false) > 0) {
            this.fStartTime = timestamp;
        }
        if (this.fEndTime.compareTo(timestamp, false) < 0) {
            this.fEndTime = timestamp;
        }
        if (context.isValidRank()) {
            if (this.fNbEvents <= rank) {
                this.fNbEvents = rank + 1L;
            }
            if (rank % (long)this.fIndexPageSize == 0L) {
                long position = rank / (long)this.fIndexPageSize;
                if ((long)this.fCheckpoints.size() == position) {
                    ITmfLocation<?> location = context.getLocation().clone();
                    this.fCheckpoints.add(new TmfCheckpoint(timestamp.clone(), location));
                }
            }
        }
    }

    protected void processEvent(TmfEvent event) {
    }

    @Override
    public abstract TmfContext seekLocation(ITmfLocation<?> var1);

    public abstract ITmfLocation<?> getCurrentLocation();

    @Override
    public abstract TmfEvent parseEvent(TmfContext var1);

    public String toString() {
        return "[TmfTrace (" + this.getName() + ")]";
    }

    private void indexTrace(boolean waitForCompletion) {
        this.fCheckpoints.clear();
        TmfEventRequest<TmfEvent> request = new TmfEventRequest<TmfEvent>(TmfEvent.class, TmfTimeRange.Eternity, Integer.MAX_VALUE, 1, ITmfDataRequest.ExecutionType.BACKGROUND){
            TmfTimestamp startTime;
            TmfTimestamp lastTime;
            {
                this.startTime = null;
                this.lastTime = null;
            }

            @Override
            public void handleData(TmfEvent event) {
                super.handleData(event);
                if (event != null) {
                    TmfTimestamp ts = event.getTimestamp();
                    if (this.startTime == null) {
                        this.startTime = new TmfTimestamp(ts);
                    }
                    this.lastTime = new TmfTimestamp(ts);
                    if (this.getNbRead() % 50000 == 0) {
                        this.updateTrace();
                    }
                }
            }

            @Override
            public void handleSuccess() {
                this.updateTrace();
            }

            private void updateTrace() {
                int nbRead = this.getNbRead();
                if (nbRead != 0) {
                    TmfTrace.this.fStartTime = this.startTime;
                    TmfTrace.this.fEndTime = this.lastTime;
                    TmfTrace.this.fNbEvents = nbRead;
                    TmfTrace.this.notifyListeners();
                }
            }
        };
        this.sendRequest(request);
        if (waitForCompletion) {
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void indexTraceOld(boolean waitForCompletion) {
        this.fCheckpoints.clear();
        TmfEventRequest<TmfEvent> request = new TmfEventRequest<TmfEvent>(TmfEvent.class, TmfTimeRange.Eternity, Integer.MAX_VALUE, 1, ITmfDataRequest.ExecutionType.BACKGROUND){
            TmfTimestamp startTime;
            TmfTimestamp lastTime;
            {
                this.startTime = null;
                this.lastTime = null;
            }

            @Override
            public void handleData(TmfEvent event) {
                super.handleData(event);
                if (event != null) {
                    TmfTimestamp ts = event.getTimestamp();
                    if (this.startTime == null) {
                        this.startTime = new TmfTimestamp(ts);
                        TmfTrace.this.fStartTime = this.startTime;
                    }
                    this.lastTime = new TmfTimestamp(ts);
                    if (this.getNbRead() % TmfTrace.this.fIndexPageSize == 0) {
                        this.updateTraceData();
                    }
                }
            }

            @Override
            public void handleSuccess() {
                this.updateTraceData();
            }

            private void updateTraceData() {
                int nbRead = this.getNbRead();
                if (nbRead != 0) {
                    TmfTrace.this.fEndTime = new TmfTimestamp(this.lastTime);
                    TmfTrace.this.fNbEvents = nbRead;
                    TmfTrace.this.notifyListeners();
                }
            }
        };
        this.sendRequest(request);
        if (waitForCompletion) {
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void notifyListeners() {
        this.broadcast(new TmfTraceUpdatedSignal(this, this, new TmfTimeRange(this.fStartTime, this.fEndTime)));
    }

    @TmfSignalHandler
    public void handleTraceOpen(TmfTraceOpenedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (trace == this) {
            this.indexTrace(false);
        }
    }

    @Override
    protected void queueBackgroundRequest(ITmfDataRequest<T> request, int blockSize, boolean adjust) {
        super.queueBackgroundRequest(request, this.fIndexPageSize, true);
    }
}

