/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindPlugin;

public class ValgrindCommand {
    protected static final String WHICH_CMD = "which";
    protected static final String VALGRIND_CMD = "valgrind";
    protected Process process;
    protected String[] args;

    public String whichValgrind() throws IOException {
        String ret;
        String valgrindPreferedPath = ValgrindPlugin.getDefault().getPreferenceStore().getString("VALGRIND_PATH");
        if (valgrindPreferedPath.equals("")) {
            StringBuffer out = new StringBuffer();
            Process p = Runtime.getRuntime().exec("which valgrind");
            this.readIntoBuffer(out, p);
            ret = out.toString().trim();
        } else {
            ret = valgrindPreferedPath;
        }
        return ret;
    }

    public String whichVersion(String whichValgrind) throws IOException {
        StringBuffer out = new StringBuffer();
        Process p = Runtime.getRuntime().exec(new String[]{whichValgrind, "--version"});
        this.readIntoBuffer(out, p);
        return out.toString().trim();
    }

    public void execute(String[] commandArray, Object env, File wd, String exeFile, boolean usePty) throws IOException {
        this.args = commandArray;
        try {
            this.process = this.startProcess(commandArray, env, wd, exeFile, usePty);
        }
        catch (IOException e) {
            if (this.process != null) {
                this.process.destroy();
            }
            throw e;
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public String getCommandLine() {
        StringBuffer ret = new StringBuffer();
        String[] stringArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            ret.append(String.valueOf(arg) + " ");
            ++n2;
        }
        return ret.toString().trim();
    }

    protected Process startProcess(String[] commandArray, Object env, File workDir, String binPath, boolean usePty) throws IOException {
        if (workDir == null) {
            return ProcessFactory.getFactory().exec(commandArray, (String[])env);
        }
        if (PTY.isSupported() && usePty) {
            return ProcessFactory.getFactory().exec(commandArray, (String[])env, workDir, new PTY());
        }
        return ProcessFactory.getFactory().exec(commandArray, (String[])env, workDir);
    }

    protected void readIntoBuffer(StringBuffer out, Process p) throws IOException {
        try {
            int ch;
            boolean success = p.waitFor() == 0;
            InputStream in = success ? p.getInputStream() : p.getErrorStream();
            while ((ch = in.read()) != -1) {
                out.append((char)ch);
            }
            if (!success) {
                throw new IOException(out.toString());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

