/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.valgrind.launch.Messages;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindLaunchPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ValgrindExportWizardPage
extends WizardPage
implements IWizardPage {
    protected IPath outputPath;
    protected CheckboxTableViewer viewer;
    protected Text destText;
    protected Button selectAllButton;
    protected Button deselectAllButton;

    protected ValgrindExportWizardPage(String pageName) {
        super(pageName);
    }

    protected ValgrindExportWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(1808));
        IPath logPath = null;
        ILaunchConfiguration config = this.getPlugin().getCurrentLaunchConfiguration();
        if (config != null && config.exists()) {
            try {
                String strpath = config.getAttribute("org.eclipse.linuxtools.valgrind.launch.OUTPUT_DIR", null);
                if (strpath != null) {
                    logPath = Path.fromPortableString((String)strpath);
                }
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        Label selectFilesLabel = new Label(top, 0);
        selectFilesLabel.setText(Messages.getString("ValgrindExportWizardPage.Viewer_label"));
        this.viewer = CheckboxTableViewer.newCheckList((Composite)top, (int)2048);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((File)element).getName();
            }

            public Image getImage(Object element) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
        });
        Composite selectAllNoneTop = new Composite(top, 0);
        selectAllNoneTop.setLayout((Layout)new GridLayout(2, true));
        selectAllNoneTop.setLayoutData((Object)new GridData(131072, -1, false, false));
        this.selectAllButton = new Button(selectAllNoneTop, 0);
        this.selectAllButton.setLayoutData((Object)new GridData(768));
        this.selectAllButton.setText(Messages.getString("ValgrindExportWizardPage.Select_all"));
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValgrindExportWizardPage.this.viewer.setAllChecked(true);
            }
        });
        this.deselectAllButton = new Button(selectAllNoneTop, 0);
        this.deselectAllButton.setLayoutData((Object)new GridData(768));
        this.deselectAllButton.setText(Messages.getString("ValgrindExportWizardPage.Deselect_all"));
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValgrindExportWizardPage.this.viewer.setAllChecked(false);
            }
        });
        this.createDestinationGroup(top);
        if (logPath != null) {
            File[] logs = logPath.toFile().listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isFile();
                }
            });
            this.viewer.setInput((Object)logs);
            this.viewer.setAllChecked(true);
        }
        this.setPageComplete(this.isValid());
        this.setControl((Control)top);
    }

    public IPath getOutputPath() {
        return this.outputPath;
    }

    public File[] getSelectedFiles() {
        Object[] selected = this.viewer.getCheckedElements();
        File[] files = new File[selected.length];
        System.arraycopy(selected, 0, files, 0, selected.length);
        return files;
    }

    private void createDestinationGroup(Composite top) {
        Group destGroup = new Group(top, 8);
        destGroup.setText(Messages.getString("ValgrindExportWizardPage.Destination_group"));
        destGroup.setLayout((Layout)new GridLayout(2, false));
        destGroup.setLayoutData((Object)new GridData(768));
        this.destText = new Text((Composite)destGroup, 2048);
        this.destText.setLayoutData((Object)new GridData(768));
        this.destText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ValgrindExportWizardPage.this.setPageComplete(ValgrindExportWizardPage.this.isValid());
            }
        });
        Button browseButton = new Button((Composite)destGroup, 8);
        browseButton.setText(Messages.getString("ValgrindExportWizardPage.Browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                DirectoryDialog dialog = new DirectoryDialog(parent);
                dialog.setText(Messages.getString("ValgrindLaunchConfigurationDelegate.Select_Destination"));
                String strpath = dialog.open();
                if (strpath != null) {
                    ValgrindExportWizardPage.this.destText.setText(strpath);
                }
            }
        });
    }

    protected boolean isValid() {
        boolean valid = false;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.viewer.getInput() == null) {
            this.setErrorMessage(Messages.getString("ValgrindExportWizardPage.Err_No_Valgrind_run"));
        } else if (this.destText.getText().equals("")) {
            this.setMessage(Messages.getString("ValgrindExportWizardPage.Msg_Select_destination"));
        } else {
            IPath path = Path.fromOSString((String)this.destText.getText());
            if (!path.toFile().exists()) {
                this.setErrorMessage(NLS.bind((String)Messages.getString("ValgrindExportWizardPage.Err_Dir_not_exist"), (Object)path.toOSString()));
            } else if (!path.toFile().isDirectory()) {
                this.setErrorMessage(NLS.bind((String)Messages.getString("ValgrindExportWizardPage.Err_Not_dir"), (Object)path.toOSString()));
            } else {
                this.outputPath = path;
                valid = true;
            }
        }
        return valid;
    }

    protected ValgrindLaunchPlugin getPlugin() {
        return ValgrindLaunchPlugin.getDefault();
    }

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    public Text getDestText() {
        return this.destText;
    }

    public Button getSelectAllButton() {
        return this.selectAllButton;
    }

    public Button getDeselectAllButton() {
        return this.deselectAllButton;
    }
}

