/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.memcheck;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.internal.valgrind.memcheck.Messages;
import org.eclipse.linuxtools.valgrind.launch.IValgrindToolPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.osgi.framework.Version;

public class MemcheckToolPage
extends AbstractLaunchConfigurationTab
implements IValgrindToolPage {
    public static final String MEMCHECK = "memcheck";
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.memcheck";
    private static final Version VER_3_4_0 = new Version(3, 4, 0);
    protected Button leakCheckButton;
    protected Combo leakResCombo;
    protected Button showReachableButton;
    protected Spinner freelistSpinner;
    protected Button partialLoadsButton;
    protected Button undefValueButton;
    protected Button gccWorkaroundButton;
    protected Button alignmentButton;
    protected Spinner alignmentSpinner;
    protected Button trackOriginsButton;
    protected boolean isInitializing = false;
    protected Version valgrindVersion;
    protected CoreException ex = null;
    protected SelectionListener selectListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MemcheckToolPage.this.updateLaunchConfigurationDialog();
        }
    };
    protected ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MemcheckToolPage.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout memcheckLayout = new GridLayout(2, true);
        top.setLayout((Layout)memcheckLayout);
        top.setLayoutData((Object)new GridData(768));
        this.leakCheckButton = new Button(top, 32);
        this.leakCheckButton.setLayoutData((Object)new GridData(768));
        this.leakCheckButton.setText(Messages.getString("MemcheckToolPage.leak_check"));
        this.leakCheckButton.addSelectionListener(this.selectListener);
        Composite leakResTop = new Composite(top, 0);
        leakResTop.setLayout((Layout)new GridLayout(2, false));
        leakResTop.setLayoutData((Object)new GridData(768));
        Label leakResLabel = new Label(leakResTop, 0);
        leakResLabel.setText(Messages.getString("MemcheckToolPage.leak_resolution"));
        this.leakResCombo = new Combo(leakResTop, 8);
        String[] leakResOpts = new String[]{"low", "med", "high"};
        this.leakResCombo.setItems(leakResOpts);
        this.leakResCombo.addSelectionListener(this.selectListener);
        Composite freelistTop = new Composite(top, 0);
        freelistTop.setLayout((Layout)new GridLayout(2, false));
        freelistTop.setLayoutData((Object)new GridData(768));
        Label freelistLabel = new Label(freelistTop, 0);
        freelistLabel.setText(Messages.getString("MemcheckToolPage.freelist_size"));
        this.freelistSpinner = new Spinner(freelistTop, 2048);
        this.freelistSpinner.setMaximum(Integer.MAX_VALUE);
        this.freelistSpinner.addModifyListener(this.modifyListener);
        this.showReachableButton = new Button(top, 32);
        this.showReachableButton.setLayoutData((Object)new GridData(768));
        this.showReachableButton.setText(Messages.getString("MemcheckToolPage.show_reachable"));
        this.showReachableButton.addSelectionListener(this.selectListener);
        this.partialLoadsButton = new Button(top, 32);
        this.partialLoadsButton.setLayoutData((Object)new GridData(768));
        this.partialLoadsButton.setText(Messages.getString("MemcheckToolPage.allow_partial"));
        this.partialLoadsButton.addSelectionListener(this.selectListener);
        this.undefValueButton = new Button(top, 32);
        this.undefValueButton.setLayoutData((Object)new GridData(768));
        this.undefValueButton.setText(Messages.getString("MemcheckToolPage.undef_value_errors"));
        this.undefValueButton.addSelectionListener(this.selectListener);
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo((Object)VER_3_4_0) >= 0) {
            this.trackOriginsButton = new Button(top, 32);
            this.trackOriginsButton.setLayoutData((Object)new GridData(768));
            this.trackOriginsButton.setText(Messages.getString("MemcheckToolPage.Track_origins"));
            this.trackOriginsButton.addSelectionListener(this.selectListener);
        }
        this.gccWorkaroundButton = new Button(top, 32);
        this.gccWorkaroundButton.setLayoutData((Object)new GridData(768));
        this.gccWorkaroundButton.setText(Messages.getString("MemcheckToolPage.gcc_296_workarounds"));
        this.gccWorkaroundButton.addSelectionListener(this.selectListener);
        Composite alignmentTop = new Composite(top, 0);
        GridLayout alignmentLayout = new GridLayout(2, false);
        alignmentLayout.marginHeight = 0;
        alignmentLayout.marginWidth = 0;
        alignmentTop.setLayout((Layout)alignmentLayout);
        alignmentTop.setLayoutData((Object)new GridData(768));
        this.alignmentButton = new Button(alignmentTop, 32);
        this.alignmentButton.setText(Messages.getString("MemcheckToolPage.minimum_heap_block"));
        this.alignmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemcheckToolPage.this.checkAlignmentEnablement();
                MemcheckToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.alignmentSpinner = new Spinner(alignmentTop, 2048);
        this.alignmentSpinner.setMinimum(0);
        this.alignmentSpinner.setMaximum(4096);
        this.alignmentSpinner.addModifyListener(this.modifyListener);
    }

    private void checkAlignmentEnablement() {
        this.alignmentSpinner.setEnabled(this.alignmentButton.getSelection());
    }

    public String getName() {
        return Messages.getString("MemcheckToolPage.Memcheck_Options");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.isInitializing = true;
        try {
            this.leakCheckButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKCHECK", true));
            this.leakResCombo.setText(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKRES", "low"));
            this.showReachableButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_SHOWREACH", false));
            this.freelistSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREELIST", 10000000));
            this.partialLoadsButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_PARTIAL", false));
            this.undefValueButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_UNDEF", true));
            this.gccWorkaroundButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_GCCWORK", false));
            this.alignmentButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_BOOL", false));
            this.checkAlignmentEnablement();
            this.alignmentSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_VAL", 0));
            if (this.valgrindVersion == null || this.valgrindVersion.compareTo((Object)VER_3_4_0) >= 0) {
                this.trackOriginsButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_TRACKORIGINS", false));
            }
        }
        catch (CoreException e) {
            this.ex = e;
        }
        this.isInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKCHECK", this.leakCheckButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKRES", this.leakResCombo.getText());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_SHOWREACH", this.showReachableButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREELIST", this.freelistSpinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_PARTIAL", this.partialLoadsButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_UNDEF", this.undefValueButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_GCCWORK", this.gccWorkaroundButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_BOOL", this.alignmentButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_VAL", this.alignmentSpinner.getSelection());
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo((Object)VER_3_4_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_TRACKORIGINS", this.trackOriginsButton.getSelection());
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        boolean result = false;
        try {
            boolean trackOrigins;
            int alignment = launchConfig.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_VAL", 0);
            boolean bl = result = (alignment & alignment - 1) == 0;
            if (!result) {
                this.setErrorMessage(Messages.getString("MemcheckToolPage.Alignment_must_be_power_2"));
            } else if ((this.valgrindVersion == null || this.valgrindVersion.compareTo((Object)VER_3_4_0) >= 0) && (trackOrigins = launchConfig.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_TRACKORIGINS", false)) && !(result = launchConfig.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_UNDEF", true))) {
                this.setErrorMessage(NLS.bind((String)Messages.getString("MemcheckToolPage.Track_origins_needs_undef"), (Object)Messages.getString("MemcheckToolPage.Track_origins"), (Object)Messages.getString("MemcheckToolPage.undef_value_errors")));
            }
        }
        catch (CoreException e) {
            this.ex = e;
        }
        if (this.ex != null) {
            this.setErrorMessage(this.ex.getLocalizedMessage());
        }
        return result;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKCHECK", true);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKRES", "low");
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_SHOWREACH", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREELIST", 10000000);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_PARTIAL", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_UNDEF", true);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_GCCWORK", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_BOOL", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_VAL", 0);
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo((Object)VER_3_4_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_TRACKORIGINS", false);
        }
    }

    public void setValgrindVersion(Version ver) {
        this.valgrindVersion = ver;
    }

    protected void createHorizontalSpacer(Composite comp, int numlines) {
        Label lbl = new Label(comp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numlines;
        lbl.setLayoutData((Object)gd);
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }

    public Button getLeakCheckButton() {
        return this.leakCheckButton;
    }

    public Combo getLeakResCombo() {
        return this.leakResCombo;
    }

    public Button getShowReachableButton() {
        return this.showReachableButton;
    }

    public Spinner getFreelistSpinner() {
        return this.freelistSpinner;
    }

    public Button getPartialLoadsButton() {
        return this.partialLoadsButton;
    }

    public Button getUndefValueButton() {
        return this.undefValueButton;
    }

    public Button getGccWorkaroundButton() {
        return this.gccWorkaroundButton;
    }

    public Button getAlignmentButton() {
        return this.alignmentButton;
    }

    public Spinner getAlignmentSpinner() {
        return this.alignmentSpinner;
    }

    public Button getTrackOriginsButton() {
        return this.trackOriginsButton;
    }
}

