/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IResultPie;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.HTMLUtils;
import org.eclipse.mat.util.Units;

public final class PieFactory {
    private ISnapshot snapshot;
    private long totalHeap;
    private long retainedHeapBySlices;
    private List<SliceImpl> slices = new ArrayList<SliceImpl>();

    public PieFactory(ISnapshot snapshot) {
        this(snapshot, snapshot.getSnapshotInfo().getUsedHeapSize());
    }

    public PieFactory(ISnapshot snapshot, long pieSize) {
        this.snapshot = snapshot;
        this.totalHeap = pieSize;
    }

    public PieFactory(long pieSize) {
        this(null, pieSize);
    }

    public IResultPie.Slice addSlice(int objectId) throws SnapshotException {
        if (this.snapshot == null) {
            throw new NullPointerException(Messages.PieFactory_ErrorMsg_NoSnapshotAvailable);
        }
        IObject obj = this.snapshot.getObject(objectId);
        return this.addSlice(obj);
    }

    public IResultPie.Slice addSlice(IObject object) {
        return this.addSlice(object.getObjectId(), object.getDisplayName(), object.getUsedHeapSize(), object.getRetainedHeapSize());
    }

    public IResultPie.Slice addSlice(int objectId, String label, long usedHeapSize, long retainedHeapSize) {
        SliceImpl slice = new SliceImpl(objectId);
        slice.label = label != null ? label : "";
        slice.shallowSize = usedHeapSize;
        slice.retainedSize = retainedHeapSize;
        this.slices.add(slice);
        this.retainedHeapBySlices += slice.retainedSize;
        return slice;
    }

    public IResultPie build() {
        if (this.retainedHeapBySlices < this.totalHeap) {
            SliceImpl rest = new SliceImpl(-1);
            rest.retainedSize = this.totalHeap - this.retainedHeapBySlices;
            this.slices.add(rest);
        }
        return new PieImpl(this.slices);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PieImpl
    implements IResultPie,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<SliceImpl> slices;

        private PieImpl(List<SliceImpl> slices) {
            this.slices = slices;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public List<? extends IResultPie.Slice> getSlices() {
            return this.slices;
        }
    }

    private static final class SliceImpl
    implements IResultPie.Slice,
    Serializable {
        private static final long serialVersionUID = 1L;
        int objectId;
        String label;
        long shallowSize;
        long retainedSize;

        private SliceImpl(int objectId) {
            this.objectId = objectId;
        }

        public String getDescription() {
            StringBuilder buf = new StringBuilder();
            buf.append("<p>").append("<b>").append(HTMLUtils.escapeText((String)this.getLabel())).append("</b></p>");
            if (this.label != null) {
                buf.append("<br/><p>").append(Messages.PieFactory_Label_ShallowSize).append(" <b>");
                buf.append(Units.Storage.of((long)this.shallowSize).format(this.shallowSize));
                buf.append("</b>     ").append(Messages.PieFactory_Label_RetainedSize).append(" <b>");
                buf.append(Units.Storage.of((long)this.retainedSize).format(this.retainedSize));
                buf.append("</b></p>");
            }
            return buf.toString();
        }

        public String getLabel() {
            return this.label != null ? this.label : Messages.PieFactory_Label_Remainder;
        }

        public double getValue() {
            return this.retainedSize;
        }

        public IContextObject getContext() {
            if (this.objectId >= 0) {
                return new IContextObject(){

                    public int getObjectId() {
                        return SliceImpl.this.objectId;
                    }
                };
            }
            return null;
        }
    }
}

