/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.dtfj;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.dtfj.DTFJIndexBuilder;
import org.eclipse.mat.dtfj.MessageFormat;
import org.eclipse.mat.dtfj.Messages;
import org.eclipse.mat.parser.IObjectReader;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.ClassLoaderImpl;
import org.eclipse.mat.parser.model.InstanceImpl;
import org.eclipse.mat.parser.model.ObjectArrayImpl;
import org.eclipse.mat.parser.model.PrimitiveArrayImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTFJHeapObjectReader
implements IObjectReader {
    private static final int LARGE_ARRAY_SIZE = 1000;
    private static final boolean getExtraInfo = true;
    private File file;
    private Image image;
    private JavaRuntime jvm;
    private ImageAddressSpace addrSpace;
    private ImageProcess process;
    private static final boolean throwExceptions = true;

    public void close() throws IOException {
        this.image = null;
        this.jvm = null;
        this.addrSpace = null;
        DTFJIndexBuilder.releaseDump(this.file, true);
    }

    public <A> A getAddon(Class<A> addon) throws SnapshotException {
        if (this.image != null && addon.isAssignableFrom(this.image.getClass())) {
            return addon.cast(this.image);
        }
        if (this.jvm != null && addon.isAssignableFrom(this.jvm.getClass())) {
            return addon.cast(this.jvm);
        }
        if (this.addrSpace != null && addon.isAssignableFrom(this.addrSpace.getClass())) {
            return addon.cast(this.addrSpace);
        }
        if (this.process != null && addon.isAssignableFrom(this.process.getClass())) {
            return addon.cast(this.process);
        }
        return null;
    }

    public void open(ISnapshot snapshot) throws IOException {
        this.file = new File(snapshot.getSnapshotInfo().getPath());
        this.image = DTFJIndexBuilder.getDump(this.file, snapshot.getSnapshotInfo().getProperty("$heapFormat"));
        DTFJIndexBuilder.RuntimeInfo info = DTFJIndexBuilder.getRuntime(this.image, null);
        this.addrSpace = info.imageAddressSpace;
        this.process = info.imageProcess;
        this.jvm = info.javaRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObject read(int objectId, ISnapshot snapshot) throws SnapshotException, IOException {
        long addr = snapshot.mapIdToAddress(objectId);
        try {
            Image image = this.image;
            synchronized (image) {
                IObject ret;
                ClassImpl cls = (ClassImpl)snapshot.getClassOf(objectId);
                if (cls.getName().contains("(") && (ret = this.createObject2(snapshot, objectId, addr, cls)) != null) {
                    return ret;
                }
                JavaObject jo = this.getJavaObjectByAddress0(addr);
                Object inst = snapshot.isArray(objectId) ? this.createArray(snapshot, objectId, addr, jo) : this.createObject(snapshot, objectId, addr, jo);
                return inst;
            }
        }
        catch (MemoryAccessException e) {
            throw new SnapshotException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectAtIndex, objectId, DTFJHeapObjectReader.format(addr)), (Throwable)e);
        }
        catch (CorruptDataException e) {
            throw new SnapshotException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectAtIndex, objectId, DTFJHeapObjectReader.format(addr)), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SnapshotException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectAtIndex, objectId, DTFJHeapObjectReader.format(addr)), (Throwable)e);
        }
    }

    private IObject createObject2(ISnapshot snapshot, int objectId, long addr, ClassImpl cls) {
        long prevFrameAddress = 0L;
        Iterator i = this.jvm.getThreads();
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof CorruptData) continue;
            JavaThread jt = (JavaThread)next;
            int pointerSize = snapshot.getSnapshotInfo().getIdentifierSize() * 8;
            int totalDepth = 0;
            Iterator j = jt.getStackFrames();
            while (j.hasNext()) {
                j.next();
                ++totalDepth;
            }
            int depth = 0;
            Iterator j2 = jt.getStackFrames();
            while (j2.hasNext()) {
                Object next2 = j2.next();
                if (!(next2 instanceof CorruptData)) {
                    long currAddr;
                    JavaStackFrame jsf = (JavaStackFrame)next2;
                    prevFrameAddress = currAddr = DTFJIndexBuilder.getFrameAddress(jsf, prevFrameAddress, pointerSize);
                    if (currAddr == addr) {
                        Field f;
                        JavaLocation jl;
                        ArrayList<Field> fields = new ArrayList<Field>();
                        try {
                            jl = jsf.getLocation();
                            f = new Field("lineNumber", 10, (Object)jl.getLineNumber());
                            fields.add(f);
                        }
                        catch (DataUnavailable dataUnavailable) {
                        }
                        catch (CorruptDataException corruptDataException) {}
                        try {
                            jl = jsf.getLocation();
                            f = new Field("compilationLevel", 10, (Object)jl.getCompilationLevel());
                            fields.add(f);
                        }
                        catch (ClassCastException classCastException) {
                        }
                        catch (CorruptDataException corruptDataException) {}
                        try {
                            jl = jsf.getLocation();
                            f = new Field("locationAddress", 11, (Object)jl.getAddress().getAddress());
                            fields.add(f);
                        }
                        catch (ClassCastException classCastException) {
                        }
                        catch (CorruptDataException corruptDataException) {}
                        Field f2 = new Field("frameNumber", 10, (Object)depth);
                        fields.add(f2);
                        f2 = new Field("stackDepth", 10, (Object)(totalDepth - depth));
                        fields.add(f2);
                        InstanceImpl inst = new InstanceImpl(objectId, addr, cls, fields);
                        return inst;
                    }
                }
                ++depth;
            }
        }
        return null;
    }

    private JavaObject getJavaObjectByAddress0(long addr) throws CorruptDataException, MemoryAccessException {
        ImagePointer ip = this.addrSpace.getPointer(addr);
        try {
            JavaObject jo = this.jvm.getObjectAtAddress(ip);
            return jo;
        }
        catch (DataUnavailable dataUnavailable) {
            return this.getJavaObjectByAddress(addr);
        }
        catch (LinkageError linkageError) {
            return this.getJavaObjectByAddress(addr);
        }
    }

    private JavaObject getJavaObjectByAddress(long addr) {
        Object next;
        Iterator i = this.jvm.getThreads();
        while (i.hasNext()) {
            JavaObject jo;
            JavaThread thrd;
            long thAddr;
            next = i.next();
            if (next instanceof CorruptData || addr != (thAddr = DTFJIndexBuilder.getThreadAddress(thrd = (JavaThread)next, null))) continue;
            try {
                jo = thrd.getObject();
            }
            catch (CorruptDataException corruptDataException) {
                jo = null;
            }
            return jo;
        }
        i = this.jvm.getMonitors();
        while (i.hasNext()) {
            JavaMonitor mon;
            JavaObject jo;
            next = i.next();
            if (next instanceof CorruptData || (jo = (mon = (JavaMonitor)next).getObject()) == null || jo.getID().getAddress() != addr) continue;
            return jo;
        }
        i = this.jvm.getJavaClassLoaders();
        while (i.hasNext()) {
            next = i.next();
            if (next instanceof CorruptData) continue;
            JavaClassLoader ldr = (JavaClassLoader)next;
            try {
                JavaObject jo = ldr.getObject();
                if (jo == null || jo.getID().getAddress() != addr) continue;
                return jo;
            }
            catch (CorruptDataException corruptDataException) {}
        }
        i = this.jvm.getHeaps();
        while (i.hasNext()) {
            next = i.next();
            if (next instanceof CorruptData) continue;
            JavaHeap jh = (JavaHeap)next;
            Iterator j = jh.getObjects();
            while (j.hasNext()) {
                JavaObject jo;
                Object next2 = j.next();
                if (next2 instanceof CorruptData || (jo = (JavaObject)next2).getID().getAddress() != addr) continue;
                return jo;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.DTFJHeapObjectReader_JavaObjectAtAddressNotFound, DTFJHeapObjectReader.format(addr)));
    }

    private InstanceImpl createObject(ISnapshot snapshot, int objectId, long addr, JavaObject jo) throws CorruptDataException, MemoryAccessException, SnapshotException {
        ClassImpl cls = (ClassImpl)snapshot.getClassOf(objectId);
        int nFields = 0;
        ClassImpl cls2 = cls;
        while (cls2 != null) {
            nFields += cls2.getFieldDescriptors().size();
            cls2 = cls2.getSuperClass();
        }
        ArrayList<Field> fields = new ArrayList<Field>(nFields);
        if (nFields > 0) {
            JavaClass jc = jo.getJavaClass();
            while (jc != null) {
                Iterator ii = jc.getDeclaredFields();
                while (ii.hasNext()) {
                    JavaField jf;
                    Object next = ii.next();
                    if (next instanceof CorruptData || Modifier.isStatic((jf = (JavaField)next).getModifiers())) continue;
                    Object val = null;
                    try {
                        Object o = jf.get(jo);
                        if (o instanceof JavaObject) {
                            JavaObject jo2 = (JavaObject)o;
                            long addr2 = jo2.getID().getAddress();
                            val = new ObjectReference(snapshot, addr2);
                        } else if (o instanceof Number || o instanceof Character || o instanceof Boolean || o == null) {
                            val = o;
                        }
                    }
                    catch (CorruptDataException e) {
                        this.logOrThrow(e);
                    }
                    catch (MemoryAccessException e) {
                        this.logOrThrow(e);
                    }
                    Field f = new Field(jf.getName(), DTFJIndexBuilder.signatureToType(jf.getSignature()), val);
                    fields.add(f);
                }
                jc = this.getSuperclass(jc);
            }
        }
        Object inst = snapshot.isClassLoader(objectId) ? new ClassLoaderImpl(objectId, addr, cls, fields) : new InstanceImpl(objectId, addr, cls, fields);
        return inst;
    }

    private JavaClass getSuperclass(JavaClass jc) throws CorruptDataException {
        try {
            return jc.getSuperclass();
        }
        catch (CorruptDataException corruptDataException) {
            return null;
        }
    }

    private IObject createArray(ISnapshot snapshot, int objectId, long addr, JavaObject jo) throws CorruptDataException, MemoryAccessException, SnapshotException {
        ClassImpl cls = (ClassImpl)snapshot.getClassOf(objectId);
        int offset = 0;
        int length = jo.getArraySize();
        JavaClass arrayClass = jo.getJavaClass();
        if (DTFJIndexBuilder.isPrimitiveArray(arrayClass)) {
            String typeName = arrayClass.getName();
            int type = this.getArrayType(typeName);
            Object res = length < 1000 ? this.getPrimitiveData(jo, type, offset, length) : new DeferredReadArray(objectId, addr, jo);
            PrimitiveArrayImpl ret = new PrimitiveArrayImpl(objectId, addr, cls, length, type);
            ret.setInfo(res);
            return ret;
        }
        Serializable format = snapshot.getSnapshotInfo().getProperty("$heapFormat");
        Object res = !"DTFJ-PHD".equals(format) && length < 1000 ? (Object)this.getObjectData(jo, offset, length) : new DeferredReadArray(objectId, addr, jo);
        ObjectArrayImpl ret = new ObjectArrayImpl(objectId, addr, cls, length);
        ret.setInfo(res);
        return ret;
    }

    private long[] getObjectData(JavaObject jo, int offset, int length) throws CorruptDataException, MemoryAccessException {
        JavaObject[] temp = new JavaObject[length];
        try {
            jo.arraycopy(offset, (Object)temp, 0, length);
        }
        catch (MemoryAccessException e) {
            this.logOrThrow(e);
        }
        long[] res = new long[length];
        int i = 0;
        while (i < length) {
            long addr2;
            res[i] = addr2 = temp[i] == null ? 0L : temp[i].getID().getAddress();
            ++i;
        }
        return res;
    }

    private int getArrayType(String typeName) {
        int type;
        if (typeName.equals("[Z") || typeName.equals("[boolean")) {
            type = 4;
        } else if (typeName.equals("[B") || typeName.equals("[byte")) {
            type = 8;
        } else if (typeName.equals("[C") || typeName.equals("[char")) {
            type = 5;
        } else if (typeName.equals("[S") || typeName.equals("[short")) {
            type = 9;
        } else if (typeName.equals("[I") || typeName.equals("[int")) {
            type = 10;
        } else if (typeName.equals("[F") || typeName.equals("[float")) {
            type = 6;
        } else if (typeName.equals("[J") || typeName.equals("[long")) {
            type = 11;
        } else if (typeName.equals("[D") || typeName.equals("[double")) {
            type = 7;
        } else {
            int type2 = 8;
            throw new IllegalArgumentException(MessageFormat.format(Messages.DTFJHeapObjectReader_UnexpectedTypeName, typeName));
        }
        return type;
    }

    private Object getPrimitiveData(JavaObject jo, int type, int offset, int length) throws CorruptDataException, MemoryAccessException {
        Object[] res;
        switch (type) {
            case 4: {
                res = new boolean[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 8: {
                res = new byte[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 5: {
                res = new char[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 9: {
                res = new short[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 10: {
                res = new int[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 6: {
                res = new float[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 11: {
                res = new long[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 7: {
                res = new double[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(Messages.DTFJHeapObjectReader_UnexpectedType, type));
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readPrimitiveArrayContent(PrimitiveArrayImpl array, int offset, int length) throws IOException, SnapshotException {
        Object res;
        block7: {
            Object info = array.getInfo();
            if (info instanceof DeferredReadArray) {
                DeferredReadArray da = (DeferredReadArray)info;
                try {
                    Image image = this.image;
                    synchronized (image) {
                        res = this.getPrimitiveData(da.getJo(), array.getType(), offset, length);
                        break block7;
                    }
                }
                catch (CorruptDataException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingPrimitiveArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
                catch (MemoryAccessException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingPrimitiveArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
            }
            res = Array.newInstance(info.getClass().getComponentType(), length);
            System.arraycopy(info, offset, res, 0, length);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] readObjectArrayContent(ObjectArrayImpl array, int offset, int length) throws IOException, SnapshotException {
        long[] res;
        block7: {
            Object info = array.getInfo();
            if (info instanceof DeferredReadArray) {
                DeferredReadArray da = (DeferredReadArray)info;
                try {
                    Image image = this.image;
                    synchronized (image) {
                        res = this.getObjectData(da.getJo(), offset, length);
                        break block7;
                    }
                }
                catch (CorruptDataException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
                catch (MemoryAccessException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
            }
            res = new long[length];
            System.arraycopy(info, offset, res, 0, length);
        }
        return res;
    }

    private static String format(long address) {
        return "0x" + Long.toHexString(address);
    }

    private void logOrThrow(MemoryAccessException e) throws MemoryAccessException {
        throw e;
    }

    private void logOrThrow(CorruptDataException e) throws CorruptDataException {
        throw e;
    }

    static class DeferredReadArray {
        private int objectId;
        private long addr;
        private JavaObject jo;

        public DeferredReadArray(int objectId, long addr, JavaObject jo) {
            this.setObjectId(objectId);
            this.setAddr(addr);
            this.setJo(jo);
        }

        private void setObjectId(int objectId) {
            this.objectId = objectId;
        }

        int getObjectId() {
            return this.objectId;
        }

        private void setAddr(long addr) {
            this.addr = addr;
        }

        long getAddr() {
            return this.addr;
        }

        private void setJo(JavaObject jo) {
            this.jo = jo;
        }

        JavaObject getJo() {
            return this.jo;
        }
    }
}

