/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof.acquire;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.acquire.JmapVmInfo;
import org.eclipse.mat.hprof.acquire.LocalJavaProcessesUtils;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.util.IProgressListener;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMapHeapDumpProvider
implements IHeapDumpProvider {
    private static final String PLUGIN_ID = "org.eclipse.mat.hprof";
    private static final String LAST_JDK_DIRECTORY_KEY = String.valueOf(JMapHeapDumpProvider.class.getName()) + ".lastJDKDir";
    private static final String LAST_JMAP_JDK_DIRECTORY_KEY = String.valueOf(JMapHeapDumpProvider.class.getName()) + ".lastJmapJDKDir";
    private static final String FILE_PATTERN = "java_pid%pid%.hprof";
    @Argument(isMandatory=false, advice=Argument.Advice.DIRECTORY)
    public File jdkHome = this.readSavedLocation(LAST_JDK_DIRECTORY_KEY);

    public JMapHeapDumpProvider() {
        if (this.jdkHome == null) {
            this.jdkHome = this.guessJDK();
        }
    }

    public File acquireDump(VmInfo info, File preferredLocation, IProgressListener listener) throws SnapshotException {
        JmapVmInfo jmapProcessInfo = (JmapVmInfo)info;
        listener.beginTask(Messages.JMapHeapDumpProvider_WaitForHeapDump, -1);
        String jmap = "jmap";
        if (jmapProcessInfo.jdkHome != null && jmapProcessInfo.jdkHome.exists()) {
            jmap = String.valueOf(jmapProcessInfo.jdkHome.getAbsolutePath()) + File.separator + "bin" + File.separator + "jmap";
            this.persistJDKLocation(LAST_JMAP_JDK_DIRECTORY_KEY, jmapProcessInfo.jdkHome.getAbsolutePath());
        }
        String[] execLine = new String[]{jmap, "-dump:format=b,file=" + preferredLocation.getAbsolutePath(), String.valueOf(info.getPid())};
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("Executing { ");
        int i = 0;
        while (i < execLine.length) {
            logMessage.append("\"").append(execLine[i]).append("\"");
            if (i < execLine.length - 1) {
                logMessage.append(", ");
            }
            ++i;
        }
        logMessage.append(" }");
        Logger.getLogger(this.getClass().getName()).info(logMessage.toString());
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(execLine);
            LocalJavaProcessesUtils.StreamCollector error = new LocalJavaProcessesUtils.StreamCollector(p.getErrorStream());
            error.start();
            LocalJavaProcessesUtils.StreamCollector output = new LocalJavaProcessesUtils.StreamCollector(p.getInputStream());
            output.start();
            if (listener.isCanceled()) {
                return null;
            }
            try {
                int exitCode = p.waitFor();
                if (exitCode != 0) {
                    throw new SnapshotException(String.valueOf(Messages.JMapHeapDumpProvider_ErrorCreatingDump) + exitCode + "\r\n" + error.buf.toString());
                }
                if (!preferredLocation.exists()) {
                    throw new SnapshotException(String.valueOf(Messages.JMapHeapDumpProvider_HeapDumpNotCreated) + exitCode + "\r\nstdout:\r\n" + output.buf.toString() + "\r\nstderr:\r\n" + error.buf.toString());
                }
            }
            catch (IOException ioe) {
                throw new SnapshotException(Messages.JMapHeapDumpProvider_ErrorCreatingDump, (Throwable)ioe);
            }
            catch (InterruptedException ie) {
                throw new SnapshotException(Messages.JMapHeapDumpProvider_ErrorCreatingDump, (Throwable)ie);
            }
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        listener.done();
        return preferredLocation;
    }

    public List<JmapVmInfo> getAvailableVMs(IProgressListener listener) throws SnapshotException {
        if (this.jdkHome != null && this.jdkHome.exists()) {
            this.persistJDKLocation(LAST_JDK_DIRECTORY_KEY, this.jdkHome.getAbsolutePath());
        }
        ArrayList<JmapVmInfo> result = new ArrayList<JmapVmInfo>();
        List<JmapVmInfo> jvms = LocalJavaProcessesUtils.getLocalVMsUsingJPS(this.jdkHome);
        if (jvms != null) {
            File jmapJdkHome = this.readSavedLocation(LAST_JMAP_JDK_DIRECTORY_KEY);
            if (jmapJdkHome == null) {
                jmapJdkHome = this.jdkHome;
            }
            for (JmapVmInfo vmInfo : jvms) {
                vmInfo.setProposedFileName(FILE_PATTERN);
                vmInfo.setHeapDumpProvider(this);
                vmInfo.jdkHome = jmapJdkHome;
                result.add(vmInfo);
            }
        }
        return result;
    }

    private void persistJDKLocation(String key, String value) {
        IEclipsePreferences prefs = new InstanceScope().getNode(PLUGIN_ID);
        prefs.put(key, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private File readSavedLocation(String key) {
        String lastDir = Platform.getPreferencesService().getString(PLUGIN_ID, key, "", null);
        if (lastDir != null && !lastDir.trim().equals("")) {
            return new File(lastDir);
        }
        return null;
    }

    private File guessJDK() {
        String javaHomeProperty = System.getProperty("java.home");
        File parentFolder = new File(javaHomeProperty).getParentFile();
        File binDir = new File(parentFolder + File.separator + "bin");
        if (binDir.exists()) {
            return parentFolder;
        }
        return null;
    }
}

